/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.rdknn;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.SpatialPrimitiveDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.EuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.AbstractRStarTreeFactory;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.rdknn.RdKNNEntry;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.rdknn.RdKNNNode;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.rdknn.RdKNNTree;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.rdknn.RdkNNSettings;
import de.lmu.ifi.dbs.elki.persistent.PageFile;
import de.lmu.ifi.dbs.elki.persistent.PageFileFactory;
import de.lmu.ifi.dbs.elki.utilities.ClassGenericsUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;

public class RdKNNTreeFactory<O extends NumberVector>
extends AbstractRStarTreeFactory<O, RdKNNNode, RdKNNEntry, RdkNNSettings> {
    public static final OptionID K_ID = new OptionID("rdknn.k", "positive integer specifying the maximal number k of reverse k nearest neighbors to be supported.");
    public static final Class<?> DEFAULT_DISTANCE_FUNCTION = EuclideanDistanceFunction.class;
    public static final OptionID DISTANCE_FUNCTION_ID = new OptionID("rdknn.distancefunction", "Distance function to determine the distance between database objects.");

    public RdKNNTreeFactory(PageFileFactory<?> pageFileFactory, RdkNNSettings settings) {
        super(pageFileFactory, settings);
    }

    public RdKNNTree<O> instantiate(Relation<O> relation) {
        PageFile<RdKNNNode> pagefile = this.makePageFile(this.getNodeClass());
        RdKNNTree<O> index = new RdKNNTree<O>(relation, pagefile, (RdkNNSettings)this.settings);
        return index;
    }

    protected Class<RdKNNNode> getNodeClass() {
        return ClassGenericsUtil.uglyCastIntoSubclass(RdKNNNode.class);
    }

    public static class Parameterizer<O extends NumberVector>
    extends AbstractRStarTreeFactory.Parameterizer<O, RdkNNSettings> {
        @Override
        protected void makeOptions(Parameterization config) {
            ObjectParameter distanceFunctionP;
            super.makeOptions(config);
            IntParameter k_maxP = new IntParameter(K_ID);
            k_maxP.addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (config.grab(k_maxP)) {
                ((RdkNNSettings)this.settings).k_max = k_maxP.intValue();
            }
            if (config.grab(distanceFunctionP = new ObjectParameter(DISTANCE_FUNCTION_ID, (Class<?>)SpatialPrimitiveDistanceFunction.class, DEFAULT_DISTANCE_FUNCTION))) {
                ((RdkNNSettings)this.settings).distanceFunction = (SpatialPrimitiveDistanceFunction)distanceFunctionP.instantiateClass(config);
            }
        }

        @Override
        protected RdKNNTreeFactory<O> makeInstance() {
            return new RdKNNTreeFactory(this.pageFileFactory, (RdkNNSettings)this.settings);
        }

        @Override
        protected RdkNNSettings createSettings() {
            return new RdkNNSettings(1, EuclideanDistanceFunction.STATIC);
        }
    }
}

