/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.rstar;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.distance.SpatialDistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.query.range.RangeQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.index.DynamicIndex;
import de.lmu.ifi.dbs.elki.index.KNNIndex;
import de.lmu.ifi.dbs.elki.index.RangeIndex;
import de.lmu.ifi.dbs.elki.index.tree.IndexTreePath;
import de.lmu.ifi.dbs.elki.index.tree.spatial.SpatialPointLeafEntry;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.RTreeSettings;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.query.RStarTreeUtil;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.rstar.RStarTree;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.rstar.RStarTreeNode;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.persistent.PageFile;
import java.util.ArrayList;

public class RStarTreeIndex<O extends NumberVector>
extends RStarTree
implements RangeIndex<O>,
KNNIndex<O>,
DynamicIndex {
    private static final Logging LOG = Logging.getLogger(RStarTreeIndex.class);
    private Relation<O> relation;

    public RStarTreeIndex(Relation<O> relation, PageFile<RStarTreeNode> pagefile, RTreeSettings settings) {
        super(pagefile, settings);
        this.relation = relation;
    }

    protected SpatialPointLeafEntry createNewLeafEntry(DBIDRef id) {
        return new SpatialPointLeafEntry(DBIDUtil.deref(id), (NumberVector)this.relation.get(id));
    }

    @Override
    public void initialize() {
        super.initialize();
        this.insertAll(this.relation.getDBIDs());
    }

    @Override
    public void insert(DBIDRef id) {
        this.insertLeaf(this.createNewLeafEntry(id));
    }

    @Override
    public void insertAll(DBIDs ids) {
        if (ids.isEmpty()) {
            return;
        }
        if (this.canBulkLoad()) {
            ArrayList<SpatialPointLeafEntry> leafs = new ArrayList<SpatialPointLeafEntry>(ids.size());
            DBIDIter iter = ids.iter();
            while (iter.valid()) {
                leafs.add(this.createNewLeafEntry(iter));
                iter.advance();
            }
            this.bulkLoad(leafs);
        } else {
            DBIDIter iter = ids.iter();
            while (iter.valid()) {
                this.insert(DBIDUtil.deref(iter));
                iter.advance();
            }
        }
        this.doExtraIntegrityChecks();
    }

    @Override
    public boolean delete(DBIDRef id) {
        NumberVector obj = (NumberVector)this.relation.get(id);
        IndexTreePath deletionPath = this.findPathToObject(this.getRootPath(), obj, id);
        if (deletionPath == null) {
            return false;
        }
        this.deletePath(deletionPath);
        return true;
    }

    @Override
    public void deleteAll(DBIDs ids) {
        DBIDIter iter = ids.iter();
        while (iter.valid()) {
            this.delete(iter);
            iter.advance();
        }
    }

    @Override
    public RangeQuery<O> getRangeQuery(DistanceQuery<O> distanceQuery, Object ... hints) {
        if (distanceQuery.getRelation() != this.relation) {
            return null;
        }
        if (!(distanceQuery instanceof SpatialDistanceQuery)) {
            return null;
        }
        SpatialDistanceQuery dq = (SpatialDistanceQuery)distanceQuery;
        return RStarTreeUtil.getRangeQuery(this, dq, hints);
    }

    @Override
    public KNNQuery<O> getKNNQuery(DistanceQuery<O> distanceQuery, Object ... hints) {
        if (distanceQuery.getRelation() != this.relation) {
            return null;
        }
        if (!(distanceQuery instanceof SpatialDistanceQuery)) {
            return null;
        }
        SpatialDistanceQuery dq = (SpatialDistanceQuery)distanceQuery;
        return RStarTreeUtil.getKNNQuery(this, dq, hints);
    }

    @Override
    public String getLongName() {
        return "R*-Tree";
    }

    @Override
    public String getShortName() {
        return "rstartree";
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }
}

