/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.strategies.bulk;

import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.strategies.bulk.AbstractBulkSplit;
import de.lmu.ifi.dbs.elki.math.spacefillingcurves.SpatialSorter;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import java.util.List;

@Reference(authors="I. Kamel, C. Faloutsos", title="On packing R-trees", booktitle="Proc. 2nd Int. Conf. on Information and Knowledge Management", url="https://doi.org/10.1145/170088.170403", bibkey="DBLP:conf/cikm/KamelF93")
public class SpatialSortBulkSplit
extends AbstractBulkSplit {
    final SpatialSorter sorter;

    protected SpatialSortBulkSplit(SpatialSorter sorter) {
        this.sorter = sorter;
    }

    @Override
    public <T extends SpatialComparable> List<List<T>> partition(List<T> spatialObjects, int minEntries, int maxEntries) {
        this.sorter.sort(spatialObjects);
        return super.trivialPartition(spatialObjects, minEntries, maxEntries);
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID SORTER_ID = new OptionID("rtree.bulk.spatial-sort", "Strategy for spatial sorting in bulk loading.");
        SpatialSorter sorter;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            ObjectParameter sorterP = new ObjectParameter(SORTER_ID, SpatialSorter.class);
            if (config.grab(sorterP)) {
                this.sorter = (SpatialSorter)sorterP.instantiateClass(config);
            }
        }

        @Override
        protected SpatialSortBulkSplit makeInstance() {
            return new SpatialSortBulkSplit(this.sorter);
        }
    }
}

