/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.strategies.insert;

import de.lmu.ifi.dbs.elki.data.ModifiableHyperBoundingBox;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialUtil;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.strategies.insert.LeastOverlapInsertionStrategy;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.ArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.datastructures.heap.TopBoundedHeap;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.pairs.DoubleIntPair;
import java.util.Collections;

@Reference(authors="Norbert Beckmann, Hans-Peter Kriegel, Ralf Schneider, Bernhard Seeger", title="The R*-tree: an efficient and robust access method for points and rectangles", booktitle="Proc. 1990 ACM SIGMOD Int. Conf. Management of Data", url="https://doi.org/10.1145/93597.98741", bibkey="DBLP:conf/sigmod/BeckmannKSS90")
public class ApproximativeLeastOverlapInsertionStrategy
extends LeastOverlapInsertionStrategy {
    private int numCandidates = 32;

    public ApproximativeLeastOverlapInsertionStrategy(int candidates) {
        this.numCandidates = candidates;
    }

    @Override
    public <A> int choose(A options, ArrayAdapter<? extends SpatialComparable, A> getter, SpatialComparable obj, int height, int depth) {
        int size = getter.size(options);
        assert (size > 0) : "Choose from empty set?";
        if (size <= this.numCandidates) {
            return super.choose(options, getter, obj, height, depth);
        }
        TopBoundedHeap candidates = new TopBoundedHeap(this.numCandidates, Collections.reverseOrder());
        for (int i = 0; i < size; ++i) {
            SpatialComparable entry = getter.get(options, i);
            ModifiableHyperBoundingBox mbr = SpatialUtil.union(entry, obj);
            double inc_area = SpatialUtil.volume(mbr) - SpatialUtil.volume(entry);
            candidates.add(new DoubleIntPair(inc_area, i));
        }
        int best = -1;
        double least_overlap = Double.POSITIVE_INFINITY;
        double least_areainc = Double.POSITIVE_INFINITY;
        double least_area = Double.POSITIVE_INFINITY;
        while (!candidates.isEmpty()) {
            double area;
            DoubleIntPair pair = (DoubleIntPair)candidates.poll();
            double inc_area = pair.first;
            SpatialComparable entry = getter.get(options, pair.second);
            ModifiableHyperBoundingBox mbr = SpatialUtil.union(entry, obj);
            double overlap_wout = 0.0;
            double overlap_with = 0.0;
            for (int k = 0; k < size; ++k) {
                if (pair.second == k) continue;
                SpatialComparable other = getter.get(options, k);
                overlap_wout += SpatialUtil.relativeOverlap(entry, other);
                overlap_with += SpatialUtil.relativeOverlap(mbr, other);
            }
            double inc_overlap = overlap_with - overlap_wout;
            if (inc_overlap < least_overlap) {
                area = SpatialUtil.volume(entry);
                least_overlap = inc_overlap;
                least_areainc = inc_area;
                least_area = area;
                best = pair.second;
                continue;
            }
            if (inc_overlap != least_overlap) continue;
            area = SpatialUtil.volume(entry);
            if (!(inc_area < least_areainc) && (inc_area != least_areainc || !(area < least_area))) continue;
            least_overlap = inc_overlap;
            least_areainc = inc_area;
            least_area = area;
            best = pair.second;
        }
        assert (best > -1) : "No split found? Volume outside of double precision?";
        return best;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static OptionID INSERTION_CANDIDATES_ID = new OptionID("rtree.insertion-candidates", "defines how many children are tested for finding the child generating the least overlap when inserting an object.");
        int numCandidates = 32;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            IntParameter insertionCandidatesP = (IntParameter)new IntParameter(INSERTION_CANDIDATES_ID, this.numCandidates).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (config.grab(insertionCandidatesP)) {
                this.numCandidates = (Integer)insertionCandidatesP.getValue();
            }
        }

        @Override
        protected ApproximativeLeastOverlapInsertionStrategy makeInstance() {
            return new ApproximativeLeastOverlapInsertionStrategy(this.numCandidates);
        }
    }
}

