/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.strategies.insert;

import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.strategies.insert.InsertionStrategy;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.strategies.insert.LeastEnlargementWithAreaInsertionStrategy;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.strategies.insert.LeastOverlapInsertionStrategy;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.ArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ClassParameter;

@Reference(authors="Norbert Beckmann, Hans-Peter Kriegel, Ralf Schneider, Bernhard Seeger", title="The R*-tree: an efficient and robust access method for points and rectangles", booktitle="Proc. 1990 ACM SIGMOD Int. Conf. Management of Data", url="https://doi.org/10.1145/93597.98741", bibkey="DBLP:conf/sigmod/BeckmannKSS90")
public class CombinedInsertionStrategy
implements InsertionStrategy {
    InsertionStrategy dirStrategy;
    InsertionStrategy leafStrategy;

    public CombinedInsertionStrategy(InsertionStrategy dirStrategy, InsertionStrategy leafStrategy) {
        this.dirStrategy = dirStrategy;
        this.leafStrategy = leafStrategy;
    }

    @Override
    public <A> int choose(A options, ArrayAdapter<? extends SpatialComparable, A> getter, SpatialComparable obj, int height, int depth) {
        if (depth + 1 >= height) {
            return this.leafStrategy.choose(options, getter, obj, height, depth);
        }
        return this.dirStrategy.choose(options, getter, obj, height, depth);
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID DIR_STRATEGY_ID = new OptionID("rtree.insert-directory", "Insertion strategy for directory nodes.");
        public static final OptionID LEAF_STRATEGY_ID = new OptionID("rtree.insert-leaf", "Insertion strategy for leaf nodes.");
        InsertionStrategy dirStrategy;
        InsertionStrategy leafStrategy;

        @Override
        protected void makeOptions(Parameterization config) {
            ClassParameter leafP;
            super.makeOptions(config);
            ClassParameter dirP = new ClassParameter(DIR_STRATEGY_ID, InsertionStrategy.class, LeastEnlargementWithAreaInsertionStrategy.class);
            if (config.grab(dirP)) {
                this.dirStrategy = (InsertionStrategy)dirP.instantiateClass(config);
            }
            if (config.grab(leafP = new ClassParameter(LEAF_STRATEGY_ID, InsertionStrategy.class, LeastOverlapInsertionStrategy.class))) {
                this.leafStrategy = (InsertionStrategy)leafP.instantiateClass(config);
            }
        }

        @Override
        protected CombinedInsertionStrategy makeInstance() {
            return new CombinedInsertionStrategy(this.dirStrategy, this.leafStrategy);
        }
    }
}

