/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.strategies.insert;

import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialUtil;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.strategies.insert.InsertionStrategy;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.ArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Reference(authors="Norbert Beckmann, Hans-Peter Kriegel, Ralf Schneider, Bernhard Seeger", title="The R*-tree: an efficient and robust access method for points and rectangles", booktitle="Proc. 1990 ACM SIGMOD Int. Conf. Management of Data", url="https://doi.org/10.1145/93597.98741", bibkey="DBLP:conf/sigmod/BeckmannKSS90")
public class LeastEnlargementWithAreaInsertionStrategy
implements InsertionStrategy {
    public static final LeastEnlargementWithAreaInsertionStrategy STATIC = new LeastEnlargementWithAreaInsertionStrategy();

    @Override
    public <A> int choose(A options, ArrayAdapter<? extends SpatialComparable, A> getter, SpatialComparable obj, int height, int depth) {
        int size = getter.size(options);
        assert (size > 0) : "Choose from empty set?";
        double leastEnlargement = Double.POSITIVE_INFINITY;
        double minArea = -1.0;
        int best = -1;
        for (int i = 0; i < size; ++i) {
            double area;
            SpatialComparable entry = getter.get(options, i);
            double enlargement = SpatialUtil.enlargement(entry, obj);
            if (enlargement < leastEnlargement) {
                leastEnlargement = enlargement;
                best = i;
                minArea = SpatialUtil.volume(entry);
                continue;
            }
            if (enlargement != leastEnlargement || !((area = SpatialUtil.volume(entry)) < minArea)) continue;
            best = i;
            minArea = area;
        }
        assert (best > -1);
        return best;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected LeastEnlargementWithAreaInsertionStrategy makeInstance() {
            return STATIC;
        }
    }
}

