/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.strategies.insert;

import de.lmu.ifi.dbs.elki.data.ModifiableHyperBoundingBox;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialUtil;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.strategies.insert.InsertionStrategy;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.ArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Reference(authors="Norbert Beckmann, Hans-Peter Kriegel, Ralf Schneider, Bernhard Seeger", title="The R*-tree: an efficient and robust access method for points and rectangles", booktitle="Proc. 1990 ACM SIGMOD Int. Conf. Management of Data", url="https://doi.org/10.1145/93597.98741", bibkey="DBLP:conf/sigmod/BeckmannKSS90")
public class LeastOverlapInsertionStrategy
implements InsertionStrategy {
    public static final LeastOverlapInsertionStrategy STATIC = new LeastOverlapInsertionStrategy();

    @Override
    public <A> int choose(A options, ArrayAdapter<? extends SpatialComparable, A> getter, SpatialComparable obj, int height, int depth) {
        int size = getter.size(options);
        assert (size > 0) : "Choose from empty set?";
        int best = -1;
        double least_overlap = Double.POSITIVE_INFINITY;
        double least_areainc = Double.POSITIVE_INFINITY;
        double least_area = Double.POSITIVE_INFINITY;
        for (int i = 0; i < size; ++i) {
            double inc_area;
            double area;
            SpatialComparable entry = getter.get(options, i);
            ModifiableHyperBoundingBox mbr = SpatialUtil.union(entry, obj);
            double overlap_wout = 0.0;
            double overlap_with = 0.0;
            for (int k = 0; k < size; ++k) {
                if (i == k) continue;
                SpatialComparable other = getter.get(options, k);
                overlap_wout += SpatialUtil.relativeOverlap(entry, other);
                overlap_with += SpatialUtil.relativeOverlap(mbr, other);
            }
            double inc_overlap = overlap_with - overlap_wout;
            if (inc_overlap < least_overlap) {
                area = SpatialUtil.volume(entry);
                inc_area = SpatialUtil.volume(mbr) - area;
                least_overlap = inc_overlap;
                least_areainc = inc_area;
                least_area = area;
                best = i;
                continue;
            }
            if (inc_overlap != least_overlap) continue;
            area = SpatialUtil.volume(entry);
            inc_area = SpatialUtil.volume(mbr) - area;
            if (!(inc_area < least_areainc) && (inc_area != least_areainc || !(area < least_area))) continue;
            least_overlap = inc_overlap;
            least_areainc = inc_area;
            least_area = area;
            best = i;
        }
        assert (best > -1) : "No split found? Volume outside of double precision?";
        return best;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected LeastOverlapInsertionStrategy makeInstance() {
            return STATIC;
        }
    }
}

