/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.strategies.overflow;

import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.SquaredEuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.index.tree.IndexTreePath;
import de.lmu.ifi.dbs.elki.index.tree.LeafEntry;
import de.lmu.ifi.dbs.elki.index.tree.spatial.SpatialEntry;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.AbstractRStarTree;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.AbstractRStarTreeNode;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.strategies.overflow.OverflowTreatment;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.strategies.reinsert.CloseReinsert;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.strategies.reinsert.ReinsertStrategy;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.util.NodeArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.datastructures.BitsUtil;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;

@Reference(authors="Norbert Beckmann, Hans-Peter Kriegel, Ralf Schneider, Bernhard Seeger", title="The R*-tree: an efficient and robust access method for points and rectangles", booktitle="Proc. 1990 ACM SIGMOD Int. Conf. Management of Data", url="https://doi.org/10.1145/93597.98741", bibkey="DBLP:conf/sigmod/BeckmannKSS90")
public class LimitedReinsertOverflowTreatment
implements OverflowTreatment {
    public static final LimitedReinsertOverflowTreatment RSTAR_OVERFLOW = new LimitedReinsertOverflowTreatment(new CloseReinsert(0.3, SquaredEuclideanDistanceFunction.STATIC));
    private long[] reinsertions = new long[1];
    private final ReinsertStrategy reinsertStrategy;

    public LimitedReinsertOverflowTreatment(ReinsertStrategy reinsertStrategy) {
        this.reinsertStrategy = reinsertStrategy;
    }

    @Override
    public <N extends AbstractRStarTreeNode<N, E>, E extends SpatialEntry> boolean handleOverflow(AbstractRStarTree<N, E, ?> tree, N node, IndexTreePath<E> path) {
        int depthm1 = path.getPathCount() - 1;
        if (depthm1 == 0) {
            return false;
        }
        if (BitsUtil.capacity(this.reinsertions) < depthm1) {
            this.reinsertions = BitsUtil.copy(this.reinsertions, depthm1);
        }
        if (BitsUtil.get(this.reinsertions, depthm1)) {
            return false;
        }
        BitsUtil.setI(this.reinsertions, depthm1);
        SpatialEntry entry = (SpatialEntry)path.getEntry();
        assert (!(entry instanceof LeafEntry)) : "Unexpected leaf entry";
        int[] cands = this.reinsertStrategy.computeReinserts(node, NodeArrayAdapter.STATIC, entry);
        if (cands == null || cands.length == 0) {
            return false;
        }
        tree.reInsert(node, path, cands);
        return true;
    }

    @Override
    public void reinitialize() {
        BitsUtil.zeroI(this.reinsertions);
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static OptionID REINSERT_STRATEGY_ID = new OptionID("rtree.reinsertion-strategy", "The strategy to select candidates for reinsertion.");
        ReinsertStrategy reinsertStrategy = null;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            ObjectParameter strategyP = new ObjectParameter(REINSERT_STRATEGY_ID, (Class<?>)ReinsertStrategy.class, CloseReinsert.class);
            if (config.grab(strategyP)) {
                this.reinsertStrategy = (ReinsertStrategy)strategyP.instantiateClass(config);
            }
        }

        @Override
        protected LimitedReinsertOverflowTreatment makeInstance() {
            return new LimitedReinsertOverflowTreatment(this.reinsertStrategy);
        }
    }
}

