/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.strategies.reinsert;

import de.lmu.ifi.dbs.elki.data.DoubleVector;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialUtil;
import de.lmu.ifi.dbs.elki.distance.distancefunction.SpatialPrimitiveDistanceFunction;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.strategies.reinsert.AbstractPartialReinsert;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.ArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arrays.DoubleIntegerArrayQuickSort;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import java.util.Arrays;

@Reference(authors="Norbert Beckmann, Hans-Peter Kriegel, Ralf Schneider, Bernhard Seeger", title="The R*-tree: an efficient and robust access method for points and rectangles", booktitle="Proc. 1990 ACM SIGMOD Int. Conf. Management of Data", url="https://doi.org/10.1145/93597.98741", bibkey="DBLP:conf/sigmod/BeckmannKSS90")
public class CloseReinsert
extends AbstractPartialReinsert {
    public CloseReinsert(double reinsertAmount, SpatialPrimitiveDistanceFunction<?> distanceFunction) {
        super(reinsertAmount, distanceFunction);
    }

    @Override
    public <A> int[] computeReinserts(A entries, ArrayAdapter<? extends SpatialComparable, ? super A> getter, SpatialComparable page) {
        DoubleVector centroid = DoubleVector.wrap(SpatialUtil.centroid(page));
        int size = getter.size(entries);
        double[] dist = new double[size];
        int[] idx = MathUtil.sequence(0, size);
        for (int i = 0; i < size; ++i) {
            dist[i] = this.distanceFunction.minDist(DoubleVector.wrap(SpatialUtil.centroid(getter.get(entries, i))), centroid);
        }
        DoubleIntegerArrayQuickSort.sort(dist, idx, size);
        return Arrays.copyOf(idx, (int)(this.reinsertAmount * (double)size));
    }

    public static class Parameterizer
    extends AbstractPartialReinsert.Parameterizer {
        @Override
        protected CloseReinsert makeInstance() {
            return new CloseReinsert(this.reinsertAmount, this.distanceFunction);
        }
    }
}

