/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.strategies.split;

import de.lmu.ifi.dbs.elki.data.ModifiableHyperBoundingBox;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialUtil;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.strategies.split.SplitStrategy;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.datastructures.BitsUtil;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.ArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import java.util.Random;

@Reference(authors="C. H. Ang, T. C. Tan", title="New linear node splitting algorithm for R-trees", booktitle="Proc. 5th Int. Sym. on Advances in Spatial Databases", url="https://doi.org/10.1007/3-540-63238-7_38", bibkey="DBLP:conf/ssd/AngT97")
public class AngTanLinearSplit
implements SplitStrategy {
    private static final Logging LOG = Logging.getLogger(AngTanLinearSplit.class);
    public static final AngTanLinearSplit STATIC = new AngTanLinearSplit();

    @Override
    public <E extends SpatialComparable, A> long[] split(A entries, ArrayAdapter<E, A> getter, int minEntries) {
        int num = getter.size(entries);
        ModifiableHyperBoundingBox total = new ModifiableHyperBoundingBox((SpatialComparable)getter.get(entries, 0));
        for (int i = 1; i < num; ++i) {
            total.extend((SpatialComparable)getter.get(entries, i));
        }
        int dim = total.getDimensionality();
        long[][] closer = new long[dim][num];
        for (int i = 0; i < num; ++i) {
            SpatialComparable e = (SpatialComparable)getter.get(entries, i);
            for (int d = 0; d < dim; ++d) {
                double hig;
                double low = e.getMin(d) - total.getMin(d);
                if (!(low >= (hig = total.getMax(d) - e.getMax(d)))) continue;
                BitsUtil.setI(closer[d], i);
            }
        }
        int axis = -1;
        int bestcard = Integer.MAX_VALUE;
        long[] bestset = null;
        double bestover = Double.NaN;
        for (int d = 0; d < dim; ++d) {
            double overlap;
            long[] cand = closer[d];
            int card = BitsUtil.cardinality(cand);
            if ((card = Math.max(card, num - card)) == num) continue;
            if (card < bestcard) {
                axis = d;
                bestcard = card;
                bestset = cand;
                bestover = Double.NaN;
                continue;
            }
            if (card != bestcard) continue;
            if (Double.isNaN(bestover)) {
                bestover = this.computeOverlap(entries, getter, bestset);
            }
            if ((overlap = this.computeOverlap(entries, getter, cand)) < bestover) {
                axis = d;
                bestcard = card;
                bestset = cand;
                bestover = overlap;
                continue;
            }
            if (overlap != bestover) continue;
            double bestlen = total.getMax(axis) - total.getMin(axis);
            double candlen = total.getMax(d) - total.getMin(d);
            if (!(candlen < bestlen)) continue;
            axis = d;
            bestcard = card;
            bestset = cand;
            bestover = overlap;
        }
        if (bestset == null) {
            LOG.warning("No Ang-Tan-Split found. Probably all points are the same? Returning random split.");
            return BitsUtil.random(num >> 1, num, new Random());
        }
        return bestset;
    }

    protected <E extends SpatialComparable, A> double computeOverlap(A entries, ArrayAdapter<E, A> getter, long[] assign) {
        ModifiableHyperBoundingBox mbr1 = null;
        ModifiableHyperBoundingBox mbr2 = null;
        for (int i = 0; i < getter.size(entries); ++i) {
            SpatialComparable e = (SpatialComparable)getter.get(entries, i);
            if (BitsUtil.get(assign, i)) {
                if (mbr1 == null) {
                    mbr1 = new ModifiableHyperBoundingBox(e);
                    continue;
                }
                mbr1.extend(e);
                continue;
            }
            if (mbr2 == null) {
                mbr2 = new ModifiableHyperBoundingBox(e);
                continue;
            }
            mbr2.extend(e);
        }
        if (mbr1 == null || mbr2 == null) {
            throw new AbortException("Invalid state in split: one of the sets is empty.");
        }
        return SpatialUtil.overlap(mbr1, mbr2);
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected AngTanLinearSplit makeInstance() {
            return STATIC;
        }
    }
}

