/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.strategies.split;

import de.lmu.ifi.dbs.elki.data.ModifiableHyperBoundingBox;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialUtil;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.strategies.split.SplitStrategy;
import de.lmu.ifi.dbs.elki.utilities.datastructures.BitsUtil;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.ArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.pairs.DoubleIntPair;
import java.util.Arrays;

@Reference(authors="D, Greene", title="An implementation and performance analysis of spatial data access methods", booktitle="Proceedings of the Fifth International Conference on Data Engineering", url="https://doi.org/10.1109/ICDE.1989.47268", bibkey="DBLP:conf/icde/Greene89")
public class GreeneSplit
implements SplitStrategy {
    public static final GreeneSplit STATIC = new GreeneSplit();

    @Override
    public <E extends SpatialComparable, A> long[] split(A entries, ArrayAdapter<E, A> getter, int minEntries) {
        SpatialComparable e1i;
        int e1;
        int num = getter.size(entries);
        int axis = -1;
        double worst = Double.NEGATIVE_INFINITY;
        int w1 = 0;
        int w2 = 0;
        double[] areas = new double[num];
        for (e1 = 0; e1 < num - 1; ++e1) {
            e1i = (SpatialComparable)getter.get(entries, e1);
            areas[e1] = SpatialUtil.volume(e1i);
        }
        for (e1 = 0; e1 < num - 1; ++e1) {
            e1i = (SpatialComparable)getter.get(entries, e1);
            for (int e2 = e1 + 1; e2 < num; ++e2) {
                SpatialComparable e2i = (SpatialComparable)getter.get(entries, e2);
                double areaJ = SpatialUtil.volumeUnion(e1i, e2i);
                double d = areaJ - areas[e1] - areas[e2];
                if (!(d > worst)) continue;
                worst = d;
                w1 = e1;
                w2 = e2;
            }
        }
        if (worst > 0.0) {
            SpatialComparable m1 = (SpatialComparable)getter.get(entries, w1);
            SpatialComparable m2 = (SpatialComparable)getter.get(entries, w2);
            double bestsep = Double.NEGATIVE_INFINITY;
            double bestsep2 = Double.NEGATIVE_INFINITY;
            for (int d = 0; d < m1.getDimensionality(); ++d) {
                double no;
                double s2;
                double s1 = m1.getMin(d) - m2.getMax(d);
                double sm = Math.max(s1, s2 = m2.getMin(d) - m1.getMax(d));
                double sep = sm / (no = Math.max(m1.getMax(d), m2.getMax(d)) - Math.min(m1.getMin(d), m2.getMin(d)));
                if (!(sep > bestsep) && (sep != bestsep || !(sm > bestsep2))) continue;
                bestsep = sep;
                bestsep2 = sm;
                axis = d;
            }
        } else {
            int half = num + 1 >> 1;
            return BitsUtil.ones(half);
        }
        Object[] data = new DoubleIntPair[num];
        for (int i = 0; i < num; ++i) {
            data[i] = new DoubleIntPair(((SpatialComparable)getter.get(entries, i)).getMin(axis), i);
        }
        Arrays.sort(data);
        long[] assignment = BitsUtil.zero(num);
        int half = num + 1 >> 1;
        for (int i = 0; i < half; ++i) {
            BitsUtil.setI(assignment, ((DoubleIntPair)data[i]).second);
        }
        if (num % 2 == 0) {
            double inc2;
            ModifiableHyperBoundingBox mbr1 = new ModifiableHyperBoundingBox((SpatialComparable)getter.get(entries, ((DoubleIntPair)data[0]).second));
            for (int i = 1; i < half; ++i) {
                mbr1.extend((SpatialComparable)getter.get(entries, ((DoubleIntPair)data[i]).second));
            }
            ModifiableHyperBoundingBox mbr2 = new ModifiableHyperBoundingBox((SpatialComparable)getter.get(entries, ((DoubleIntPair)data[num - 1]).second));
            for (int i = half + 1; i < num - 1; ++i) {
                mbr2.extend((SpatialComparable)getter.get(entries, ((DoubleIntPair)data[i]).second));
            }
            SpatialComparable e = (SpatialComparable)getter.get(entries, ((DoubleIntPair)data[half]).second);
            double inc1 = SpatialUtil.volumeUnion(mbr1, e) - SpatialUtil.volume(mbr1);
            if (inc1 < (inc2 = SpatialUtil.volumeUnion(mbr2, e) - SpatialUtil.volume(mbr2))) {
                BitsUtil.setI(assignment, ((DoubleIntPair)data[half]).second);
            }
        }
        return assignment;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected GreeneSplit makeInstance() {
            return STATIC;
        }
    }
}

