/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.strategies.split;

import de.lmu.ifi.dbs.elki.data.ModifiableHyperBoundingBox;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialUtil;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.strategies.split.SplitStrategy;
import de.lmu.ifi.dbs.elki.utilities.datastructures.BitsUtil;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.ArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Reference(authors="A. Guttman", title="R-Trees: A Dynamic Index Structure For Spatial Searching", booktitle="Proc. 1984 ACM SIGMOD Int. Conf. on Management of Data", url="https://doi.org/10.1145/971697.602266", bibkey="doi:10.1145/971697.602266")
public class RTreeLinearSplit
implements SplitStrategy {
    public static final RTreeLinearSplit STATIC = new RTreeLinearSplit();

    @Override
    public <E extends SpatialComparable, A> long[] split(A entries, ArrayAdapter<E, A> getter, int minEntries) {
        int num = getter.size(entries);
        long[] assignment = BitsUtil.zero(num);
        long[] assigned = BitsUtil.zero(num);
        double area1 = 0.0;
        double area2 = 0.0;
        int dim = ((SpatialComparable)getter.get(entries, 0)).getDimensionality();
        double bestsep = Double.NEGATIVE_INFINITY;
        int w1 = -1;
        int w2 = -1;
        for (int d = 0; d < dim; ++d) {
            double normsep;
            double minlow = Double.POSITIVE_INFINITY;
            double maxlow = Double.NEGATIVE_INFINITY;
            double maxlow2 = Double.NEGATIVE_INFINITY;
            double minhig = Double.POSITIVE_INFINITY;
            double minhig2 = Double.POSITIVE_INFINITY;
            double maxhig = Double.NEGATIVE_INFINITY;
            int el = -1;
            int el2 = -1;
            int eh = -1;
            int eh2 = -1;
            for (int i = 0; i < num; ++i) {
                SpatialComparable ei = (SpatialComparable)getter.get(entries, i);
                double low = ei.getMin(d);
                double hig = ei.getMax(d);
                minlow = Math.min(minlow, low);
                maxhig = Math.max(maxhig, hig);
                if (low >= maxlow) {
                    maxlow2 = maxlow;
                    maxlow = low;
                    el2 = el;
                    el = i;
                } else if (low > maxlow2) {
                    maxlow2 = low;
                    el2 = i;
                }
                if (hig <= minhig) {
                    minhig2 = minhig;
                    minhig = hig;
                    eh2 = eh;
                    eh = i;
                    continue;
                }
                if (!(hig < minhig2)) continue;
                minhig2 = hig;
                eh2 = i;
            }
            if (el != eh) {
                normsep = minhig - maxlow / (maxhig - minlow);
            } else {
                double normsep1 = minhig - maxlow2 / (maxhig - minlow);
                double normsep2 = minhig2 - maxlow / (maxhig - minlow);
                if (normsep1 > normsep2) {
                    el = el2;
                    normsep = normsep1;
                } else {
                    eh = eh2;
                    normsep = normsep2;
                }
            }
            assert (eh != -1 && el != -1 && eh != el);
            if (!(normsep > bestsep)) continue;
            bestsep = normsep;
            w1 = el;
            w2 = eh;
        }
        BitsUtil.setI(assigned, w1);
        BitsUtil.setI(assigned, w2);
        BitsUtil.setI(assignment, w2);
        SpatialComparable w1i = (SpatialComparable)getter.get(entries, w1);
        SpatialComparable w2i = (SpatialComparable)getter.get(entries, w2);
        area1 = SpatialUtil.volume(w1i);
        area2 = SpatialUtil.volume(w2i);
        ModifiableHyperBoundingBox mbr1 = new ModifiableHyperBoundingBox(w1i);
        ModifiableHyperBoundingBox mbr2 = new ModifiableHyperBoundingBox(w2i);
        int in1 = 1;
        int in2 = 1;
        int remaining = num - 2;
        int next = BitsUtil.nextClearBit(assigned, 0);
        while (remaining > 0 && next < num && in1 + remaining > minEntries) {
            if (in2 + remaining <= minEntries) {
                while (next < num) {
                    BitsUtil.setI(assignment, next);
                    next = BitsUtil.nextClearBit(assigned, next + 1);
                }
                break;
            }
            boolean preferSecond = false;
            SpatialComparable next_i = (SpatialComparable)getter.get(entries, next);
            double d1 = SpatialUtil.volumeUnion(mbr1, next_i) - area1;
            double d2 = SpatialUtil.volumeUnion(mbr2, next_i) - area2;
            boolean bl = preferSecond = d2 < d1;
            if (d1 == d2) {
                preferSecond = area1 != area2 ? area2 < area1 : in2 < in1;
            }
            BitsUtil.setI(assigned, next);
            --remaining;
            if (!preferSecond) {
                ++in1;
                mbr1.extend(next_i);
                area1 = SpatialUtil.volume(mbr1);
            } else {
                ++in2;
                BitsUtil.setI(assignment, next);
                mbr2.extend(next_i);
                area2 = SpatialUtil.volume(mbr2);
            }
            next = BitsUtil.nextClearBit(assigned, next + 1);
        }
        return assignment;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected RTreeLinearSplit makeInstance() {
            return STATIC;
        }
    }
}

