/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.strategies.split;

import de.lmu.ifi.dbs.elki.data.ModifiableHyperBoundingBox;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialUtil;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.strategies.split.SplitStrategy;
import de.lmu.ifi.dbs.elki.utilities.datastructures.BitsUtil;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.ArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Reference(authors="A. Guttman", title="R-Trees: A Dynamic Index Structure For Spatial Searching", booktitle="Proc. 1984 ACM SIGMOD Int. Conf. on Management of Data", url="https://doi.org/10.1145/971697.602266", bibkey="doi:10.1145/971697.602266")
public class RTreeQuadraticSplit
implements SplitStrategy {
    public static final RTreeQuadraticSplit STATIC = new RTreeQuadraticSplit();

    @Override
    public <E extends SpatialComparable, A> long[] split(A entries, ArrayAdapter<E, A> getter, int minEntries) {
        SpatialComparable e1i;
        int e1;
        int num = getter.size(entries);
        long[] assignment = BitsUtil.zero(num);
        long[] assigned = BitsUtil.zero(num);
        double area1 = 0.0;
        double area2 = 0.0;
        double worst = Double.NEGATIVE_INFINITY;
        int w1 = 0;
        int w2 = 0;
        double[] areas = new double[num];
        for (e1 = 0; e1 < num - 1; ++e1) {
            e1i = (SpatialComparable)getter.get(entries, e1);
            areas[e1] = SpatialUtil.volume(e1i);
        }
        for (e1 = 0; e1 < num - 1; ++e1) {
            e1i = (SpatialComparable)getter.get(entries, e1);
            for (int e2 = e1 + 1; e2 < num; ++e2) {
                SpatialComparable e2i = (SpatialComparable)getter.get(entries, e2);
                double areaJ = SpatialUtil.volumeUnion(e1i, e2i);
                double d = areaJ - areas[e1] - areas[e2];
                if (!(d > worst)) continue;
                worst = d;
                w1 = e1;
                w2 = e2;
            }
        }
        BitsUtil.setI(assigned, w1);
        BitsUtil.setI(assigned, w2);
        BitsUtil.setI(assignment, w2);
        area1 = areas[w1];
        area2 = areas[w2];
        ModifiableHyperBoundingBox mbr1 = new ModifiableHyperBoundingBox((SpatialComparable)getter.get(entries, w1));
        ModifiableHyperBoundingBox mbr2 = new ModifiableHyperBoundingBox((SpatialComparable)getter.get(entries, w2));
        int in1 = 1;
        int in2 = 1;
        int remaining = num - 2;
        while (remaining > 0 && in1 + remaining > minEntries) {
            if (in2 + remaining <= minEntries) {
                int pos = BitsUtil.nextClearBit(assigned, 0);
                while (pos < num) {
                    BitsUtil.setI(assignment, pos);
                    pos = BitsUtil.nextClearBit(assigned, pos + 1);
                }
                break;
            }
            double greatestPreference = Double.NEGATIVE_INFINITY;
            int best = -1;
            SpatialComparable best_i = null;
            boolean preferSecond = false;
            int pos = BitsUtil.nextClearBit(assigned, 0);
            while (pos < num) {
                double d2;
                SpatialComparable pos_i = (SpatialComparable)getter.get(entries, pos);
                double d1 = SpatialUtil.volumeUnion(mbr1, pos_i) - area1;
                double preference = Math.abs(d1 - (d2 = SpatialUtil.volumeUnion(mbr2, pos_i) - area2));
                if (preference > greatestPreference) {
                    greatestPreference = preference;
                    best = pos;
                    best_i = pos_i;
                    preferSecond = d2 < d1;
                }
                pos = BitsUtil.nextClearBit(assigned, pos + 1);
            }
            if (greatestPreference == 0.0) {
                preferSecond = area1 != area2 ? area2 < area1 : in2 < in1;
            }
            BitsUtil.setI(assigned, best);
            --remaining;
            if (!preferSecond) {
                ++in1;
                mbr1.extend(best_i);
                area1 = SpatialUtil.volume(mbr1);
                continue;
            }
            ++in2;
            BitsUtil.setI(assignment, best);
            mbr2.extend(best_i);
            area2 = SpatialUtil.volume(mbr2);
        }
        return assignment;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected RTreeQuadraticSplit makeInstance() {
            return STATIC;
        }
    }
}

