/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.vafile;

import de.lmu.ifi.dbs.elki.data.DoubleVector;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.KNNHeap;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.query.range.RangeQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.LPNormDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.subspace.SubspaceLPNormDistanceFunction;
import de.lmu.ifi.dbs.elki.index.AbstractRefiningIndex;
import de.lmu.ifi.dbs.elki.index.IndexFactory;
import de.lmu.ifi.dbs.elki.index.KNNIndex;
import de.lmu.ifi.dbs.elki.index.RangeIndex;
import de.lmu.ifi.dbs.elki.index.vafile.DAFile;
import de.lmu.ifi.dbs.elki.index.vafile.VALPNormDistance;
import de.lmu.ifi.dbs.elki.index.vafile.VectorApproximation;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.statistics.Counter;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.persistent.AbstractPageFileFactory;
import de.lmu.ifi.dbs.elki.utilities.datastructures.BitsUtil;
import de.lmu.ifi.dbs.elki.utilities.datastructures.heap.DoubleMaxHeap;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.pairs.DoubleObjPair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.jafama.FastMath;

@Reference(authors="Hans-Peter Kriegel, Peer Kr\u00f6ger, Matthias Schubert, Ziyue Zhu", title="Efficient Query Processing in Arbitrary Subspaces Using Vector Approximations", booktitle="Proc. 18th Int. Conf. on Scientific and Statistical Database Management (SSDBM 06)", url="https://doi.org/10.1109/SSDBM.2006.23", bibkey="DBLP:conf/ssdbm/KriegelKSZ06")
public class PartialVAFile<V extends NumberVector>
extends AbstractRefiningIndex<V>
implements KNNIndex<V>,
RangeIndex<V> {
    private static final Logging LOG = Logging.getLogger(PartialVAFile.class);
    List<DAFile> daFiles;
    private final int partitions;
    private final int pageSize;
    private double[][] splitPartitions;
    protected Statistics stats;
    private ArrayList<VectorApproximation> vectorApprox;

    public PartialVAFile(int pageSize, Relation<V> relation, int partitions) {
        super(relation);
        this.pageSize = pageSize;
        this.partitions = partitions;
        this.stats = new Statistics(this.getClass().getName());
    }

    @Override
    public void initialize() throws IllegalStateException {
        if (this.splitPartitions != null) {
            throw new IllegalStateException("Data already inserted.");
        }
        if (MathUtil.log2(this.partitions) != (double)((int)MathUtil.log2(this.partitions))) {
            throw new IllegalArgumentException("Number of partitions must be a power of 2!");
        }
        int dimensions = RelationUtil.dimensionality(this.relation);
        this.splitPartitions = new double[dimensions][];
        this.daFiles = new ArrayList<DAFile>(dimensions);
        for (int d = 0; d < dimensions; ++d) {
            DAFile f = new DAFile(this.relation, d, this.partitions);
            this.splitPartitions[d] = f.getSplitPositions();
            this.daFiles.add(f);
        }
        this.vectorApprox = new ArrayList();
        DBIDIter iter = this.relation.iterDBIDs();
        while (iter.valid()) {
            DBID id = DBIDUtil.deref(iter);
            NumberVector dv = (NumberVector)this.relation.get(id);
            VectorApproximation va = this.calculateFullApproximation(id, dv);
            this.vectorApprox.add(va);
            iter.advance();
        }
    }

    @Override
    public String getShortName() {
        return "pva-file";
    }

    @Override
    public String getLongName() {
        return "partial va-file";
    }

    @Override
    public Logging getLogger() {
        return LOG;
    }

    @Override
    public void logStatistics() {
        this.stats.logStatistics();
    }

    protected VectorApproximation calculateFullApproximation(DBID id, V dv) {
        int[] approximation = new int[dv.getDimensionality()];
        for (int d = 0; d < this.splitPartitions.length; ++d) {
            double[] split = this.daFiles.get(d).getSplitPositions();
            double val = dv.doubleValue(d);
            int lastBorderIndex = split.length - 1;
            if (val < split[0]) {
                approximation[d] = 0;
                if (id == null) continue;
                LOG.warning("Vector outside of VAFile grid!");
                continue;
            }
            if (val > split[lastBorderIndex]) {
                approximation[d] = lastBorderIndex - 1;
                if (id == null) continue;
                LOG.warning("Vector outside of VAFile grid!");
                continue;
            }
            int pos = Arrays.binarySearch(split, val);
            approximation[d] = pos = pos >= 0 ? pos : -pos - 2;
        }
        return new VectorApproximation(id, approximation);
    }

    @Override
    public KNNQuery<V> getKNNQuery(DistanceQuery<V> distanceQuery, Object ... hints) {
        DistanceFunction<V> df = distanceQuery.getDistanceFunction();
        if (df instanceof SubspaceLPNormDistanceFunction) {
            double p = ((SubspaceLPNormDistanceFunction)df).getP();
            long[] bits = ((SubspaceLPNormDistanceFunction)df).getSelectedDimensions();
            return new PartialVAFileKNNQuery(distanceQuery, p, bits);
        }
        if (df instanceof LPNormDistanceFunction) {
            double p = ((LPNormDistanceFunction)df).getP();
            long[] bits = BitsUtil.ones(RelationUtil.dimensionality(distanceQuery.getRelation()));
            return new PartialVAFileKNNQuery(distanceQuery, p, bits);
        }
        return null;
    }

    @Override
    public RangeQuery<V> getRangeQuery(DistanceQuery<V> distanceQuery, Object ... hints) {
        DistanceFunction<V> df = distanceQuery.getDistanceFunction();
        if (df instanceof SubspaceLPNormDistanceFunction) {
            double p = ((SubspaceLPNormDistanceFunction)df).getP();
            long[] bits = ((SubspaceLPNormDistanceFunction)df).getSelectedDimensions();
            return new PartialVAFileRangeQuery(distanceQuery, p, bits);
        }
        if (df instanceof LPNormDistanceFunction) {
            double p = ((LPNormDistanceFunction)df).getP();
            long[] bits = BitsUtil.ones(RelationUtil.dimensionality(distanceQuery.getRelation()));
            return new PartialVAFileRangeQuery(distanceQuery, p, bits);
        }
        return null;
    }

    protected static void calculateSelectivityCoeffs(List<DoubleObjPair<DAFile>> daFiles, NumberVector query, double epsilon) {
        int dimensions = query.getDimensionality();
        double[] lowerVals = new double[dimensions];
        double[] upperVals = new double[dimensions];
        VectorApproximation queryApprox = PartialVAFile.calculatePartialApproximation(null, query, daFiles);
        for (int i = 0; i < dimensions; ++i) {
            double val = query.doubleValue(i);
            lowerVals[i] = val - epsilon;
            upperVals[i] = val + epsilon;
        }
        DoubleVector lowerEpsilon = DoubleVector.wrap(lowerVals);
        VectorApproximation lowerEpsilonPartitions = PartialVAFile.calculatePartialApproximation(null, lowerEpsilon, daFiles);
        DoubleVector upperEpsilon = DoubleVector.wrap(upperVals);
        VectorApproximation upperEpsilonPartitions = PartialVAFile.calculatePartialApproximation(null, upperEpsilon, daFiles);
        for (int i = 0; i < daFiles.size(); ++i) {
            int coeff = queryApprox.getApproximation(i) - lowerEpsilonPartitions.getApproximation(i) + (upperEpsilonPartitions.getApproximation(i) - queryApprox.getApproximation(i)) + 1;
            daFiles.get((int)i).first = coeff;
        }
    }

    protected static VectorApproximation calculatePartialApproximation(DBID id, NumberVector dv, List<DoubleObjPair<DAFile>> daFiles) {
        int[] approximation = new int[dv.getDimensionality()];
        for (int i = 0; i < daFiles.size(); ++i) {
            double val = dv.doubleValue(i);
            double[] borders = ((DAFile)daFiles.get((int)i).second).getSplitPositions();
            assert (borders != null) : "borders are null";
            int lastBorderIndex = borders.length - 1;
            if (val < borders[0]) {
                approximation[i] = 0;
                continue;
            }
            if (val > borders[lastBorderIndex]) {
                approximation[i] = lastBorderIndex - 1;
                continue;
            }
            for (int s = 0; s < lastBorderIndex; ++s) {
                if (!(val >= borders[s]) || !(val < borders[s + 1]) || approximation[i] == -1) continue;
                approximation[i] = s;
            }
        }
        return new VectorApproximation(id, approximation);
    }

    public static class Factory<V extends NumberVector>
    implements IndexFactory<V> {
        public static final OptionID PARTITIONS_ID = new OptionID("vafile.partitions", "Number of partitions to use in each dimension.");
        int pagesize = 1;
        int numpart = 2;

        public Factory(int pagesize, int numpart) {
            this.pagesize = pagesize;
            this.numpart = numpart;
        }

        @Override
        public PartialVAFile<V> instantiate(Relation<V> relation) {
            return new PartialVAFile<V>(this.pagesize, relation, this.numpart);
        }

        @Override
        public TypeInformation getInputTypeRestriction() {
            return TypeUtil.NUMBER_VECTOR_FIELD;
        }

        public static class Parameterizer
        extends AbstractParameterizer {
            int pagesize = 1;
            int numpart = 2;

            @Override
            protected void makeOptions(Parameterization config) {
                IntParameter partitionsP;
                super.makeOptions(config);
                IntParameter pagesizeP = (IntParameter)new IntParameter(AbstractPageFileFactory.Parameterizer.PAGE_SIZE_ID, 1024).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT);
                if (config.grab(pagesizeP)) {
                    this.pagesize = (Integer)pagesizeP.getValue();
                }
                if (config.grab(partitionsP = (IntParameter)new IntParameter(PARTITIONS_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ONE_INT))) {
                    this.numpart = (Integer)partitionsP.getValue();
                }
            }

            @Override
            protected Factory<?> makeInstance() {
                return new Factory(this.pagesize, this.numpart);
            }
        }
    }

    protected static class WorstCaseDistComparator
    implements Comparator<DAFile> {
        private VALPNormDistance dist;

        public WorstCaseDistComparator(VALPNormDistance dist) {
            this.dist = dist;
        }

        @Override
        public int compare(DAFile a, DAFile b) {
            return Double.compare(this.dist.getPartialMaxMaxDist(a.getDimension()), this.dist.getPartialMaxMaxDist(b.getDimension()));
        }
    }

    public class PartialVAFileKNNQuery
    extends AbstractRefiningIndex.AbstractKNNQuery {
        private double p;
        private long[] subspace;

        public PartialVAFileKNNQuery(DistanceQuery<V> ddq, double p, long[] subspace) {
            super(PartialVAFile.this, ddq);
            this.p = p;
            this.subspace = subspace;
        }

        @Override
        public KNNList getKNNForObject(V query, int k) {
            PartialVAFile.this.stats.incrementIssuedQueries();
            long t = System.nanoTime();
            VectorApproximation queryApprox = PartialVAFile.this.calculateFullApproximation(null, query);
            VALPNormDistance dist = new VALPNormDistance(this.p, PartialVAFile.this.splitPartitions, (NumberVector)query, queryApprox);
            List<DAFile> daFiles = this.getWorstCaseDistOrder(dist, this.subspace);
            int currentSubspaceDims = BitsUtil.cardinality(this.subspace);
            int reducedDims = 2 * currentSubspaceDims / 3;
            reducedDims = Math.max(1, reducedDims);
            if (LOG.isDebuggingFine()) {
                LOG.fine("subspaceDims=" + currentSubspaceDims + ", reducedDims=" + reducedDims);
            }
            LinkedList<PartialVACandidate> candidates1 = this.filter1(k, reducedDims, daFiles, queryApprox, currentSubspaceDims, dist);
            if (LOG.isDebuggingFine()) {
                LOG.fine("candidate set after filter 1: " + candidates1.size());
            }
            LinkedList<PartialVACandidate> candidates2 = null;
            int addition = reducedDims;
            int filterStep = 2;
            if (currentSubspaceDims <= reducedDims) {
                candidates2 = candidates1;
            } else {
                while (candidates2 == null || this.getIOCosts(candidates2.size(), currentSubspaceDims) >= this.getIOCosts(daFiles.get(0), currentSubspaceDims - addition) && addition < currentSubspaceDims) {
                    if (candidates2 != null && LOG.isDebuggingFine()) {
                        LOG.fine("filter " + filterStep + ": refining costs " + this.getIOCosts(candidates2.size(), currentSubspaceDims) + " (" + candidates2.size() + "/" + currentSubspaceDims + "), DA file costs " + this.getIOCosts(daFiles.get(0), currentSubspaceDims - addition) + " (dim " + (addition + 1) + " of " + currentSubspaceDims + ")");
                    }
                    if (candidates2 != null) {
                        candidates1 = candidates2;
                    }
                    candidates2 = new LinkedList();
                    DoubleMaxHeap kMinMaxDists = new DoubleMaxHeap(k + 1);
                    for (PartialVACandidate va : candidates1) {
                        int dimension = daFiles.get(addition).getDimension();
                        int objectCell = va.getApproximation(dimension);
                        va.minDistP += dist.getPartialMinDist(dimension, objectCell);
                        va.maxDistP += dist.getPartialMaxDist(dimension, objectCell) - dist.getPartialMaxMaxDist(dimension);
                        if (kMinMaxDists.size() >= k && !(va.minDistP <= kMinMaxDists.peek())) continue;
                        candidates2.add(va);
                        kMinMaxDists.add(va.maxDistP, k);
                    }
                    if (LOG.isDebuggingFine()) {
                        LOG.fine("candidate set after filter " + filterStep + ": " + candidates2.size());
                    }
                    ++addition;
                    ++filterStep;
                }
            }
            PartialVAFile.this.stats.incrementScannedBytes(PartialVAFile.this.relation.size() * VectorApproximation.byteOnDisk(addition, PartialVAFile.this.partitions));
            ArrayList<PartialVACandidate> sortedCandidates = new ArrayList<PartialVACandidate>(candidates2);
            Collections.sort(sortedCandidates);
            KNNList result = this.retrieveAccurateDistances(sortedCandidates, k, this.subspace, query);
            PartialVAFile.this.stats.incrementQueryTime(System.nanoTime() - t);
            return result;
        }

        private LinkedList<PartialVACandidate> filter1(int k, int reducedDims, List<DAFile> daFiles, VectorApproximation queryApprox, int subspaceDims, VALPNormDistance dist) {
            LinkedList<PartialVACandidate> candidates1 = new LinkedList<PartialVACandidate>();
            DoubleMaxHeap minmaxdist = new DoubleMaxHeap(k + 1);
            for (VectorApproximation va : PartialVAFile.this.vectorApprox) {
                int d;
                PartialVACandidate pva = new PartialVACandidate(va);
                for (d = 0; d < reducedDims; ++d) {
                    int dimension = daFiles.get(d).getDimension();
                    int objectCell = pva.getApproximation(dimension);
                    pva.minDistP += dist.getPartialMinDist(dimension, objectCell);
                    pva.maxDistP += dist.getPartialMaxDist(dimension, objectCell);
                }
                for (d = reducedDims; d < subspaceDims; ++d) {
                    pva.maxDistP += dist.getPartialMaxMaxDist(daFiles.get(d).getDimension());
                }
                if (minmaxdist.size() >= k && !(pva.minDistP <= minmaxdist.peek())) continue;
                candidates1.add(pva);
                minmaxdist.add(pva.maxDistP, k);
            }
            double minmax = minmaxdist.peek();
            Iterator it = candidates1.iterator();
            while (it.hasNext()) {
                PartialVACandidate pva = (PartialVACandidate)it.next();
                if (!(pva.minDistP > minmax)) continue;
                it.remove();
            }
            return candidates1;
        }

        private int getIOCosts(int size, int subspaceDims) {
            return size * (subspaceDims * 8 + 4);
        }

        private int getIOCosts(DAFile sample, int numberOfDAFiles) {
            return sample.getIOCosts() * numberOfDAFiles;
        }

        public List<DAFile> getWorstCaseDistOrder(VALPNormDistance dist, long[] subspace) {
            int subspaceLength = BitsUtil.cardinality(subspace);
            ArrayList<DAFile> result = new ArrayList<DAFile>(subspaceLength);
            int i = BitsUtil.nextSetBit(subspace, 0);
            while (i >= 0) {
                result.add(PartialVAFile.this.daFiles.get(i));
                i = BitsUtil.nextSetBit(subspace, i + 1);
            }
            Collections.sort(result, new WorstCaseDistComparator(dist));
            return result;
        }

        protected KNNList retrieveAccurateDistances(List<PartialVACandidate> sortedCandidates, int k, long[] subspace, V query) {
            KNNHeap result = DBIDUtil.newHeap(k);
            for (PartialVACandidate va : sortedCandidates) {
                double stopdist = result.getKNNDistance();
                DBID currentID = va.getId();
                if (result.size() >= k && !(va.minDistP < stopdist)) continue;
                double dist = this.refine(currentID, query);
                PartialVAFile.this.stats.incrementRefinements();
                if (!(dist < stopdist)) continue;
                result.insert(dist, currentID);
            }
            return result.toKNNList();
        }
    }

    public class PartialVAFileRangeQuery
    extends AbstractRefiningIndex.AbstractRangeQuery {
        private double p;
        private long[] subspace;

        public PartialVAFileRangeQuery(DistanceQuery<V> ddq, double p, long[] subspace) {
            super(PartialVAFile.this, ddq);
            this.p = p;
            this.subspace = subspace;
        }

        @Override
        public void getRangeForObject(V query, double range, ModifiableDoubleDBIDList result) {
            PartialVAFile.this.stats.incrementIssuedQueries();
            long t = System.nanoTime();
            double epsilonP = FastMath.pow(range, this.p);
            VectorApproximation queryApprox = PartialVAFile.this.calculateFullApproximation(null, query);
            VALPNormDistance dist = new VALPNormDistance(this.p, PartialVAFile.this.splitPartitions, (NumberVector)query, queryApprox);
            ArrayList<DoubleObjPair<DAFile>> subspaceDAFiles = new ArrayList<DoubleObjPair<DAFile>>(BitsUtil.cardinality(this.subspace));
            int d = BitsUtil.nextSetBit(this.subspace, 0);
            while (d >= 0) {
                DAFile daFile = PartialVAFile.this.daFiles.get(d);
                subspaceDAFiles.add(new DoubleObjPair<DAFile>(-1.0, daFile));
                d = BitsUtil.nextSetBit(this.subspace, d + 1);
            }
            PartialVAFile.calculateSelectivityCoeffs(subspaceDAFiles, query, range);
            Collections.sort(subspaceDAFiles, Collections.reverseOrder());
            int candidates = 0;
            for (VectorApproximation va : PartialVAFile.this.vectorApprox) {
                DBID id = va.getId();
                PartialVACandidate pva = new PartialVACandidate(va);
                boolean pruned = false;
                for (DoubleObjPair doubleObjPair : subspaceDAFiles) {
                    int dimension = ((DAFile)doubleObjPair.second).getDimension();
                    int objectCell = va.getApproximation(dimension);
                    pva.minDistP += dist.getPartialMinDist(dimension, objectCell);
                    pva.maxDistP += dist.getPartialMaxDist(dimension, objectCell);
                    if (!(pva.minDistP > epsilonP)) continue;
                    pruned = true;
                    break;
                }
                if (pruned) continue;
                ++candidates;
                if (pva.maxDistP <= epsilonP) {
                    result.add(this.refine(id, query), id);
                    continue;
                }
                double dis = this.refine(id, query);
                PartialVAFile.this.stats.incrementRefinements();
                if (!(dis <= range)) continue;
                result.add(dis, id);
            }
            result.sort();
            PartialVAFile.this.stats.incrementScannedBytes(PartialVAFile.this.relation.size() * VectorApproximation.byteOnDisk(BitsUtil.cardinality(this.subspace), PartialVAFile.this.partitions));
            PartialVAFile.this.stats.incrementQueryTime(System.nanoTime() - t);
            if (LOG.isDebuggingFine()) {
                LOG.fine("query = " + query);
                LOG.fine("database: " + PartialVAFile.this.relation.size() + ", candidates: " + candidates + ", results: " + result.size());
            }
        }
    }

    protected static class PartialVACandidate
    implements Comparable<PartialVACandidate> {
        protected double maxDistP = 0.0;
        protected double minDistP = 0.0;
        private final VectorApproximation approx;

        public PartialVACandidate(VectorApproximation approx) {
            this.approx = approx;
        }

        public int getApproximation(int dimension) {
            return this.approx.getApproximation(dimension);
        }

        public DBID getId() {
            return this.approx.getId();
        }

        public String toString() {
            return this.approx.toString() + ", bounds^p: [" + this.minDistP + ", " + this.maxDistP + "]";
        }

        @Override
        public int compareTo(PartialVACandidate o) {
            return Double.compare(this.minDistP, o.minDistP);
        }
    }

    public static class Statistics {
        private Counter scannedBytes;
        private Counter queryTime;
        private Counter issuedQueries;
        private Counter refinements;

        protected Statistics(String parent) {
            this.scannedBytes = LOG.isStatistics() ? LOG.newCounter(parent + ".scannedBytes") : null;
            this.queryTime = LOG.isStatistics() ? LOG.newCounter(parent + ".queryTime") : null;
            this.issuedQueries = LOG.isStatistics() ? LOG.newCounter(parent + ".issuedQueries") : null;
            this.refinements = LOG.isStatistics() ? LOG.newCounter(parent + ".refinements") : null;
        }

        public void logStatistics() {
            if (this.scannedBytes != null) {
                LOG.statistics(this.scannedBytes);
            }
            if (this.queryTime != null) {
                LOG.statistics(this.queryTime);
            }
            if (this.issuedQueries != null) {
                LOG.statistics(this.issuedQueries);
            }
            if (this.refinements != null) {
                LOG.statistics(this.refinements);
            }
        }

        protected void incrementScannedBytes(long bytes) {
            if (this.scannedBytes != null) {
                this.scannedBytes.increment(bytes);
            }
        }

        protected void incrementQueryTime(long time) {
            if (this.queryTime != null) {
                this.queryTime.increment(time);
            }
        }

        protected void incrementIssuedQueries() {
            if (this.issuedQueries != null) {
                this.issuedQueries.increment();
            }
        }

        protected void incrementRefinements() {
            if (this.refinements != null) {
                this.refinements.increment();
            }
        }
    }
}

