/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.vafile;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.index.vafile.VectorApproximation;
import net.jafama.FastMath;

public class VALPNormDistance {
    private final double onebyp;
    private double[][] lookup;
    private VectorApproximation queryApprox;

    public VALPNormDistance(double p, double[][] splitPositions, NumberVector query, VectorApproximation queryApprox) {
        this.onebyp = 1.0 / p;
        this.queryApprox = queryApprox;
        this.initializeLookupTable(splitPositions, query, p);
    }

    public double getPartialMinDist(int dimension, int vp) {
        int qp = this.queryApprox.getApproximation(dimension);
        if (vp < qp) {
            return this.lookup[dimension][vp + 1];
        }
        if (vp > qp) {
            return this.lookup[dimension][vp];
        }
        return 0.0;
    }

    public double getMinDist(VectorApproximation vec) {
        int dim = this.lookup.length;
        double minDist = 0.0;
        for (int d = 0; d < dim; ++d) {
            int vp = vec.getApproximation(d);
            minDist += this.getPartialMinDist(d, vp);
        }
        return FastMath.pow(minDist, this.onebyp);
    }

    public double getPartialMaxDist(int dimension, int vp) {
        int qp = this.queryApprox.getApproximation(dimension);
        if (vp < qp) {
            return this.lookup[dimension][vp];
        }
        if (vp > qp) {
            return this.lookup[dimension][vp + 1];
        }
        return Math.max(this.lookup[dimension][vp], this.lookup[dimension][vp + 1]);
    }

    public double getMaxDist(VectorApproximation vec) {
        int dim = this.lookup.length;
        double maxDist = 0.0;
        for (int d = 0; d < dim; ++d) {
            int vp = vec.getApproximation(d);
            maxDist += this.getPartialMaxDist(d, vp);
        }
        return FastMath.pow(maxDist, this.onebyp);
    }

    public double getPartialMaxMaxDist(int dimension) {
        double[] data = this.lookup[dimension];
        double max = data[0];
        for (int i = 1; i < data.length; ++i) {
            max = Math.max(max, data[i]);
        }
        return max;
    }

    private void initializeLookupTable(double[][] splitPositions, NumberVector query, double p) {
        int dimensions = splitPositions.length;
        int bordercount = splitPositions[0].length;
        this.lookup = new double[dimensions][bordercount];
        for (int d = 0; d < dimensions; ++d) {
            double val = query.doubleValue(d);
            for (int i = 0; i < bordercount; ++i) {
                this.lookup[d][i] = FastMath.pow(splitPositions[d][i] - val, p);
            }
        }
    }
}

