/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.logging;

import de.lmu.ifi.dbs.elki.logging.ErrorFormatter;
import de.lmu.ifi.dbs.elki.logging.MessageFormatter;
import de.lmu.ifi.dbs.elki.logging.OutputStreamLogger;
import de.lmu.ifi.dbs.elki.logging.progress.Progress;
import de.lmu.ifi.dbs.elki.logging.progress.ProgressLogRecord;
import de.lmu.ifi.dbs.elki.logging.progress.ProgressTracker;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Collection;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class CLISmartHandler
extends Handler {
    private Writer out;
    private Writer err;
    private Formatter msgformat = new MessageFormatter();
    private Formatter debugformat = new ErrorFormatter();
    private Formatter errformat = new ErrorFormatter();
    private ProgressTracker ptrack = new ProgressTracker();

    public CLISmartHandler(OutputStream out, OutputStream err) {
        this.out = new OutputStreamLogger(out);
        this.err = new OutputStreamLogger(err);
    }

    public CLISmartHandler() {
        this(System.out, System.err);
    }

    @Override
    public void close() throws SecurityException {
    }

    @Override
    public void flush() {
        try {
            this.out.flush();
        }
        catch (Exception ex) {
            this.reportError(null, ex, 2);
        }
        try {
            this.err.flush();
        }
        catch (Exception ex) {
            this.reportError(null, ex, 2);
        }
    }

    @Override
    public void publish(LogRecord record) {
        String m;
        Writer destination = record.getLevel().intValue() >= Level.WARNING.intValue() ? this.err : this.out;
        if (record instanceof ProgressLogRecord) {
            ProgressLogRecord prec = (ProgressLogRecord)record;
            this.ptrack.addProgress(prec.getProgress());
            Collection<Progress> completed = this.ptrack.removeCompleted();
            Collection<Progress> progresses = this.ptrack.getProgresses();
            StringBuilder buf = new StringBuilder();
            if (!completed.isEmpty()) {
                buf.append('\r');
                for (Progress prog : completed) {
                    prog.appendToBuffer(buf);
                    buf.append(OutputStreamLogger.NEWLINE);
                }
            }
            if (!progresses.isEmpty()) {
                boolean first = true;
                buf.append('\r');
                for (Progress prog : progresses) {
                    if (first) {
                        first = false;
                    } else {
                        buf.append(' ');
                    }
                    prog.appendToBuffer(buf);
                }
            }
            m = buf.toString();
        } else {
            Formatter fmt = record.getLevel().intValue() >= Level.WARNING.intValue() ? this.errformat : (record.getLevel().intValue() <= Level.FINE.intValue() ? this.debugformat : this.msgformat);
            try {
                m = fmt.format(record);
            }
            catch (Exception ex) {
                this.reportError(null, ex, 5);
                return;
            }
        }
        try {
            destination.write(m);
            destination.flush();
        }
        catch (Exception ex) {
            this.reportError(null, ex, 1);
            return;
        }
    }
}

