/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.logging;

import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.LoggingUtil;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class ELKILogRecord
extends LogRecord {
    private static final long serialVersionUID = 2820476270420700176L;
    private transient boolean needToInferCaller = true;
    public static final String[] IGNORE_CLASSES = new String[]{Logger.class.getCanonicalName(), Logging.class.getCanonicalName(), LoggingUtil.class.getCanonicalName(), ELKILogRecord.class.getCanonicalName(), "de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.AbstractParameterization", "de.lmu.ifi.dbs.elki.application.AbstractApplication"};
    private static final String START_TRACE_AT = Logger.class.getCanonicalName();

    public ELKILogRecord(Level level, CharSequence msg) {
        super(level, msg != null ? msg.toString() : null);
    }

    @Override
    public String getSourceClassName() {
        if (this.needToInferCaller) {
            this.inferCallerELKI();
        }
        return super.getSourceClassName();
    }

    @Override
    public void setSourceClassName(String sourceClassName) {
        super.setSourceClassName(sourceClassName);
        this.needToInferCaller = false;
    }

    @Override
    public String getSourceMethodName() {
        if (this.needToInferCaller) {
            this.inferCallerELKI();
        }
        return super.getSourceMethodName();
    }

    @Override
    public void setSourceMethodName(String sourceMethodName) {
        super.setSourceMethodName(sourceMethodName);
        this.needToInferCaller = false;
    }

    private void inferCallerELKI() {
        StackTraceElement frame;
        String cls;
        int ix;
        this.needToInferCaller = false;
        StackTraceElement[] stack = new Throwable().getStackTrace();
        for (ix = 0; ix < stack.length && !(cls = (frame = stack[ix]).getClassName()).equals(START_TRACE_AT); ++ix) {
        }
        while (ix < stack.length) {
            frame = stack[ix];
            cls = frame.getClassName();
            boolean ignore = false;
            for (int i = 0; i < IGNORE_CLASSES.length; ++i) {
                if (!cls.equals(IGNORE_CLASSES[i])) continue;
                ignore = true;
                break;
            }
            if (!ignore) {
                super.setSourceClassName(frame.getClassName());
                super.setSourceMethodName(frame.getMethodName());
                break;
            }
            ++ix;
        }
    }
}

