/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.logging;

import de.lmu.ifi.dbs.elki.logging.OutputStreamLogger;
import de.lmu.ifi.dbs.elki.logging.progress.ProgressLogRecord;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class ErrorFormatter
extends Formatter {
    public static final String[] PRUNE = new String[]{"de.lmu.ifi.dbs.elki.gui.minigui.MiniGUI", "de.lmu.ifi.dbs.elki.KDDTask", "java.awt.event.", "java.awt.EventDispatchThread", "java.awt.EventQueue", "java.security.", "java.lang.Thread", "java.util.concurrent.", "javax.swing.SwingWorker", "java.util.concurrent.FutureTask", "org.apache.batik."};
    private final String NULLMSG = "null" + OutputStreamLogger.NEWLINE;

    @Override
    public String format(LogRecord record) {
        if (record instanceof ProgressLogRecord) {
            return record.getMessage();
        }
        String msg = record.getMessage();
        String string = msg = msg != null ? msg : this.NULLMSG;
        if (record.getThrown() == null) {
            return msg.endsWith(OutputStreamLogger.NEWLINE) ? msg : msg + OutputStreamLogger.NEWLINE;
        }
        StringBuilder buf = new StringBuilder(msg.length() + 500);
        buf.append(msg);
        if (!msg.endsWith(OutputStreamLogger.NEWLINE)) {
            buf.append(OutputStreamLogger.NEWLINE);
        }
        this.appendCauses(buf, record.getThrown());
        return buf.toString();
    }

    private void appendCauses(StringBuilder buf, Throwable thrown) {
        int end;
        buf.append(thrown.toString()).append(OutputStreamLogger.NEWLINE);
        StackTraceElement[] stack = thrown.getStackTrace();
        block0: for (end = stack.length - 1; end >= 0; --end) {
            String cn = stack[end].getClassName();
            for (String pat : PRUNE) {
                if (cn.startsWith(pat)) continue block0;
            }
        }
        if (end <= 0) {
            end = stack.length - 1;
        }
        for (int i = 0; i <= end; ++i) {
            buf.append("\tat ").append(stack[i]).append(OutputStreamLogger.NEWLINE);
        }
        if (end < stack.length - 1) {
            buf.append("\tat [...]").append(OutputStreamLogger.NEWLINE);
        }
        if (thrown.getCause() != null) {
            buf.append("Caused by: ");
            this.appendCauses(buf, thrown.getCause());
        }
    }
}

