/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.logging;

import de.lmu.ifi.dbs.elki.logging.ELKILogRecord;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public final class LoggingUtil {
    private LoggingUtil() {
    }

    public static void logExpensive(Level level, String message, Throwable e) {
        String[] caller = LoggingUtil.inferCaller();
        if (caller != null) {
            Logger logger = Logger.getLogger(caller[0]);
            logger.logp(level, caller[0], caller[1], message, e);
        } else {
            Logger.getAnonymousLogger().log(level, message, e);
        }
    }

    public static void logExpensive(Level level, String message) {
        ELKILogRecord rec = new ELKILogRecord(level, (CharSequence)message);
        String[] caller = LoggingUtil.inferCaller();
        if (caller != null) {
            ((LogRecord)rec).setSourceClassName(caller[0]);
            ((LogRecord)rec).setSourceMethodName(caller[1]);
            Logger logger = Logger.getLogger(caller[0]);
            logger.log(rec);
        } else {
            Logger.getAnonymousLogger().log(rec);
        }
    }

    public static void exception(Throwable e) {
        LoggingUtil.logExpensive(Level.SEVERE, e.getMessage(), e);
    }

    public static void exception(String message, Throwable e) {
        if (message == null && e != null) {
            message = e.getMessage();
        }
        LoggingUtil.logExpensive(Level.SEVERE, message, e);
    }

    public static void warning(String message) {
        LoggingUtil.logExpensive(Level.WARNING, message);
    }

    public static void warning(String message, Throwable e) {
        if (message == null && e != null) {
            message = e.getMessage();
        }
        LoggingUtil.logExpensive(Level.WARNING, message, e);
    }

    public static void message(String message) {
        LoggingUtil.logExpensive(Level.INFO, message);
    }

    public static void message(String message, Throwable e) {
        if (message == null && e != null) {
            message = e.getMessage();
        }
        LoggingUtil.logExpensive(Level.INFO, message, e);
    }

    private static final String[] inferCaller() {
        StackTraceElement[] stack = new Throwable().getStackTrace();
        for (int ix = 0; ix < stack.length; ++ix) {
            StackTraceElement frame = stack[ix];
            if (frame.getClassName().equals(LoggingUtil.class.getCanonicalName())) continue;
            return new String[]{frame.getClassName(), frame.getMethodName()};
        }
        return null;
    }
}

