/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.logging.progress;

import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.AbstractProgress;

public class FiniteProgress
extends AbstractProgress {
    private final int total;
    private final int totalLength;

    protected FiniteProgress(String task, int total) {
        super(task);
        this.total = total;
        this.totalLength = Integer.toString(total).length();
    }

    public FiniteProgress(String task, int total, Logging logger) {
        super(task);
        this.total = total;
        this.totalLength = Integer.toString(total).length();
        logger.progress(this);
    }

    @Override
    protected void setProcessed(int processed) throws IllegalArgumentException {
        if (processed > this.total) {
            throw new IllegalArgumentException(processed + " exceeds total: " + this.total);
        }
        if (processed < 0) {
            throw new IllegalArgumentException("Negative number of processed: " + processed);
        }
        super.setProcessed(processed);
    }

    @Override
    public StringBuilder appendToBuffer(StringBuilder buf) {
        String processedString = Integer.toString(this.getProcessed());
        int percentage = (int)((double)this.getProcessed() * 100.0 / (double)this.total);
        buf.append(this.getTask());
        buf.append(": ");
        for (int i = 0; i < this.totalLength - processedString.length(); ++i) {
            buf.append(' ');
        }
        buf.append(this.getProcessed());
        buf.append(" [");
        if (percentage < 100) {
            buf.append(' ');
        }
        if (percentage < 10) {
            buf.append(' ');
        }
        buf.append(percentage);
        buf.append("%]");
        if (this.ratems > 0.0 && this.getProcessed() < this.total) {
            buf.append(' ');
            int secs = (int)Math.round((double)(this.total - this.getProcessed()) / this.ratems / 1000.0 + 0.2);
            if (secs > 300) {
                buf.append(secs / 60);
                buf.append(" min remaining");
            } else {
                buf.append(secs);
                buf.append(" sec remaining");
            }
        }
        return buf;
    }

    @Override
    public boolean isComplete() {
        return this.getProcessed() == this.total;
    }

    public int getTotal() {
        return this.total;
    }

    public void ensureCompleted(Logging logger) {
        if (!this.isComplete()) {
            logger.warning("Progress had not completed automatically as expected: " + this.getProcessed() + "/" + this.total, new Throwable());
            this.setProcessed(this.getTotal());
            logger.progress(this);
        }
    }
}

