/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.logging.progress;

import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.AbstractProgress;

public class MutableProgress
extends AbstractProgress {
    private int total;

    public MutableProgress(String task, int total, Logging logger) {
        super(task);
        this.total = total;
        logger.progress(this);
    }

    @Override
    public StringBuilder appendToBuffer(StringBuilder buf) {
        int percentage = (int)((double)this.getProcessed() * 100.0 / (double)this.total);
        return buf.append(this.getTask()).append(": ").append(this.getProcessed()).append('/').append(this.total).append(" [").append(percentage < 10 ? "  " : (percentage < 100 ? " " : "")).append(percentage).append("%]");
    }

    @Override
    public boolean isComplete() {
        return this.getProcessed() == this.total;
    }

    public void setTotal(int total) throws IllegalArgumentException {
        if (this.getProcessed() > total) {
            throw new IllegalArgumentException(this.getProcessed() + " exceeds total: " + total);
        }
        this.total = total;
    }

    public int getTotal() {
        return this.total;
    }
}

