/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math;

public class DoubleMinMax {
    private double min;
    private double max;

    public DoubleMinMax() {
        this.min = Double.POSITIVE_INFINITY;
        this.max = Double.NEGATIVE_INFINITY;
    }

    public DoubleMinMax(double min, double max) {
        this.min = min;
        this.max = max;
    }

    public void put(double val) {
        this.min = val < this.min ? val : this.min;
        this.max = val > this.max ? val : this.max;
    }

    public void put(double[] data) {
        int l = data.length;
        for (int i = 0; i < l; ++i) {
            this.put(data[i]);
        }
    }

    public void put(DoubleMinMax val) {
        this.min = val.min < this.min ? val.min : this.min;
        this.max = val.max > this.max ? val.max : this.max;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public double getDiff() {
        return this.max - this.min;
    }

    public boolean isValid() {
        return this.min <= this.max;
    }

    public double[] asDoubleArray() {
        return new double[]{this.min, this.max};
    }

    public static DoubleMinMax[] newArray(int size) {
        DoubleMinMax[] ret = new DoubleMinMax[size];
        for (int i = 0; i < size; ++i) {
            ret[i] = new DoubleMinMax();
        }
        return ret;
    }

    public void reset() {
        this.min = Double.POSITIVE_INFINITY;
        this.max = Double.NEGATIVE_INFINITY;
    }

    public String toString() {
        return "DoubleMinMax[min=" + this.min + ", max=" + this.max + "]";
    }
}

