/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math;

public class IntegerMinMax {
    private int min;
    private int max;

    public IntegerMinMax() {
        this.min = Integer.MAX_VALUE;
        this.max = Integer.MIN_VALUE;
    }

    public IntegerMinMax(int min, int max) {
        this.min = min;
        this.max = max;
    }

    public void put(int val) {
        this.min = val < this.min ? val : this.min;
        this.max = val > this.max ? val : this.max;
    }

    public void put(int[] data) {
        int l = data.length;
        for (int i = 0; i < l; ++i) {
            this.put(data[i]);
        }
    }

    public void put(IntegerMinMax val) {
        this.min = val.min < this.min ? val.min : this.min;
        this.max = val.max > this.max ? val.max : this.max;
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    public long getDiff() {
        return (long)this.max - (long)this.min;
    }

    public boolean isValid() {
        return this.min <= this.max;
    }

    public int[] asIntArray() {
        return new int[]{this.min, this.max};
    }

    public static IntegerMinMax[] newArray(int size) {
        IntegerMinMax[] ret = new IntegerMinMax[size];
        for (int i = 0; i < size; ++i) {
            ret[i] = new IntegerMinMax();
        }
        return ret;
    }

    public void reset() {
        this.min = Integer.MAX_VALUE;
        this.max = Integer.MIN_VALUE;
    }
}

