/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math;

import java.math.BigInteger;
import java.util.Random;
import net.jafama.FastMath;

public final class MathUtil {
    public static final double TWOPI = Math.PI * 2;
    public static final double HALFPI = 1.5707963267948966;
    public static final double QUARTERPI = 0.7853981633974483;
    public static final double ONEHALFPI = 4.71238898038469;
    public static final double PISQUARE = Math.PI * Math.PI;
    public static final double SQRTPI = Math.sqrt(Math.PI);
    public static final double SQRTTWOPI = Math.sqrt(Math.PI * 2);
    public static final double SQRTHALFPI = Math.sqrt(1.5707963267948966);
    public static final double SQRT2 = Math.sqrt(2.0);
    public static final double SQRT3 = Math.sqrt(3.0);
    public static final double SQRT5 = Math.sqrt(5.0);
    public static final double SQRTHALF = Math.sqrt(0.5);
    public static final double ONE_BY_SQRTPI = 1.0 / SQRTPI;
    public static final double ONE_BY_SQRTTWOPI = 1.0 / SQRTTWOPI;
    public static final double LOG_ONE_BY_SQRTTWOPI = -0.5 * Math.log(Math.PI * 2);
    public static final double ONE_BY_LOG2 = 1.0 / Math.log(2.0);
    public static final double ONE_THIRD = 0.3333333333333333;
    public static final double SQRTTHIRD = FastMath.sqrt(0.3333333333333333);
    public static final double LOG2 = Math.log(2.0);
    public static final double LOG3 = Math.log(3.0);
    public static final double LOG10 = Math.log(10.0);
    public static final double LOGPI = Math.log(Math.PI);
    public static final double LOGPIHALF = LOGPI / 2.0;
    public static final double LOGTWOPI = Math.log(Math.PI * 2);
    public static final double LOGSQRTTWOPI = Math.log(SQRTTWOPI);
    public static final double LOGLOG2 = Math.log(LOG2);
    public static final double DEG2RAD = Math.PI / 180;
    public static final double RAD2DEG = 57.29577951308232;
    public static final int[] EMPTY_INTS = new int[0];

    private MathUtil() {
    }

    public static double log2(double x) {
        return FastMath.log(x) * ONE_BY_LOG2;
    }

    public static BigInteger factorial(BigInteger n) {
        BigInteger nFac = BigInteger.ONE;
        while (n.compareTo(BigInteger.ONE) > 0) {
            nFac = nFac.multiply(n);
            n = n.subtract(BigInteger.ONE);
        }
        return nFac;
    }

    public static long factorial(int n) {
        long nFac = 1L;
        for (long i = (long)n; i > 0L; --i) {
            nFac *= i;
        }
        return nFac;
    }

    public static long binomialCoefficient(long n, long k) {
        long m = Math.max(k, n - k);
        double temp = 1.0;
        long i = n;
        long j = 1L;
        while (i > m) {
            temp = temp * (double)i / (double)j;
            --i;
            ++j;
        }
        return (long)temp;
    }

    public static double approximateFactorial(int n) {
        double nFac = 1.0;
        for (int i = n; i > 0; --i) {
            nFac *= (double)i;
        }
        return nFac;
    }

    public static double approximateBinomialCoefficient(int n, int k) {
        int m = MathUtil.max(k, n - k);
        long temp = 1L;
        int i = n;
        int j = 1;
        while (i > m) {
            temp = temp * (long)i / (long)j;
            --i;
            ++j;
        }
        return temp;
    }

    public static long sumFirstIntegers(long i) {
        return (i + 1L) * i >> 1;
    }

    public static double[] randomDoubleArray(int len, Random r) {
        double[] ret = new double[len];
        for (int i = 0; i < len; ++i) {
            ret[i] = r.nextDouble();
        }
        return ret;
    }

    public static double deg2rad(double deg) {
        return deg * (Math.PI / 180);
    }

    public static double rad2deg(double rad) {
        return rad * 57.29577951308232;
    }

    public static double normAngle(double x) {
        return (x %= Math.PI * 2) > 0.0 ? x : x + Math.PI * 2;
    }

    public static int nextPow2Int(int x) {
        --x;
        x |= x >>> 1;
        x |= x >>> 2;
        x |= x >>> 4;
        x |= x >>> 8;
        x |= x >>> 16;
        return ++x;
    }

    public static long nextPow2Long(long x) {
        --x;
        x |= x >>> 1;
        x |= x >>> 2;
        x |= x >>> 4;
        x |= x >>> 16;
        x |= x >>> 32;
        return ++x;
    }

    public static int nextAllOnesInt(int x) {
        x |= x >>> 1;
        x |= x >>> 2;
        x |= x >>> 4;
        x |= x >>> 8;
        x |= x >>> 16;
        return x;
    }

    public static long nextAllOnesLong(long x) {
        x |= x >>> 1;
        x |= x >>> 2;
        x |= x >>> 4;
        x |= x >>> 16;
        x |= x >>> 32;
        return x;
    }

    public static double floatToDoubleUpper(float f) {
        if (Float.isNaN(f)) {
            return Double.NaN;
        }
        if (Float.isInfinite(f)) {
            return f > 0.0f ? Double.POSITIVE_INFINITY : Double.longBitsToDouble(-4039728865751334913L);
        }
        long bits = Double.doubleToRawLongBits(f);
        if ((bits & Long.MIN_VALUE) == 0L) {
            if (bits == 0L) {
                return Double.longBitsToDouble(3931642474694443008L);
            }
            if (f == Float.MIN_VALUE) {
                return Double.longBitsToDouble(3938397874135498751L);
            }
            if (Float.MIN_NORMAL > f && (double)f >= Double.MIN_NORMAL) {
                long bits2 = Double.doubleToRawLongBits(Math.nextUp(f));
                bits = (bits >>> 1) + (bits2 >>> 1) - 1L;
            } else {
                bits += 0xFFFFFFFL;
            }
            return Double.longBitsToDouble(bits);
        }
        if (bits == Long.MIN_VALUE) {
            return -0.0;
        }
        if (f == -1.4E-45f) {
            return Double.longBitsToDouble(-5291729562160332799L);
        }
        if (-1.1754944E-38f < f && (double)f <= -2.2250738585072014E-308) {
            long bits2 = Double.doubleToRawLongBits(Math.nextUp(f));
            bits = (bits >>> 1) + (bits2 >>> 1) + 1L;
        } else {
            bits -= 0xFFFFFFFL;
        }
        return Double.longBitsToDouble(bits);
    }

    public static double floatToDoubleLower(float f) {
        if (Float.isNaN(f)) {
            return Double.NaN;
        }
        if (Float.isInfinite(f)) {
            return f < 0.0f ? Double.NEGATIVE_INFINITY : Double.longBitsToDouble(5183643171103440895L);
        }
        long bits = Double.doubleToRawLongBits(f);
        if ((bits & Long.MIN_VALUE) == 0L) {
            if (bits == 0L) {
                return 0.0;
            }
            if (f == Float.MIN_VALUE) {
                return Double.longBitsToDouble(3931642474694443009L);
            }
            if (Float.MIN_NORMAL > f) {
                long bits2 = Double.doubleToRawLongBits(-Math.nextUp(-f));
                bits = (bits >>> 1) + (bits2 >>> 1) + 1L;
            } else {
                bits -= 0xFFFFFFFL;
            }
            return Double.longBitsToDouble(bits);
        }
        if (bits == Long.MIN_VALUE) {
            return Double.longBitsToDouble(-5291729562160332800L);
        }
        if (f == -1.4E-45f) {
            return Double.longBitsToDouble(-5284974162719277057L);
        }
        if (-1.1754944E-38f < f) {
            long bits2 = Double.doubleToRawLongBits(-Math.nextUp(-f));
            bits = (bits >>> 1) + (bits2 >>> 1) - 1L;
        } else {
            bits += 0xFFFFFFFL;
        }
        return Double.longBitsToDouble(bits);
    }

    public static double log1mexp(double x) {
        return x > -LOG2 ? FastMath.log(-FastMath.expm1(x)) : FastMath.log1p(-MathUtil.exp(x));
    }

    public static double exp(double d) {
        return FastMath.exp(d);
    }

    public static double powi(double x, int p) {
        return FastMath.powFast(x, p);
    }

    public static int ipowi(int x, int p) {
        if (p <= 2) {
            return (int)FastMath.powFast(x, p);
        }
        int tmp = x;
        int ret = (p & 1) == 1 ? x : 1;
        while (true) {
            tmp *= tmp;
            if ((p >>= 1) == 1) {
                return ret * tmp;
            }
            if ((p & 1) == 0) continue;
            ret *= tmp;
        }
    }

    public static int[] sequence(int start, int end) {
        if (start >= end) {
            return EMPTY_INTS;
        }
        int[] ret = new int[end - start];
        int j = 0;
        while (start < end) {
            ret[j] = start++;
            ++j;
        }
        return ret;
    }

    public static double max(double a, double b) {
        return a >= b ? a : b;
    }

    public static double max(double a, double b, double c) {
        return a >= b ? (a >= c ? a : c) : (b >= c ? b : c);
    }

    public static double max(double a, double b, double c, double d) {
        return a >= b ? (a >= c ? (a >= d ? a : d) : (c >= d ? c : d)) : (b >= c ? (b >= d ? b : d) : (c >= d ? c : d));
    }

    public static int max(int a, int b) {
        return a >= b ? a : b;
    }

    public static int max(int a, int b, int c) {
        return a >= b ? (a >= c ? a : c) : (b >= c ? b : c);
    }

    public static int max(int a, int b, int c, int d) {
        return a >= b ? (a >= c ? (a >= d ? a : d) : (c >= d ? c : d)) : (b >= c ? (b >= d ? b : d) : (c >= d ? c : d));
    }

    public static double min(double a, double b) {
        return a <= b ? a : b;
    }

    public static double min(double a, double b, double c) {
        return a <= b ? (a <= c ? a : c) : (b <= c ? b : c);
    }

    public static double min(double a, double b, double c, double d) {
        return a <= b ? (a <= c ? (a <= d ? a : d) : (c <= d ? c : d)) : (b <= c ? (b <= d ? b : d) : (c <= d ? c : d));
    }

    public static int min(int a, int b) {
        return a <= b ? a : b;
    }

    public static int min(int a, int b, int c) {
        return a <= b ? (a <= c ? a : c) : (b <= c ? b : c);
    }

    public static int min(int a, int b, int c, int d) {
        return a <= b ? (a <= c ? (a <= d ? a : d) : (c <= d ? c : d)) : (b <= c ? (b <= d ? b : d) : (c <= d ? c : d));
    }
}

