/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math;

import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;

public class Mean {
    protected double sum;
    protected double n;

    public Mean() {
        this.sum = 0.0;
        this.n = 0.0;
    }

    public Mean(Mean other) {
        this.sum = other.sum;
        this.n = other.n;
    }

    public void put(double val) {
        this.n += 1.0;
        this.sum += val;
    }

    public void put(double val, double weight) {
        if (weight == 0.0) {
            return;
        }
        this.sum += val * weight;
        this.n += weight;
    }

    public void put(Mean other) {
        if (other.n == 0.0) {
            return;
        }
        this.sum += other.sum;
        this.n = other.n + this.n;
    }

    public Mean put(double[] vals) {
        for (double v : vals) {
            this.put(v);
        }
        return this;
    }

    public Mean put(double[] vals, double[] weights) {
        assert (vals.length == weights.length);
        int end = vals.length;
        for (int i = 0; i < end; ++i) {
            this.put(vals[i], weights[i]);
        }
        return this;
    }

    public double getCount() {
        return this.n;
    }

    public double getMean() {
        return this.sum / this.n;
    }

    public static Mean[] newArray(int dimensionality) {
        Mean[] arr = new Mean[dimensionality];
        for (int i = 0; i < dimensionality; ++i) {
            arr[i] = new Mean();
        }
        return arr;
    }

    public String toString() {
        return "Mean(" + this.getMean() + ",weight=" + this.getCount() + ")";
    }

    public void reset() {
        this.sum = 0.0;
        this.n = 0.0;
    }

    public static double of(double ... data) {
        double sum = 0.0;
        for (double v : data) {
            sum += v;
        }
        return sum / (double)data.length;
    }

    @Reference(authors="P. M. Neely", title="Comparison of Several Algorithms for Computation of Means, Standard Deviations and Correlation Coefficients", booktitle="Communications of the ACM 9(7), 1966", url="https://doi.org/10.1145/365719.365958", bibkey="doi:10.1145/365719.365958")
    public static double highPrecision(double ... data) {
        double sum = 0.0;
        for (double v : data) {
            sum += v;
        }
        sum /= (double)data.length;
        double err = 0.0;
        for (double v : data) {
            err += v - sum;
        }
        return sum + err / (double)data.length;
    }
}

