/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math;

import de.lmu.ifi.dbs.elki.math.Mean;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.References;
import net.jafama.FastMath;

@References(value={@Reference(authors="Erich Schubert, Michael Gertz", title="Numerically Stable Parallel Computation of (Co-)Variance", booktitle="Proc. 30th Int. Conf. Scientific and Statistical Database Management (SSDBM 2018)", url="https://doi.org/10.1145/3221269.3223036", bibkey="DBLP:conf/ssdbm/SchubertG18"), @Reference(authors="E. A. Youngs, E. M. Cramer", title="Some Results Relevant to Choice of Sum and Sum-of-Product Algorithms", booktitle="Technometrics 13(3)", url="https://doi.org/10.1080/00401706.1971.10488826", bibkey="doi:10.1080/00401706.1971.10488826"), @Reference(authors="B. P. Welford", title="Note on a method for calculating corrected sums of squares and products", booktitle="Technometrics 4(3)", url="https://doi.org/10.2307/1266577", bibkey="doi:10.2307/1266577"), @Reference(authors="D. H. D. West", title="Updating Mean and Variance Estimates: An Improved Method", booktitle="Communications of the ACM 22(9)", url="https://doi.org/10.1145/359146.359153", bibkey="DBLP:journals/cacm/West79")})
public class MeanVariance
extends Mean {
    protected double m2;

    public MeanVariance() {
        this.m2 = 0.0;
    }

    public MeanVariance(MeanVariance other) {
        this.sum = other.sum;
        this.m2 = other.m2;
        this.n = other.n;
    }

    @Override
    public void put(double val) {
        if (this.n <= 0.0) {
            this.n = 1.0;
            this.sum = val;
            this.m2 = 0.0;
            return;
        }
        double tmp = this.n * val - this.sum;
        double oldn = this.n;
        this.n += 1.0;
        this.sum += val;
        this.m2 += tmp * tmp / (this.n * oldn);
    }

    @Override
    public void put(double val, double weight) {
        if (weight == 0.0) {
            return;
        }
        if (this.n <= 0.0) {
            this.n = weight;
            this.sum = val * weight;
            return;
        }
        double tmp = this.n * (val *= weight) - this.sum * weight;
        double oldn = this.n;
        this.n += weight;
        this.sum += val;
        this.m2 += tmp * tmp / (weight * this.n * oldn);
    }

    @Override
    public void put(Mean other) {
        if (!(other instanceof MeanVariance)) {
            throw new IllegalArgumentException("I cannot combine Mean and MeanVariance to a MeanVariance.");
        }
        MeanVariance mvo = (MeanVariance)other;
        double on = mvo.n;
        double osum = mvo.sum;
        double tmp = this.n * osum - this.sum * on;
        double oldn = this.n;
        this.n += on;
        this.sum += osum;
        this.m2 += mvo.m2 + tmp * tmp / (on * this.n * oldn);
    }

    @Override
    public MeanVariance put(double[] vals) {
        int l = vals.length;
        if (l < 2) {
            if (l == 1) {
                this.put(vals[0]);
            }
            return this;
        }
        double s1 = 0.0;
        for (int i = 0; i < l; ++i) {
            s1 += vals[i];
        }
        double om1 = s1 / (double)l;
        double om2 = 0.0;
        double err = 0.0;
        for (int i = 0; i < l; ++i) {
            double v = vals[i] - om1;
            om2 += v * v;
            err += v;
        }
        s1 += err;
        om2 += err / (double)l;
        if (this.n <= 0.0) {
            this.n = l;
            this.sum = s1;
            this.m2 = om2;
            return this;
        }
        double tmp = this.n * s1 - this.sum * (double)l;
        double oldn = this.n;
        this.n += (double)l;
        this.sum += s1 + err;
        this.m2 += om2 + tmp * tmp / ((double)l * this.n * oldn);
        return this;
    }

    @Override
    public MeanVariance put(double[] vals, double[] weights) {
        assert (vals.length == weights.length);
        int end = vals.length;
        for (int i = 0; i < end; ++i) {
            this.put(vals[i], weights[i]);
        }
        return this;
    }

    public double getNaiveVariance() {
        return this.m2 / this.n;
    }

    public double getSampleVariance() {
        if (!(this.n > 1.0)) {
            throw new ArithmeticException("Cannot compute a reasonable sample variance with weight <= 1.0!");
        }
        return this.m2 / (this.n - 1.0);
    }

    public double getSumOfSquares() {
        return this.m2;
    }

    public double getNaiveStddev() {
        return FastMath.sqrt(this.getNaiveVariance());
    }

    public double getSampleStddev() {
        return FastMath.sqrt(this.getSampleVariance());
    }

    public static MeanVariance[] newArray(int dimensionality) {
        MeanVariance[] arr = new MeanVariance[dimensionality];
        for (int i = 0; i < dimensionality; ++i) {
            arr[i] = new MeanVariance();
        }
        return arr;
    }

    @Override
    public String toString() {
        return "MeanVariance(mean=" + this.getMean() + ",var=" + this.getNaiveVariance() + ",weight=" + this.n + ")";
    }

    @Override
    public void reset() {
        super.reset();
        this.m2 = 0.0;
    }
}

