/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math;

import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.math.Mean;
import de.lmu.ifi.dbs.elki.math.MeanVariance;

public class MeanVarianceMinMax
extends MeanVariance {
    double min;
    double max;

    public MeanVarianceMinMax() {
        this.min = Double.POSITIVE_INFINITY;
        this.max = Double.NEGATIVE_INFINITY;
    }

    public MeanVarianceMinMax(MeanVarianceMinMax other) {
        super(other);
        this.min = other.min;
        this.max = other.max;
    }

    @Override
    public void put(double val) {
        super.put(val);
        this.min = val < this.min ? val : this.min;
        this.max = val > this.max ? val : this.max;
    }

    @Override
    public void put(double val, double weight) {
        super.put(val, weight);
        if (weight <= 0.0) {
            return;
        }
        this.min = val < this.min ? val : this.min;
        this.max = val > this.max ? val : this.max;
    }

    @Override
    public void put(Mean other) {
        if (!(other instanceof MeanVarianceMinMax)) {
            throw new IllegalArgumentException("Cannot aggregate into a minmax statistic: " + other.getClass());
        }
        super.put(other);
        MeanVarianceMinMax om = (MeanVarianceMinMax)other;
        this.min = om.min < this.min ? om.min : this.min;
        this.max = om.max > this.max ? om.max : this.max;
    }

    @Override
    public MeanVarianceMinMax put(double[] vals) {
        int l = vals.length;
        if (l < 2) {
            if (l == 1) {
                this.put(vals[0]);
            }
            return this;
        }
        double s1 = 0.0;
        for (int i = 0; i < l; ++i) {
            double v = vals[i];
            s1 += v;
            this.min = v < this.min ? v : this.min;
            this.max = v > this.max ? v : this.max;
        }
        double om1 = s1 / (double)l;
        double om2 = 0.0;
        double err = 0.0;
        for (int i = 0; i < l; ++i) {
            double v = vals[i] - om1;
            om2 += v * v;
            err += v;
        }
        s1 += err;
        om2 += err / (double)l;
        if (this.n <= 0.0) {
            this.n = l;
            this.sum = s1;
            this.m2 = om2;
            return this;
        }
        double tmp = this.n * s1 - this.sum * (double)l;
        double oldn = this.n;
        this.n += (double)l;
        this.sum += s1 + err;
        this.m2 += om2 + tmp * tmp / ((double)l * this.n * oldn);
        return this;
    }

    @Override
    public MeanVariance put(double[] vals, double[] weights) {
        assert (vals.length == weights.length);
        int end = vals.length;
        for (int i = 0; i < end; ++i) {
            this.put(vals[i], weights[i]);
        }
        return this;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public DoubleMinMax getDoubleMinMax() {
        return new DoubleMinMax(this.min, this.max);
    }

    public double getDiff() {
        return this.getMax() - this.getMin();
    }

    public static MeanVarianceMinMax[] newArray(int dimensionality) {
        MeanVarianceMinMax[] arr = new MeanVarianceMinMax[dimensionality];
        for (int i = 0; i < dimensionality; ++i) {
            arr[i] = new MeanVarianceMinMax();
        }
        return arr;
    }

    @Override
    public String toString() {
        return "MeanVarianceMinMax(mean=" + this.getMean() + ",var=" + this.getNaiveVariance() + ",min=" + this.getMin() + ",max=" + this.getMax() + ",weight=" + this.n + ")";
    }

    @Override
    public void reset() {
        super.reset();
        this.min = Double.POSITIVE_INFINITY;
        this.max = Double.NEGATIVE_INFINITY;
    }
}

