/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import net.jafama.FastMath;

public class PearsonCorrelation {
    private double sumXX = 0.0;
    private double sumYY = 0.0;
    private double sumXY = 0.0;
    private double sumX = 0.0;
    private double sumY = 0.0;
    private double sumWe = 0.0;

    public void put(double x, double y, double w) {
        if (w == 0.0) {
            return;
        }
        if (this.sumWe <= 0.0) {
            this.sumX = x * w;
            this.sumY = y * w;
            this.sumWe = w;
            return;
        }
        double deltaX = x * this.sumWe - this.sumX;
        double deltaY = y * this.sumWe - this.sumY;
        double oldWe = this.sumWe;
        this.sumWe += w;
        double f = w / (this.sumWe * oldWe);
        this.sumXX += f * deltaX * deltaX;
        this.sumYY += f * deltaY * deltaY;
        this.sumXY += f * deltaX * deltaY;
        this.sumX += x * w;
        this.sumY += y * w;
    }

    public void put(double x, double y) {
        if (this.sumWe <= 0.0) {
            this.sumX = x;
            this.sumY = y;
            this.sumWe = 1.0;
            return;
        }
        double deltaX = x * this.sumWe - this.sumX;
        double deltaY = y * this.sumWe - this.sumY;
        double oldWe = this.sumWe;
        this.sumWe += 1.0;
        double f = 1.0 / (this.sumWe * oldWe);
        this.sumXX += f * deltaX * deltaX;
        this.sumYY += f * deltaY * deltaY;
        this.sumXY += f * deltaX * deltaY;
        this.sumX += x;
        this.sumY += y;
    }

    public double getCorrelation() {
        if (!(this.sumXX > 0.0) || !(this.sumYY > 0.0)) {
            return this.sumXX == this.sumYY ? 1.0 : 0.0;
        }
        return this.sumXY / FastMath.sqrt(this.sumXX * this.sumYY);
    }

    public double getCount() {
        return this.sumWe;
    }

    public double getMeanX() {
        return this.sumX / this.sumWe;
    }

    public double getMeanY() {
        return this.sumY / this.sumWe;
    }

    public double getNaiveCovariance() {
        return this.sumXY / this.sumWe;
    }

    public double getSampleCovariance() {
        assert (this.sumWe > 1.0);
        return this.sumXY / (this.sumWe - 1.0);
    }

    public double getNaiveVarianceX() {
        return this.sumXX / this.sumWe;
    }

    public double getSampleVarianceX() {
        assert (this.sumWe > 1.0);
        return this.sumXX / (this.sumWe - 1.0);
    }

    public double getNaiveStddevX() {
        return FastMath.sqrt(this.getNaiveVarianceX());
    }

    public double getSampleStddevX() {
        return FastMath.sqrt(this.getSampleVarianceX());
    }

    public double getNaiveVarianceY() {
        return this.sumYY / this.sumWe;
    }

    public double getSampleVarianceY() {
        assert (this.sumWe > 1.0);
        return this.sumYY / (this.sumWe - 1.0);
    }

    public double getNaiveStddevY() {
        return FastMath.sqrt(this.getNaiveVarianceY());
    }

    public double getSampleStddevY() {
        return FastMath.sqrt(this.getSampleVarianceY());
    }

    public void reset() {
        this.sumWe = 0.0;
        this.sumY = 0.0;
        this.sumX = 0.0;
        this.sumYY = 0.0;
        this.sumXY = 0.0;
        this.sumXX = 0.0;
    }

    public static double coefficient(double[] x, double[] y) {
        int xdim = x.length;
        int ydim = y.length;
        if (xdim != ydim) {
            throw new IllegalArgumentException("Invalid arguments: arrays differ in length.");
        }
        if (xdim == 0) {
            throw new IllegalArgumentException("Empty vector.");
        }
        double sumXX = 0.0;
        double sumYY = 0.0;
        double sumXY = 0.0;
        double sumX = x[0];
        double sumY = y[0];
        int i = 1;
        while (i < xdim) {
            double xv = x[i];
            double yv = y[i];
            double deltaX = xv * (double)i - sumX;
            double deltaY = yv * (double)i - sumY;
            double oldi = i;
            double f = 1.0 / ((double)(++i) * oldi);
            sumXX += f * deltaX * deltaX;
            sumYY += f * deltaY * deltaY;
            sumXY += f * deltaX * deltaY;
            sumX += xv;
            sumY += yv;
        }
        if (!(sumXX > 0.0) || !(sumYY > 0.0)) {
            return sumXX == sumYY ? 1.0 : 0.0;
        }
        return sumXY / FastMath.sqrt(sumXX * sumYY);
    }

    public static double coefficient(NumberVector x, NumberVector y) {
        int ydim;
        int xdim = x.getDimensionality();
        if (xdim != (ydim = y.getDimensionality())) {
            throw new IllegalArgumentException("Invalid arguments: number vectors differ in dimensionality.");
        }
        if (xdim == 0) {
            throw new IllegalArgumentException("Empty vector.");
        }
        double sumXX = 0.0;
        double sumYY = 0.0;
        double sumXY = 0.0;
        double sumX = x.doubleValue(0);
        double sumY = y.doubleValue(0);
        int i = 1;
        while (i < xdim) {
            double xv = x.doubleValue(i);
            double yv = y.doubleValue(i);
            double deltaX = xv * (double)i - sumX;
            double deltaY = yv * (double)i - sumY;
            double oldi = i;
            double f = 1.0 / ((double)(++i) * oldi);
            sumXX += f * deltaX * deltaX;
            sumYY += f * deltaY * deltaY;
            sumXY += f * deltaX * deltaY;
            sumX += xv;
            sumY += yv;
        }
        if (!(sumXX > 0.0) || !(sumYY > 0.0)) {
            return sumXX == sumYY ? 1.0 : 0.0;
        }
        return sumXY / FastMath.sqrt(sumXX * sumYY);
    }

    public static double weightedCoefficient(double[] x, double[] y, double[] weights) {
        int xdim = x.length;
        int ydim = y.length;
        if (xdim != ydim) {
            throw new IllegalArgumentException("Invalid arguments: arrays differ in length.");
        }
        if (xdim != weights.length) {
            throw new IllegalArgumentException("Dimensionality doesn't agree to weights.");
        }
        if (xdim == 0) {
            throw new IllegalArgumentException("Empty vector.");
        }
        double sumXX = 0.0;
        double sumYY = 0.0;
        double sumXY = 0.0;
        double sumWe = weights[0];
        double sumX = x[0] * sumWe;
        double sumY = y[0] * sumWe;
        for (int i = 1; i < xdim; ++i) {
            double xv = x[i];
            double yv = y[i];
            double w = weights[i];
            double deltaX = xv * sumWe - sumX;
            double deltaY = yv * sumWe - sumY;
            double oldWe = sumWe;
            double f = w / ((sumWe += w) * oldWe);
            sumXX += f * deltaX * deltaX;
            sumYY += f * deltaY * deltaY;
            sumXY += f * deltaX * deltaY;
            sumX += xv * w;
            sumY += yv * w;
        }
        if (!(sumXX > 0.0) || !(sumYY > 0.0)) {
            return sumXX == sumYY ? 1.0 : 0.0;
        }
        return sumXY / FastMath.sqrt(sumXX * sumYY);
    }

    public static double weightedCoefficient(NumberVector x, NumberVector y, double[] weights) {
        int ydim;
        int xdim = x.getDimensionality();
        if (xdim != (ydim = y.getDimensionality())) {
            throw new IllegalArgumentException("Invalid arguments: number vectors differ in dimensionality.");
        }
        if (xdim != weights.length) {
            throw new IllegalArgumentException("Dimensionality doesn't agree to weights.");
        }
        if (xdim == 0) {
            throw new IllegalArgumentException("Empty vector.");
        }
        double sumXX = 0.0;
        double sumYY = 0.0;
        double sumXY = 0.0;
        double sumWe = weights[0];
        double sumX = x.doubleValue(0) * sumWe;
        double sumY = y.doubleValue(0) * sumWe;
        for (int i = 1; i < xdim; ++i) {
            double xv = x.doubleValue(i);
            double yv = y.doubleValue(i);
            double w = weights[i];
            double deltaX = xv * sumWe - sumX;
            double deltaY = yv * sumWe - sumY;
            double oldWe = sumWe;
            double f = w / ((sumWe += w) * oldWe);
            sumXX += f * deltaX * deltaX;
            sumYY += f * deltaY * deltaY;
            sumXY += f * deltaX * deltaY;
            sumX += xv * w;
            sumY += yv * w;
        }
        if (!(sumXX > 0.0) || !(sumYY > 0.0)) {
            return sumXX == sumYY ? 1.0 : 0.0;
        }
        return sumXY / FastMath.sqrt(sumXX * sumYY);
    }

    public static double weightedCoefficient(NumberVector x, NumberVector y, NumberVector weights) {
        int ydim;
        int xdim = x.getDimensionality();
        if (xdim != (ydim = y.getDimensionality())) {
            throw new IllegalArgumentException("Invalid arguments: feature vectors differ in dimensionality.");
        }
        if (xdim != weights.getDimensionality()) {
            throw new IllegalArgumentException("Dimensionality doesn't agree to weights.");
        }
        if (xdim == 0) {
            throw new IllegalArgumentException("Empty vector.");
        }
        double sumXX = 0.0;
        double sumYY = 0.0;
        double sumXY = 0.0;
        double sumWe = weights.doubleValue(0);
        double sumX = x.doubleValue(0) * sumWe;
        double sumY = y.doubleValue(0) * sumWe;
        for (int i = 1; i < xdim; ++i) {
            double xv = x.doubleValue(i);
            double yv = y.doubleValue(i);
            double w = weights.doubleValue(i);
            double deltaX = xv * sumWe - sumX;
            double deltaY = yv * sumWe - sumY;
            double oldWe = sumWe;
            double f = w / ((sumWe += w) * oldWe);
            sumXX += f * deltaX * deltaX;
            sumYY += f * deltaY * deltaY;
            sumXY += f * deltaX * deltaY;
            sumX += xv * w;
            sumY += yv * w;
        }
        if (!(sumXX > 0.0) || !(sumYY > 0.0)) {
            return sumXX == sumYY ? 1.0 : 0.0;
        }
        return sumXY / FastMath.sqrt(sumXX * sumYY);
    }
}

