/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math;

import net.jafama.DoubleWrapper;
import net.jafama.FastMath;

public abstract class SinCosTable {
    protected final int steps;

    private SinCosTable(int steps) {
        this.steps = steps;
    }

    public abstract double cos(int var1);

    public abstract double sin(int var1);

    public static SinCosTable make(int steps) {
        if ((steps & 3) == 0) {
            return new QuarterTable(steps);
        }
        if ((steps & 1) == 0) {
            return new HalfTable(steps);
        }
        return new FullTable(steps);
    }

    private static class QuarterTable
    extends SinCosTable {
        private final int quarsteps;
        private final int halfsteps;
        private final double[] costable;

        public QuarterTable(int steps) {
            super(steps);
            this.halfsteps = steps >> 1;
            this.quarsteps = steps >> 2;
            double radstep = Math.toRadians(360.0 / (double)steps);
            this.costable = new double[this.quarsteps + 1];
            double ang = 0.0;
            int i = 0;
            while (i < this.quarsteps + 1) {
                this.costable[i] = FastMath.cos(ang);
                ++i;
                ang += radstep;
            }
        }

        @Override
        public double cos(int step) {
            if ((step = Math.abs(step) % this.steps) < this.costable.length) {
                return this.costable[step];
            }
            if (step > this.halfsteps && (step = this.steps - step) < this.costable.length) {
                return this.costable[step];
            }
            step = this.halfsteps - step;
            return -this.costable[step];
        }

        @Override
        public double sin(int step) {
            return -this.cos(step + this.quarsteps);
        }
    }

    private static class HalfTable
    extends SinCosTable {
        private final int halfsteps;
        private final double[] costable;
        private final double[] sintable;

        public HalfTable(int steps) {
            super(steps);
            this.halfsteps = steps >> 1;
            double radstep = Math.toRadians(360.0 / (double)steps);
            this.costable = new double[this.halfsteps + 1];
            this.sintable = new double[this.halfsteps + 1];
            double ang = 0.0;
            int i = 0;
            while (i < this.halfsteps + 1) {
                this.costable[i] = FastMath.cos(ang);
                this.sintable[i] = FastMath.sin(ang);
                ++i;
                ang += radstep;
            }
        }

        @Override
        public double cos(int step) {
            if ((step = Math.abs(step) % this.steps) < this.costable.length) {
                return this.costable[step];
            }
            return this.costable[this.steps - step];
        }

        @Override
        public double sin(int step) {
            if ((step %= this.steps) < 0) {
                step += this.steps;
            }
            if (step < this.sintable.length) {
                return this.sintable[step];
            }
            return -this.sintable[this.steps - step];
        }
    }

    private static class FullTable
    extends SinCosTable {
        private final double[] costable;
        private final double[] sintable;

        public FullTable(int steps) {
            super(steps);
            double radstep = Math.toRadians(360.0 / (double)steps);
            this.costable = new double[steps];
            this.sintable = new double[steps];
            double ang = 0.0;
            DoubleWrapper tmp = new DoubleWrapper();
            int i = 0;
            while (i < steps) {
                this.sintable[i] = FastMath.sinAndCos(ang, tmp);
                this.costable[i] = tmp.value;
                ++i;
                ang += radstep;
            }
        }

        @Override
        public double cos(int step) {
            step = Math.abs(step) % this.steps;
            return this.costable[step];
        }

        @Override
        public double sin(int step) {
            if ((step %= this.steps) < 0) {
                step += this.steps;
            }
            return this.sintable[step];
        }
    }
}

