/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math;

import de.lmu.ifi.dbs.elki.math.Mean;
import de.lmu.ifi.dbs.elki.math.MeanVarianceMinMax;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.References;
import net.jafama.FastMath;

@References(value={@Reference(authors="Erich Schubert, Michael Gertz", title="Numerically Stable Parallel Computation of (Co-)Variance", booktitle="Proc. 30th Int. Conf. Scientific and Statistical Database Management (SSDBM 2018)", url="https://doi.org/10.1145/3221269.3223036", bibkey="DBLP:conf/ssdbm/SchubertG18"), @Reference(authors="T. B. Terriberry", title="Computing Higher-Order Moments Online", booktitle="", url="http://people.xiph.org/~tterribe/notes/homs.html", bibkey="web/Terriberry07"), @Reference(authors="P. P\u00e9bay", title="Formulas for Robust, One-Pass Parallel Computation of Covariances and Arbitrary-Order Statistical Moments", booktitle="Sandia Report SAND2008-6212, Sandia National Laboratories", url="https://prod.sandia.gov/techlib-noauth/access-control.cgi/2008/086212.pdf", bibkey="tr/sandia/Pebay08"), @Reference(authors="E. A. Youngs, E. M. Cramer", title="Some Results Relevant to Choice of Sum and Sum-of-Product Algorithms", booktitle="Technometrics 13(3)", url="https://doi.org/10.1080/00401706.1971.10488826", bibkey="doi:10.1080/00401706.1971.10488826")})
public class StatisticalMoments
extends MeanVarianceMinMax {
    double m3;
    double m4;

    public StatisticalMoments() {
        this.m3 = 0.0;
        this.m4 = 0.0;
    }

    public StatisticalMoments(StatisticalMoments other) {
        this.sum = other.sum;
        this.m2 = other.m2;
        this.n = other.n;
        this.m3 = other.m3;
        this.m4 = other.m4;
    }

    @Override
    public void put(double val) {
        if (this.n == 0.0) {
            this.n = 1.0;
            this.max = this.sum = val;
            this.min = this.sum;
            this.m4 = 0.0;
            this.m3 = 0.0;
            this.m2 = 0.0;
            return;
        }
        double nn = this.n + 1.0;
        double deltan = val * this.n - this.sum;
        double delta_nn = deltan / (this.n * nn);
        double delta_nn2 = delta_nn * delta_nn;
        double inc = deltan * delta_nn;
        this.m4 += inc * delta_nn2 * (nn * (nn - 3.0) + 3.0) + 6.0 * delta_nn2 * this.m2 - 4.0 * delta_nn * this.m3;
        this.m3 += inc * delta_nn * (nn - 2.0) - 3.0 * delta_nn * this.m2;
        this.m2 += inc;
        this.sum += val;
        this.n = nn;
        this.min = Math.min(this.min, val);
        this.max = Math.max(this.max, val);
    }

    @Override
    public void put(double val, double weight) {
        if (weight <= 0.0) {
            return;
        }
        if (this.n == 0.0) {
            this.n = weight;
            this.min = this.max = val;
            this.sum = val * weight;
            this.m4 = 0.0;
            this.m3 = 0.0;
            this.m2 = 0.0;
            return;
        }
        double nn = weight + this.n;
        double deltan = val * this.n - this.sum;
        double inc = deltan * weight;
        double delta_nn = deltan / (this.n * nn);
        double delta_nnw = delta_nn * weight;
        double delta_nn2 = delta_nn * delta_nn;
        double delta_nn3 = delta_nn2 * delta_nn;
        double nb2 = weight * weight;
        double tmp1 = this.n - weight;
        double tmp2 = this.n * tmp1 + nb2;
        this.m4 += inc * delta_nn3 * tmp2 + 6.0 * nb2 * this.m2 * delta_nn2 - 4.0 * this.m3 * delta_nnw;
        this.m3 += inc * delta_nn2 * tmp1 - 3.0 * this.m2 * delta_nnw;
        this.m2 += inc * delta_nn;
        this.sum += weight * val;
        this.n = nn;
        this.min = val < this.min ? val : this.min;
        this.max = val > this.max ? val : this.max;
    }

    @Override
    public void put(Mean other) {
        if (!(other instanceof StatisticalMoments)) {
            throw new IllegalArgumentException("I cannot combine Mean or MeanVariance into to a StatisticalMoments class.");
        }
        if (other.n == 0.0) {
            return;
        }
        StatisticalMoments othe = (StatisticalMoments)other;
        if (this.n == 0.0) {
            this.n = othe.n;
            this.sum = othe.sum;
            this.m2 = othe.m2;
            this.m3 = othe.m3;
            this.m4 = othe.m4;
            return;
        }
        double nn = othe.n + this.n;
        double delta = othe.sum / othe.n - this.sum / this.n;
        double delta_nn = delta / nn;
        double delta_nn2 = delta_nn * delta_nn;
        double delta_nn3 = delta_nn2 * delta_nn;
        double na2 = this.n * this.n;
        double nb2 = othe.n * othe.n;
        double ntn = this.n * othe.n;
        this.m4 += othe.m4 + delta * delta_nn3 * ntn * (na2 - ntn + nb2) + 6.0 * (na2 * othe.m2 + nb2 * this.m2) * delta_nn2 + 4.0 * (this.n * othe.m3 - othe.n * this.m3) * delta_nn;
        this.m3 += othe.m3 + delta * delta_nn2 * ntn * (this.n - othe.n) + 3.0 * (this.n * othe.m2 - othe.n * this.m2) * delta_nn;
        this.m2 += othe.m2 + delta * delta_nn * this.n * othe.n;
        this.sum += othe.sum;
        this.n = nn;
        this.min = Math.min(this.min, othe.min);
        this.max = Math.max(this.max, othe.max);
    }

    @Override
    public StatisticalMoments put(double[] vals) {
        for (double v : vals) {
            this.put(v);
        }
        return this;
    }

    @Override
    public StatisticalMoments put(double[] vals, double[] weights) {
        assert (vals.length == weights.length);
        int end = vals.length;
        for (int i = 0; i < end; ++i) {
            this.put(vals[i], weights[i]);
        }
        return this;
    }

    public double getSampleSkewness() {
        if (!(this.m2 > 0.0) || !(this.n > 2.0)) {
            throw new ArithmeticException("Skewness not defined when variance is 0 or weight <= 2.0!");
        }
        return this.m3 * this.n / (this.n - 1.0) / (this.n - 2.0) / FastMath.pow(this.getSampleVariance(), 1.5);
    }

    public double getNaiveSkewness() {
        return this.m3 / this.n / FastMath.pow(this.getNaiveVariance(), 1.5);
    }

    public double getSampleKurtosis() {
        if (!(this.m2 > 0.0) || !(this.n > 3.0)) {
            throw new ArithmeticException("Kurtosis not defined when variance is 0 or weight <= 3.0!");
        }
        double nm1 = this.n - 1.0;
        return nm1 / ((this.n - 2.0) * (this.n - 3.0)) * (this.n * (this.n + 1.0) * this.m4 / (this.m2 * this.m2) - 3.0 * nm1) + 3.0;
    }

    public double getNaiveKurtosis() {
        if (!(this.m2 > 0.0)) {
            throw new ArithmeticException("Kurtosis not defined when variance is 0!");
        }
        return this.n * this.m4 / (this.m2 * this.m2);
    }

    public double getSampleExcessKurtosis() {
        if (!(this.m2 > 0.0) || !(this.n > 3.0)) {
            throw new ArithmeticException("Kurtosis not defined when variance is 0 or weight <= 3.0!");
        }
        double nm1 = this.n - 1.0;
        return nm1 / ((this.n - 2.0) * (this.n - 3.0)) * (this.n * (this.n + 1.0) * this.m4 / (this.m2 * this.m2) - 3.0 * nm1);
    }

    public double getNaiveExcessKurtosis() {
        if (!(this.m2 > 0.0)) {
            throw new ArithmeticException("Kurtosis not defined when variance is 0!");
        }
        return this.n * this.m4 / (this.m2 * this.m2) - 3.0;
    }

    public static StatisticalMoments[] newArray(int dimensionality) {
        StatisticalMoments[] arr = new StatisticalMoments[dimensionality];
        for (int i = 0; i < dimensionality; ++i) {
            arr[i] = new StatisticalMoments();
        }
        return arr;
    }

    @Override
    public String toString() {
        return "StatisticalMoments(mean=" + this.getMean() + ",m2=" + this.m2 + ",m3=" + this.m3 + ",m4=" + this.m4 + ",n=" + this.n + ")";
    }

    @Override
    public void reset() {
        super.reset();
        this.m3 = 0.0;
        this.m4 = 0.0;
    }
}

