/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.geodesy;

import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import net.jafama.DoubleWrapper;
import net.jafama.FastMath;

@Reference(authors="E. Williams", title="Aviation Formulary", booktitle="", url="http://www.edwilliams.org/avform.htm", bibkey="web/Williams11")
public final class SphereUtil {
    private static final int MAX_ITER = 20;
    private static final double PRECISION = 1.0E-12;
    private static final double ONE_SIXTH = 0.16666666666666666;

    private SphereUtil() {
    }

    public static double cosineFormulaDeg(double lat1, double lon1, double lat2, double lon2) {
        return SphereUtil.cosineFormulaRad(MathUtil.deg2rad(lat1), MathUtil.deg2rad(lon1), MathUtil.deg2rad(lat2), MathUtil.deg2rad(lon2));
    }

    public static double cosineFormulaRad(double lat1, double lon1, double lat2, double lon2) {
        double clat2;
        if (lat1 == lat2 && lon1 == lon2) {
            return 0.0;
        }
        DoubleWrapper tmp = new DoubleWrapper();
        double slat1 = FastMath.sinAndCos(lat1, tmp);
        double clat1 = tmp.value;
        double slat2 = FastMath.sinAndCos(lat2, tmp);
        double a = slat1 * slat2 + clat1 * (clat2 = tmp.value) * FastMath.cos(lon2 - lon1);
        return a < 0.999999999999999 ? FastMath.acos(a) : 0.0;
    }

    public static double haversineFormulaDeg(double lat1, double lon1, double lat2, double lon2) {
        return SphereUtil.haversineFormulaRad(MathUtil.deg2rad(lat1), MathUtil.deg2rad(lon1), MathUtil.deg2rad(lat2), MathUtil.deg2rad(lon2));
    }

    @Reference(authors="R. W. Sinnott", title="Virtues of the Haversine", booktitle="Sky and Telescope 68(2)", bibkey="journals/skytelesc/Sinnott84")
    public static double haversineFormulaRad(double lat1, double lon1, double lat2, double lon2) {
        double slon;
        if (lat1 == lat2 && lon1 == lon2) {
            return 0.0;
        }
        double slat = FastMath.sin((lat1 - lat2) * 0.5);
        double a = slat * slat + (slon = FastMath.sin((lon1 - lon2) * 0.5)) * slon * FastMath.cos(lat1) * FastMath.cos(lat2);
        return a < 0.9 ? 2.0 * FastMath.asin(FastMath.sqrt(a)) : (a < 1.0 ? 2.0 * FastMath.atan2(FastMath.sqrt(a), FastMath.sqrt(1.0 - a)) : Math.PI);
    }

    public static double cosineOrHaversineDeg(double lat1, double lon1, double lat2, double lon2) {
        return SphereUtil.cosineOrHaversineRad(MathUtil.deg2rad(lat1), MathUtil.deg2rad(lon1), MathUtil.deg2rad(lat2), MathUtil.deg2rad(lon2));
    }

    public static double cosineOrHaversineRad(double lat1, double lon1, double lat2, double lon2) {
        if (lat1 == lat2 && lon1 == lon2) {
            return 0.0;
        }
        DoubleWrapper tmp = new DoubleWrapper();
        double slat1 = FastMath.sinAndCos(lat1, tmp);
        double clat1 = tmp.value;
        double slat2 = FastMath.sinAndCos(lat2, tmp);
        double clat2 = tmp.value;
        double dlat = lat1 - lat2;
        double dlon = lon1 - lon2;
        if (dlat > 0.01 || dlat < -0.01 || dlon > 0.01 || dlat < -0.01) {
            double a = slat1 * slat2 + clat1 * clat2 * FastMath.cos(dlon);
            return a < 0.999999999999999 ? FastMath.acos(a) : 0.0;
        }
        double slat = FastMath.sin(dlat * 0.5);
        double slon = FastMath.sin(dlon * 0.5);
        return 2.0 * FastMath.asin(FastMath.sqrt(slat * slat + slon * slon * clat1 * clat2));
    }

    public static double sphericalVincentyFormulaDeg(double lat1, double lon1, double lat2, double lon2) {
        return SphereUtil.sphericalVincentyFormulaRad(MathUtil.deg2rad(lat1), MathUtil.deg2rad(lon1), MathUtil.deg2rad(lat2), MathUtil.deg2rad(lon2));
    }

    @Reference(authors="T. Vincenty", title="Direct and inverse solutions of geodesics on the ellipsoid with application of nested equations", booktitle="Survey Review 23:176", url="https://doi.org/10.1179/sre.1975.23.176.88", bibkey="doi:10.1179/sre.1975.23.176.88")
    public static double sphericalVincentyFormulaRad(double lat1, double lon1, double lat2, double lon2) {
        double dlnh = lon1 > lon2 ? lon1 - lon2 : lon2 - lon1;
        DoubleWrapper tmp = new DoubleWrapper();
        double slat1 = FastMath.sinAndCos(lat1, tmp);
        double clat1 = tmp.value;
        double slat2 = FastMath.sinAndCos(lat2, tmp);
        double clat2 = tmp.value;
        double slond = FastMath.sinAndCos(dlnh, tmp);
        double clond = tmp.value;
        double a = clat2 * slond;
        double b = clat1 * slat2 - slat1 * clat2 * clond;
        return FastMath.atan2(FastMath.sqrt(a * a + b * b), slat1 * slat2 + clat1 * clat2 * clond);
    }

    public static double ellipsoidVincentyFormulaDeg(double f, double lat1, double lon1, double lat2, double lon2) {
        return SphereUtil.ellipsoidVincentyFormulaRad(f, MathUtil.deg2rad(lat1), MathUtil.deg2rad(lon1), MathUtil.deg2rad(lat2), MathUtil.deg2rad(lon2));
    }

    @Reference(authors="T. Vincenty", title="Direct and inverse solutions of geodesics on the ellipsoid with application of nested equations", booktitle="Survey Review 23:176", url="https://doi.org/10.1179/sre.1975.23.176.88", bibkey="doi:10.1179/sre.1975.23.176.88")
    public static double ellipsoidVincentyFormulaRad(double f, double lat1, double lon1, double lat2, double lon2) {
        double dlon = lon2 >= lon1 ? lon2 - lon1 : lon1 - lon2;
        double onemf = 1.0 - f;
        double a_b = 1.0 / onemf;
        double ecc2 = (a_b + 1.0) * (a_b - 1.0);
        double u1 = FastMath.atan(onemf * FastMath.tan(lat1));
        double u2 = FastMath.atan(onemf * FastMath.tan(lat2));
        DoubleWrapper tmp = new DoubleWrapper();
        double su1 = FastMath.sinAndCos(u1, tmp);
        double cu1 = tmp.value;
        double su2 = FastMath.sinAndCos(u2, tmp);
        double cu2 = tmp.value;
        double lambda = dlon;
        int i = 0;
        while (true) {
            double c2twosigm;
            double ctwosigm;
            double salp;
            double c2alp;
            double slon = FastMath.sinAndCos(lambda, tmp);
            double clon = tmp.value;
            double term1 = cu2 * slon;
            double term2 = cu1 * su2 - su1 * cu2 * clon;
            double ssig = FastMath.sqrt(term1 * term1 + term2 * term2);
            double csig = su1 * su2 + cu1 * cu2 * clon;
            if (!(ssig > 0.0)) {
                return 0.0;
            }
            double prevlambda = lambda;
            double cc = f * 0.0625 * c2alp * (4.0 + f * (4.0 - 3.0 * c2alp));
            double sigma = FastMath.atan2(ssig, csig);
            if (Math.abs(prevlambda - (lambda = dlon + (1.0 - cc) * f * salp * (sigma + cc * ssig * ((ctwosigm = Math.abs(c2alp = (1.0 + (salp = cu1 * cu2 * slon / ssig)) * (1.0 - salp)) > 0.0 ? csig - 2.0 * su1 * su2 / c2alp : 0.0) + cc * csig * (-1.0 + 2.0 * (c2twosigm = ctwosigm * ctwosigm)))))) < 1.0E-12 || i >= 20) {
                double usq = c2alp * ecc2;
                double aa = 1.0 + usq / 16384.0 * (4096.0 + usq * (-768.0 + usq * (320.0 - 175.0 * usq)));
                double bb = usq / 1024.0 * (256.0 + usq * (-128.0 + usq * (74.0 - 47.0 * usq)));
                double dsig = bb * ssig * (ctwosigm + 0.25 * bb * (csig * (-1.0 + 2.0 * c2twosigm) - 0.16666666666666666 * bb * ctwosigm * (-3.0 + 4.0 * ssig * ssig) * (-3.0 + 4.0 * c2twosigm)));
                return aa * (sigma - dsig);
            }
            ++i;
        }
    }

    public static double crossTrackDistanceDeg(double lat1, double lon1, double lat2, double lon2, double latQ, double lonQ) {
        return SphereUtil.crossTrackDistanceRad(MathUtil.deg2rad(lat1), MathUtil.deg2rad(lon1), MathUtil.deg2rad(lat2), MathUtil.deg2rad(lon2), MathUtil.deg2rad(latQ), MathUtil.deg2rad(lonQ));
    }

    public static double crossTrackDistanceRad(double lat1, double lon1, double lat2, double lon2, double latQ, double lonQ, double dist1Q) {
        double dlon12 = lon2 - lon1;
        double dlon1Q = lonQ - lon1;
        DoubleWrapper tmp = new DoubleWrapper();
        double slat1 = FastMath.sinAndCos(lat1, tmp);
        double clat1 = tmp.value;
        double slatQ = FastMath.sinAndCos(latQ, tmp);
        double clatQ = tmp.value;
        double slat2 = FastMath.sinAndCos(lat2, tmp);
        double clat2 = tmp.value;
        double sdlon12 = FastMath.sinAndCos(dlon12, tmp);
        double cdlon12 = tmp.value;
        double sdlon1Q = FastMath.sinAndCos(dlon1Q, tmp);
        double cdlon1Q = tmp.value;
        double yE = sdlon12 * clat2;
        double yQ = sdlon1Q * clatQ;
        double xE = clat1 * slat2 - slat1 * clat2 * cdlon12;
        double xQ = clat1 * slatQ - slat1 * clatQ * cdlon1Q;
        double crs12 = FastMath.atan2(yE, xE);
        double crs1Q = FastMath.atan2(yQ, xQ);
        return FastMath.asin(FastMath.sin(dist1Q) * FastMath.sin(crs1Q - crs12));
    }

    public static double crossTrackDistanceDeg(double lat1, double lon1, double lat2, double lon2, double latQ, double lonQ, double dist1Q) {
        return SphereUtil.crossTrackDistanceRad(MathUtil.deg2rad(lat1), MathUtil.deg2rad(lon1), MathUtil.deg2rad(lat2), MathUtil.deg2rad(lon2), MathUtil.deg2rad(latQ), MathUtil.deg2rad(lonQ), dist1Q);
    }

    public static double crossTrackDistanceRad(double lat1, double lon1, double lat2, double lon2, double latQ, double lonQ) {
        double slon;
        double dlon12 = lon2 - lon1;
        double dlon1Q = lonQ - lon1;
        double dlat1Q = latQ - lat1;
        DoubleWrapper tmp = new DoubleWrapper();
        double slat1 = FastMath.sinAndCos(lat1, tmp);
        double clat1 = tmp.value;
        double slatQ = FastMath.sinAndCos(latQ, tmp);
        double clatQ = tmp.value;
        double slat2 = FastMath.sinAndCos(lat2, tmp);
        double clat2 = tmp.value;
        double sdlon12 = FastMath.sinAndCos(dlon12, tmp);
        double cdlon12 = tmp.value;
        double sdlon1Q = FastMath.sinAndCos(dlon1Q, tmp);
        double cdlon1Q = tmp.value;
        double yE = sdlon12 * clat2;
        double yQ = sdlon1Q * clatQ;
        double xE = clat1 * slat2 - slat1 * clat2 * cdlon12;
        double xQ = clat1 * slatQ - slat1 * clatQ * cdlon1Q;
        double slat = FastMath.sin(dlat1Q * 0.5);
        double a = slat * slat + (slon = FastMath.sin(dlon1Q * 0.5)) * slon * clat1 * clatQ;
        if (a > 0.999999999999999 || a < -0.999999999999999 || a == 0.0) {
            return 0.0;
        }
        double crs12 = FastMath.atan2(yE, xE);
        double crs1Q = FastMath.atan2(yQ, xQ);
        return FastMath.asin(FastMath.sqrt(a) * FastMath.sqrt(1.0 - a) * 2.0 * FastMath.sin(crs1Q - crs12));
    }

    public static double alongTrackDistanceDeg(double lat1, double lon1, double lat2, double lon2, double latQ, double lonQ) {
        return SphereUtil.alongTrackDistanceRad(MathUtil.deg2rad(lat1), MathUtil.deg2rad(lon1), MathUtil.deg2rad(lat2), MathUtil.deg2rad(lon2), MathUtil.deg2rad(latQ), MathUtil.deg2rad(lonQ));
    }

    public static double alongTrackDistanceRad(double lat1, double lon1, double lat2, double lon2, double latQ, double lonQ) {
        double dist1Q = SphereUtil.haversineFormulaRad(lat1, lon1, latQ, lonQ);
        double ctd = SphereUtil.crossTrackDistanceRad(lat1, lon1, lat2, lon2, latQ, lonQ, dist1Q);
        return SphereUtil.alongTrackDistanceRad(lat1, lon1, lat2, lon2, latQ, lonQ, dist1Q, ctd);
    }

    public static double alongTrackDistanceDeg(double lat1, double lon1, double lat2, double lon2, double latQ, double lonQ, double dist1Q, double ctd) {
        return SphereUtil.alongTrackDistanceRad(MathUtil.deg2rad(lat1), MathUtil.deg2rad(lon1), MathUtil.deg2rad(lat2), MathUtil.deg2rad(lon2), MathUtil.deg2rad(latQ), MathUtil.deg2rad(lonQ), dist1Q, ctd);
    }

    public static double alongTrackDistanceRad(double lat1, double lon1, double lat2, double lon2, double latQ, double lonQ, double dist1Q, double ctd) {
        int sign = Math.abs(SphereUtil.bearingRad(lat1, lon1, lat2, lon2) - SphereUtil.bearingRad(lat1, lon1, latQ, lonQ)) < 1.5707963267948966 ? 1 : -1;
        return (double)sign * FastMath.acos(FastMath.cos(dist1Q) / FastMath.cos(ctd));
    }

    @Reference(authors="Erich Schubert, Arthur Zimek, Hans-Peter Kriegel", title="Geodetic Distance Queries on R-Trees for Indexing Geographic Data", booktitle="Int. Symp. Advances in Spatial and Temporal Databases (SSTD'2013)", url="https://doi.org/10.1007/978-3-642-40235-7_9", bibkey="DBLP:conf/ssd/SchubertZK13")
    public static double latlngMinDistDeg(double plat, double plng, double rminlat, double rminlng, double rmaxlat, double rmaxlng) {
        return SphereUtil.latlngMinDistRad(MathUtil.deg2rad(plat), MathUtil.deg2rad(plng), MathUtil.deg2rad(rminlat), MathUtil.deg2rad(rminlng), MathUtil.deg2rad(rmaxlat), MathUtil.deg2rad(rmaxlng));
    }

    @Reference(authors="Erich Schubert, Arthur Zimek, Hans-Peter Kriegel", title="Geodetic Distance Queries on R-Trees for Indexing Geographic Data", booktitle="Int. Symp. Advances in Spatial and Temporal Databases (SSTD'2013)", url="https://doi.org/10.1007/978-3-642-40235-7_9", bibkey="DBLP:conf/ssd/SchubertZK13")
    public static double latlngMinDistRad(double plat, double plng, double rminlat, double rminlng, double rmaxlat, double rmaxlng) {
        if (rminlat >= rmaxlat && rminlng >= rmaxlng) {
            return SphereUtil.cosineOrHaversineRad(rminlat, rminlng, plat, plng);
        }
        if (rminlng <= plng && plng <= rmaxlng) {
            return rminlat <= plat && plat <= rmaxlat ? 0.0 : (plat < rminlat ? rminlat - plat : plat - rmaxlat);
        }
        double lngE = rminlng - plng;
        double lngW = plng - rmaxlng;
        lngE = lngE >= 0.0 ? lngE : lngE + Math.PI * 2;
        lngW = lngW >= 0.0 ? lngW : lngW + Math.PI * 2;
        double lngD = lngE <= lngW ? lngE : lngW;
        double rlng = lngE <= lngW ? rminlng : rmaxlng;
        DoubleWrapper tmp = new DoubleWrapper();
        double slngD = FastMath.sinAndCos(lngD, tmp);
        double clngD = tmp.value;
        double tlatQ = FastMath.tan(plat);
        if (lngD >= 1.5707963267948966) {
            return SphereUtil.cosineOrHaversineRad(plat, plng, tlatQ >= FastMath.tan((rmaxlat + rminlat) * 0.5) * clngD ? rmaxlat : rminlat, rlng);
        }
        if (tlatQ >= FastMath.tan(rmaxlat) * clngD) {
            return SphereUtil.cosineOrHaversineRad(plat, plng, rmaxlat, rlng);
        }
        if (tlatQ <= FastMath.tan(rminlat) * clngD) {
            return SphereUtil.cosineOrHaversineRad(plat, plng, rminlat, rlng);
        }
        return FastMath.asin(FastMath.cos(plat) * slngD);
    }

    @Reference(authors="Erich Schubert, Arthur Zimek, Hans-Peter Kriegel", title="Geodetic Distance Queries on R-Trees for Indexing Geographic Data", booktitle="Int. Symp. Advances in Spatial and Temporal Databases (SSTD'2013)", url="https://doi.org/10.1007/978-3-642-40235-7_9", bibkey="DBLP:conf/ssd/SchubertZK13")
    public static double latlngMinDistRadFull(double plat, double plng, double rminlat, double rminlng, double rmaxlat, double rmaxlng) {
        if (rminlat >= rmaxlat && rminlng >= rmaxlng) {
            return SphereUtil.haversineFormulaRad(rminlat, rminlng, plat, plng);
        }
        if (rminlng <= plng && plng <= rmaxlng) {
            return rminlat <= plat && plat <= rmaxlat ? 0.0 : (plat < rminlat ? rminlat - plat : plat - rmaxlat);
        }
        double lngE = rminlng - plng;
        lngE = lngE >= 0.0 ? lngE : lngE + Math.PI * 2;
        double lngW = plng - rmaxlng;
        lngW = lngW >= 0.0 ? lngW : lngW + Math.PI * 2;
        DoubleWrapper tmp = new DoubleWrapper();
        double slatQ = FastMath.sinAndCos(plat, tmp);
        double clatQ = tmp.value;
        double slatN = FastMath.sinAndCos(rmaxlat, tmp);
        double clatN = tmp.value;
        double slatS = FastMath.sinAndCos(rminlat, tmp);
        double clatS = tmp.value;
        if (lngE <= lngW) {
            double slngD = FastMath.sinAndCos(lngE, tmp);
            double clngD = tmp.value;
            double bs = FastMath.atan2(slngD * clatQ, clatS * slatQ - slatS * clatQ * clngD);
            double bn = FastMath.atan2(slngD * clatQ, clatN * slatQ - slatN * clatQ * clngD);
            if (bs < 1.5707963267948966 && bn > 1.5707963267948966) {
                double radFromS = -1.5707963267948966 - plat;
                return FastMath.asin(FastMath.sin(radFromS) * -slngD);
            }
            if (bs - 1.5707963267948966 < 1.5707963267948966 - bn) {
                double slatN2 = FastMath.sin((plat - rmaxlat) * 0.5);
                double slon = FastMath.sin(lngE * 0.5);
                double aN = slatN2 * slatN2 + slon * slon * clatQ * clatN;
                return 2.0 * FastMath.atan2(FastMath.sqrt(aN), FastMath.sqrt(1.0 - aN));
            }
            double slatS2 = FastMath.sin((plat - rminlat) * 0.5);
            double slon = FastMath.sin(lngE * 0.5);
            double aS = slatS2 * slatS2 + slon * slon * clatQ * clatS;
            return 2.0 * FastMath.atan2(FastMath.sqrt(aS), FastMath.sqrt(1.0 - aS));
        }
        double slngD = -FastMath.sinAndCos(lngW, tmp);
        double clngD = tmp.value;
        double bs = FastMath.atan2(slngD * clatQ, clatS * slatQ - slatS * clatQ * clngD);
        double bn = FastMath.atan2(slngD * clatQ, clatN * slatQ - slatN * clatQ * clngD);
        if (bs > -1.5707963267948966 && bn < -1.5707963267948966) {
            double radFromS = -1.5707963267948966 - plat;
            return FastMath.asin(FastMath.sin(radFromS) * slngD);
        }
        if (-1.5707963267948966 - bs < bn + 1.5707963267948966) {
            double slatN2 = FastMath.sin((plat - rmaxlat) * 0.5);
            double slon = FastMath.sin(lngW * 0.5);
            double aN = slatN2 * slatN2 + slon * slon * clatQ * clatN;
            return 2.0 * FastMath.atan2(FastMath.sqrt(aN), FastMath.sqrt(1.0 - aN));
        }
        double slatS2 = FastMath.sin((plat - rminlat) * 0.5);
        double slon = FastMath.sin(lngW * 0.5);
        double aS = slatS2 * slatS2 + slon * slon * clatQ * clatS;
        return 2.0 * FastMath.atan2(FastMath.sqrt(aS), FastMath.sqrt(1.0 - aS));
    }

    public static double bearingDegDeg(double latS, double lngS, double latE, double lngE) {
        return MathUtil.rad2deg(SphereUtil.bearingRad(MathUtil.deg2rad(latS), MathUtil.deg2rad(lngS), MathUtil.deg2rad(latE), MathUtil.deg2rad(lngE)));
    }

    public static double bearingRad(double latS, double lngS, double latE, double lngE) {
        DoubleWrapper tmp = new DoubleWrapper();
        double slatS = FastMath.sinAndCos(latS, tmp);
        double clatS = tmp.value;
        double slatE = FastMath.sinAndCos(latE, tmp);
        double clatE = tmp.value;
        return FastMath.atan2(-FastMath.sin(lngS - lngE) * clatE, clatS * slatE - slatS * clatE * FastMath.cos(lngS - lngE));
    }
}

