/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.geodesy;

import de.lmu.ifi.dbs.elki.math.geodesy.AbstractEarthModel;
import de.lmu.ifi.dbs.elki.math.geodesy.SphereUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import net.jafama.DoubleWrapper;
import net.jafama.FastMath;

public class SphericalCosineEarthModel
extends AbstractEarthModel {
    public static final SphericalCosineEarthModel STATIC = new SphericalCosineEarthModel();
    public static final double EARTH_RADIUS = 6371009.0;

    protected SphericalCosineEarthModel() {
        super(6371009.0, 6371009.0, 0.0, Double.POSITIVE_INFINITY);
    }

    @Override
    public double[] latLngRadToECEF(double lat, double lng) {
        DoubleWrapper tmp = new DoubleWrapper();
        double slat = FastMath.sinAndCos(lat, tmp);
        double clat = tmp.value;
        double slng = FastMath.sinAndCos(lng, tmp);
        double clng = tmp.value;
        return new double[]{6371009.0 * clat * clng, 6371009.0 * clat * slng, 6371009.0 * slat};
    }

    @Override
    public double[] latLngRadToECEF(double lat, double lng, double h) {
        DoubleWrapper tmp = new DoubleWrapper();
        double slat = FastMath.sinAndCos(lat, tmp);
        double clat = tmp.value;
        double slng = FastMath.sinAndCos(lng, tmp);
        double clng = tmp.value;
        return new double[]{(6371009.0 + h) * clat * clng, (6371009.0 + h) * clat * slng, (6371009.0 + h) * slat};
    }

    @Override
    public double ecefToLatRad(double x, double y, double z) {
        double p = FastMath.sqrt(x * x + y * y);
        return FastMath.atan2(z, p);
    }

    @Override
    public double distanceRad(double lat1, double lng1, double lat2, double lng2) {
        return 6371009.0 * SphereUtil.cosineFormulaRad(lat1, lng1, lat2, lng2);
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected SphericalCosineEarthModel makeInstance() {
            return STATIC;
        }
    }
}

