/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.geometry;

import de.lmu.ifi.dbs.elki.data.spatial.Polygon;
import de.lmu.ifi.dbs.elki.math.geometry.SweepHullDelaunay2D;
import de.lmu.ifi.dbs.elki.utilities.datastructures.BitsUtil;
import java.util.ArrayList;
import java.util.List;

public class AlphaShape {
    private double alpha2;
    private List<double[]> points;
    private ArrayList<SweepHullDelaunay2D.Triangle> delaunay = null;

    public AlphaShape(List<double[]> points, double alpha) {
        this.alpha2 = alpha * alpha;
        this.points = points;
    }

    public List<Polygon> compute() {
        this.delaunay = new SweepHullDelaunay2D(this.points).getDelaunay();
        ArrayList<Polygon> polys = new ArrayList<Polygon>();
        long[] used = BitsUtil.zero(this.delaunay.size());
        ArrayList<Object> cur = new ArrayList<double[]>();
        int i = 0;
        while (i < this.delaunay.size() && i >= 0) {
            if (!BitsUtil.get(used, i)) {
                BitsUtil.setI(used, i);
                SweepHullDelaunay2D.Triangle tri = this.delaunay.get(i);
                if (tri.r2 <= this.alpha2) {
                    this.processNeighbor(cur, used, i, tri.ab, tri.b);
                    this.processNeighbor(cur, used, i, tri.bc, tri.c);
                    this.processNeighbor(cur, used, i, tri.ca, tri.a);
                }
                if (!cur.isEmpty()) {
                    polys.add(new Polygon(cur));
                    cur = new ArrayList();
                }
            }
            i = BitsUtil.nextClearBit(used, i + 1);
        }
        return polys;
    }

    private void processNeighbor(List<double[]> cur, long[] used, int i, int ab, int b) {
        if (ab >= 0) {
            if (BitsUtil.get(used, ab)) {
                return;
            }
            BitsUtil.setI(used, ab);
            SweepHullDelaunay2D.Triangle next = this.delaunay.get(ab);
            if (next.r2 <= this.alpha2) {
                if (next.ab == i) {
                    this.processNeighbor(cur, used, ab, next.bc, next.c);
                    this.processNeighbor(cur, used, ab, next.ca, next.a);
                } else if (next.bc == i) {
                    this.processNeighbor(cur, used, ab, next.ca, next.a);
                    this.processNeighbor(cur, used, ab, next.ab, next.b);
                } else if (next.ca == i) {
                    this.processNeighbor(cur, used, ab, next.ab, next.b);
                    this.processNeighbor(cur, used, ab, next.bc, next.c);
                }
                return;
            }
        }
        cur.add(this.points.get(b));
    }
}

