/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.geometry;

import de.lmu.ifi.dbs.elki.data.spatial.Polygon;
import de.lmu.ifi.dbs.elki.math.geometry.GrahamScanConvexHull2D;
import java.util.ArrayList;
import java.util.List;

public class FilteredConvexHull2D {
    private List<double[]> points;
    private double leftx = Double.POSITIVE_INFINITY;
    private double rightx = Double.NEGATIVE_INFINITY;
    private double topy = Double.NEGATIVE_INFINITY;
    private double bottomy = Double.POSITIVE_INFINITY;
    private double[] topleft;
    private double[] topright;
    private double[] bottomright;
    private double[] bottomleft;
    private Polygon poly = null;

    public FilteredConvexHull2D() {
        this.points = new ArrayList<double[]>();
    }

    public void add(double ... point) {
        this.poly = null;
        if (this.checkCandidateUpdate(point)) {
            this.points.add(point);
        }
    }

    private Polygon computeConvexHull() {
        GrahamScanConvexHull2D inner = new GrahamScanConvexHull2D();
        for (double[] point : this.points) {
            if (!this.checkCandidate(point)) continue;
            inner.add(point);
        }
        return inner.getHull();
    }

    private boolean checkCandidate(double[] point) {
        double v = point[0];
        return v <= this.leftx || v >= this.rightx || (v = point[1]) <= this.bottomy || v >= this.topy;
    }

    private boolean checkCandidateUpdate(double[] point) {
        double x = point[0];
        double y = point[1];
        if (this.points.isEmpty()) {
            this.leftx = this.rightx = x;
            this.topy = this.bottomy = y;
            this.bottomright = point;
            this.bottomleft = point;
            this.topright = this.bottomleft;
            this.topleft = this.bottomleft;
            return true;
        }
        if (x <= this.leftx || x >= this.rightx || y <= this.bottomy || y >= this.topy) {
            double xpy = x + y;
            double xmy = x - y;
            boolean changed = false;
            if (xpy < this.bottomleft[0] + this.bottomleft[1]) {
                this.bottomleft = point;
                changed = true;
            } else if (xpy > this.topright[0] + this.topright[1]) {
                this.topright = point;
                changed = true;
            }
            if (xmy < this.topleft[0] - this.topleft[1]) {
                this.topleft = point;
                changed = true;
            } else if (xmy > this.bottomright[0] - this.bottomright[1]) {
                this.bottomright = point;
                changed = true;
            }
            if (changed) {
                this.leftx = Math.max(this.bottomleft[0], this.topleft[0]);
                this.rightx = Math.min(this.bottomright[0], this.topright[0]);
                this.topy = Math.min(this.topleft[1], this.topright[1]);
                this.bottomy = Math.max(this.bottomleft[1], this.bottomright[1]);
            }
            return true;
        }
        return false;
    }

    public Polygon getHull() {
        return this.poly == null ? (this.poly = this.computeConvexHull()) : this.poly;
    }
}

