/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.geometry;

import de.lmu.ifi.dbs.elki.data.spatial.Polygon;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;

@Reference(authors="P. Graham", title="An Efficient Algorithm for Determining the Convex Hull of a Finite Planar Set", booktitle="Information Processing Letters 1", url="https://doi.org/10.1016/0020-0190(72)90045-2", bibkey="DBLP:journals/ipl/Graham72")
public class GrahamScanConvexHull2D {
    private List<double[]> points;
    private DoubleMinMax minmaxX = new DoubleMinMax();
    private DoubleMinMax minmaxY = new DoubleMinMax();
    private boolean ok = false;
    private double factor = 1.0;

    public GrahamScanConvexHull2D() {
        this.points = new ArrayList<double[]>();
    }

    public void add(double ... point) {
        if (this.ok) {
            this.points = new ArrayList<double[]>(this.points);
            this.ok = false;
        }
        this.points.add(point);
        this.minmaxX.put(point[0]);
        this.minmaxY.put(point[1]);
    }

    private void computeConvexHull() {
        if (this.points.size() < 3) {
            this.ok = true;
            return;
        }
        double maxX = Math.max(Math.abs(this.minmaxX.getMin()), Math.abs(this.minmaxX.getMax()));
        double maxY = Math.max(Math.abs(this.minmaxY.getMin()), Math.abs(this.minmaxY.getMax()));
        if (maxX < 10.0 || maxY < 10.0) {
            this.factor = 10.0 / maxX;
            if (10.0 / maxY > this.factor) {
                this.factor = 10.0 / maxY;
            }
        }
        this.findStartingPoint();
        final double[] origin = this.points.get(0);
        Collections.sort(this.points, new Comparator<double[]>(){

            @Override
            public int compare(double[] o1, double[] o2) {
                return GrahamScanConvexHull2D.this.isLeft(o1, o2, origin);
            }
        });
        this.grahamScan();
        this.ok = true;
    }

    private void findStartingPoint() {
        double bestY = this.minmaxY.getMin();
        double bestX = Double.POSITIVE_INFINITY;
        int bestI = -1;
        Iterator<double[]> iter = this.points.iterator();
        int i = 0;
        while (iter.hasNext()) {
            double[] vec = iter.next();
            if (vec[1] == bestY && vec[0] < bestX) {
                bestX = vec[0];
                bestI = i;
            }
            ++i;
        }
        assert (bestI >= 0);
        if (bestI > 0) {
            this.points.add(0, this.points.remove(bestI));
        }
    }

    private double getRX(double[] a, double[] origin) {
        return (a[0] - origin[0]) * this.factor;
    }

    private double getRY(double[] a, double[] origin) {
        return (a[1] - origin[1]) * this.factor;
    }

    protected final int isLeft(double[] a, double[] b, double[] o) {
        double cross = this.getRX(a, o) * this.getRY(b, o) - this.getRY(a, o) * this.getRX(b, o);
        if (cross == 0.0) {
            double dista = Math.abs(this.getRX(a, o)) + Math.abs(this.getRY(a, o));
            double distb = Math.abs(this.getRX(b, o)) + Math.abs(this.getRY(b, o));
            return Double.compare(dista, distb);
        }
        return Double.compare(cross, 0.0);
    }

    private double mdist(double[] a, double[] b) {
        return Math.abs(a[0] - b[0]) + Math.abs(a[1] - b[1]);
    }

    private boolean isConvex(double[] a, double[] b, double[] c) {
        double area = (b[0] - a[0]) * this.factor * (c[1] - a[1]) - (c[0] - a[0]) * this.factor * (b[1] - a[1]);
        return -1.0E-13 < area && area < 1.0E-13 ? this.mdist(b, c) > this.mdist(a, b) + this.mdist(a, c) : area < 0.0;
    }

    private void grahamScan() {
        if (this.points.size() < 3) {
            return;
        }
        Iterator<double[]> iter = this.points.iterator();
        Stack<double[]> stack = new Stack<double[]>();
        double[] first = iter.next();
        stack.add(first);
        while (iter.hasNext()) {
            double[] n = iter.next();
            if (!(this.mdist(first, n) > 0.0)) continue;
            stack.add(n);
            break;
        }
        while (iter.hasNext()) {
            double[] next = iter.next();
            double[] curr = stack.pop();
            double[] prev = stack.peek();
            while (!(stack.size() <= 1 || this.mdist(curr, next) != 0.0 && this.isConvex(prev, curr, next))) {
                curr = stack.pop();
                prev = stack.peek();
            }
            stack.add(curr);
            stack.add(next);
        }
        this.points = stack;
    }

    public Polygon getHull() {
        if (!this.ok) {
            this.computeConvexHull();
        }
        return new Polygon(this.points, this.minmaxX.getMin(), this.minmaxX.getMax(), this.minmaxY.getMin(), this.minmaxY.getMax());
    }
}

