/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.geometry;

import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import java.util.Arrays;

@Reference(authors="R. C. Prim", title="Shortest connection networks and some generalizations", booktitle="Bell System Technical Journal, 36 (1957)", url="https://doi.org/10.1002/j.1538-7305.1957.tb01515.x", bibkey="doi:10.1002/j.1538-7305.1957.tb01515.x")
public class PrimsMinimumSpanningTree {
    public static final Array2DAdapter ARRAY2D_ADAPTER = new Array2DAdapter();

    public static int[] processDense(double[][] mat) {
        return PrimsMinimumSpanningTree.processDense(mat, ARRAY2D_ADAPTER);
    }

    public static <T> int[] processDense(T data, Adapter<T> adapter) {
        int n = adapter.size(data);
        int[] mst = new int[n - 1 << 1];
        double[] best = new double[n];
        Arrays.fill(best, Double.POSITIVE_INFINITY);
        int[] src = new int[n];
        byte[] connected = new byte[n];
        int current = 0;
        connected[current] = 1;
        best[current] = 0.0;
        for (int i = n - 2; i >= 0; --i) {
            int newbesti = -1;
            double newbestd = Double.POSITIVE_INFINITY;
            for (int j = 0; j < n; ++j) {
                if (connected[j] == 1) continue;
                double dist = adapter.distance(data, current, j);
                if (dist < best[j]) {
                    best[j] = dist;
                    src[j] = current;
                }
                if (!(best[j] < newbestd) && newbesti != -1) continue;
                newbestd = best[j];
                newbesti = j;
            }
            assert (newbesti >= 0);
            connected[newbesti] = 1;
            mst[i << 1] = newbesti;
            mst[(i << 1) + 1] = src[newbesti];
            current = newbesti;
        }
        return mst;
    }

    public static <T> void processDense(T data, Adapter<T> adapter, Collector collector) {
        int n = adapter.size(data);
        double[] best = new double[n];
        Arrays.fill(best, Double.POSITIVE_INFINITY);
        int[] src = new int[n];
        byte[] connected = new byte[n];
        int current = 0;
        connected[current] = 1;
        best[current] = 0.0;
        for (int i = n - 2; i >= 0; --i) {
            int newbesti = -1;
            double newbestd = Double.POSITIVE_INFINITY;
            for (int j = 0; j < n; ++j) {
                if (connected[j] == 1) continue;
                double dist = adapter.distance(data, current, j);
                if (dist < best[j]) {
                    best[j] = dist;
                    src[j] = current;
                }
                if (!(best[j] < newbestd) && newbesti != -1) continue;
                newbestd = best[j];
                newbesti = j;
            }
            assert (newbesti >= 0);
            connected[newbesti] = 1;
            collector.addEdge(newbestd, src[newbesti], newbesti);
            current = newbesti;
        }
    }

    public static int[] pruneTree(int numnodes, int[] tree, int minDegree) {
        int[] deg = new int[numnodes];
        for (int i = 0; i < tree.length; ++i) {
            int n = tree[i];
            deg[n] = deg[n] + 1;
        }
        int keep = 0;
        for (int i = 1; i < tree.length; i += 2) {
            if (deg[tree[i - 1]] < minDegree || deg[tree[i]] < minDegree) continue;
            ++keep;
        }
        int j = 0;
        int[] ret = new int[keep];
        for (int i = 1; i < tree.length; i += 2) {
            if (deg[tree[i - 1]] < minDegree || deg[tree[i]] < minDegree) continue;
            ret[j++] = tree[i - 1];
            ret[j++] = tree[i];
        }
        assert (j == ret.length);
        return ret;
    }

    public static class Array2DAdapter
    implements Adapter<double[][]> {
        private Array2DAdapter() {
        }

        @Override
        public double distance(double[][] data, int i, int j) {
            return data[i][j];
        }

        @Override
        public int size(double[][] data) {
            return data.length;
        }
    }

    @FunctionalInterface
    public static interface Collector {
        public void addEdge(double var1, int var3, int var4);
    }

    public static interface Adapter<T> {
        public double distance(T var1, int var2, int var3);

        public int size(T var1);
    }
}

