/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.geometry;

import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.DoubleArray;

public class XYCurve
implements Result {
    protected static final double THRESHOLD = 1.0E-13;
    protected DoubleArray data;
    protected String labelx;
    protected String labely;
    protected double minx = Double.POSITIVE_INFINITY;
    protected double maxx = Double.NEGATIVE_INFINITY;
    protected double miny = Double.POSITIVE_INFINITY;
    protected double maxy = Double.NEGATIVE_INFINITY;

    public XYCurve(String labelx, String labely) {
        this.data = new DoubleArray();
        this.labelx = labelx;
        this.labely = labely;
    }

    public XYCurve(String labelx, String labely, int size) {
        this.data = new DoubleArray(size << 1);
        this.labelx = labelx;
        this.labely = labely;
    }

    public XYCurve() {
        this("X", "Y");
    }

    public XYCurve(int size) {
        this("X", "Y", size);
    }

    public XYCurve(XYCurve curve) {
        this.data = new DoubleArray(curve.data);
        this.labelx = curve.labelx;
        this.labely = curve.labely;
        this.minx = curve.minx;
        this.maxx = curve.maxx;
        this.miny = curve.miny;
        this.maxy = curve.maxy;
    }

    public void add(double x, double y) {
        this.data.add(x);
        this.data.add(y);
        this.minx = Math.min(this.minx, x);
        this.maxx = Math.max(this.maxx, x);
        this.miny = Math.min(this.miny, y);
        this.maxy = Math.max(this.maxy, y);
    }

    public void addAndSimplify(double x, double y) {
        int len = this.data.size();
        if (len >= 4) {
            double l1x = this.data.get(len - 4);
            double l1y = this.data.get(len - 3);
            double l2x = this.data.get(len - 2);
            double l2y = this.data.get(len - 1);
            double ldx = l2x - l1x;
            double ldy = l2y - l1y;
            double cdx = x - l2x;
            double cdy = y - l2y;
            if (ldx == 0.0 && cdx == 0.0) {
                this.data.remove(len - 2, 2);
            } else if (ldy == 0.0 && cdy == 0.0) {
                this.data.remove(len - 2, 2);
            } else if (ldy > 0.0 && cdy > 0.0 && Math.abs(ldx / ldy - cdx / cdy) < 1.0E-13) {
                this.data.remove(len - 2, 2);
            }
        }
        this.add(x, y);
    }

    public String getLabelx() {
        return this.labelx;
    }

    public String getLabely() {
        return this.labely;
    }

    public double getMinx() {
        return this.minx;
    }

    public double getMaxx() {
        return this.maxx;
    }

    public double getMiny() {
        return this.miny;
    }

    public double getMaxy() {
        return this.maxy;
    }

    public double getX(int off) {
        return this.data.get(off << 1);
    }

    public double getY(int off) {
        return this.data.get((off << 1) + 1);
    }

    public void rescale(double sx, double sy) {
        for (int i = 0; i < this.data.size(); i += 2) {
            this.data.set(i, sx * this.data.get(i));
            this.data.set(i + 1, sy * this.data.get(i + 1));
        }
        this.maxx *= sx;
        this.maxy *= sy;
    }

    public int size() {
        return this.data.size() >> 1;
    }

    public Itr iterator() {
        return new Itr();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("XYCurve[");
        buf.append(this.labelx).append(',').append(this.labely).append(':');
        for (int pos = 0; pos < this.data.size(); pos += 2) {
            buf.append(' ').append(this.data.get(pos)).append(',').append(this.data.get(pos + 1));
        }
        buf.append(']');
        return buf.toString();
    }

    @Override
    public String getLongName() {
        return this.labelx + "-" + this.labely + "-Curve";
    }

    @Override
    public String getShortName() {
        return (this.labelx + "-" + this.labely + "-curve").toLowerCase();
    }

    public static double areaUnderCurve(XYCurve curve) {
        DoubleArray data = curve.data;
        double prevx = data.get(0);
        double prevy = data.get(1);
        if (prevx > curve.minx) {
            throw new UnsupportedOperationException("Curves must be monotone on X for areaUnderCurve to be valid.");
        }
        double area = 0.0;
        for (int pos = 2; pos < data.size(); pos += 2) {
            double curx = data.get(pos);
            double cury = data.get(pos + 1);
            if (prevx > curx) {
                throw new UnsupportedOperationException("Curves must be monotone on X for areaUnderCurve to be valid.");
            }
            area += (curx - prevx) * (prevy + cury) * 0.5;
            prevx = curx;
            prevy = cury;
        }
        if (prevx < curve.maxx) {
            throw new UnsupportedOperationException("Curves must be complete on X for areaUnderCurve to be valid.");
        }
        return area;
    }

    public class Itr {
        protected int pos = 0;

        public double getX() {
            return XYCurve.this.data.get(this.pos);
        }

        public double getY() {
            return XYCurve.this.data.get(this.pos + 1);
        }

        public void advance() {
            this.pos += 2;
        }

        public boolean valid() {
            return this.pos < XYCurve.this.data.size();
        }
    }
}

