/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.linearalgebra;

import de.lmu.ifi.dbs.elki.math.linearalgebra.VMath;
import java.util.Arrays;
import net.jafama.DoubleWrapper;
import net.jafama.FastMath;

public class AffineTransformation {
    private final int dim;
    private double[][] trans;
    private double[][] inv;

    public AffineTransformation(int dim) {
        this.dim = dim;
        this.trans = VMath.unitMatrix(dim + 1);
    }

    public AffineTransformation(int dim, double[][] trans, double[][] inv) {
        this.dim = dim;
        this.trans = trans;
        this.inv = inv;
    }

    public static AffineTransformation reorderAxesTransformation(int dim, int ... axes) {
        double[][] m = VMath.zeroMatrix(dim + 1);
        for (int i = 0; i < axes.length; ++i) {
            assert (0 < axes[i] && axes[i] <= dim);
            m[i][axes[i] - 1] = 1.0;
        }
        int useddim = 1;
        for (int i = axes.length; i < dim + 1; ++i) {
            boolean search = true;
            block2: while (search) {
                search = false;
                for (int a : axes) {
                    if (a != useddim) continue;
                    search = true;
                    ++useddim;
                    continue block2;
                }
            }
            m[i][useddim - 1] = 1.0;
            ++useddim;
        }
        assert (useddim - 2 == dim);
        return new AffineTransformation(dim, m, null);
    }

    public int getDimensionality() {
        return this.dim;
    }

    public void addTranslation(double[] v) {
        assert (v.length == this.dim);
        this.inv = null;
        double[][] homTrans = VMath.unitMatrix(this.dim + 1);
        for (int i = 0; i < this.dim; ++i) {
            homTrans[i][this.dim] = v[i];
        }
        this.trans = VMath.times(homTrans, this.trans);
    }

    public void addMatrix(double[][] m) {
        assert (m.length == this.dim);
        assert (m[0].length == this.dim);
        this.inv = null;
        double[][] ht = new double[this.dim + 1][this.dim + 1];
        for (int i = 0; i < this.dim; ++i) {
            for (int j = 0; j < this.dim; ++j) {
                ht[i][j] = m[i][j];
            }
        }
        ht[this.dim][this.dim] = 1.0;
        this.trans = VMath.times(ht, this.trans);
    }

    public void addRotation(int axis1, int axis2, double angle) {
        double c;
        assert (axis1 >= 0);
        assert (axis1 < this.dim);
        assert (axis1 >= 0);
        assert (axis2 < this.dim);
        assert (axis1 != axis2);
        this.inv = null;
        double[][] ht = new double[this.dim + 1][this.dim + 1];
        for (int i = 0; i < this.dim + 1; ++i) {
            ht[i][i] = 1.0;
        }
        DoubleWrapper tmp = new DoubleWrapper();
        double s = FastMath.sinAndCos(angle, tmp);
        ht[axis1][axis1] = c = tmp.value;
        ht[axis1][axis2] = -s;
        ht[axis2][axis1] = s;
        ht[axis2][axis2] = c;
        this.trans = VMath.times(ht, this.trans);
    }

    public void addAxisReflection(int axis) {
        assert (0 < axis && axis <= this.dim);
        this.inv = null;
        for (int i = 0; i <= this.dim; ++i) {
            this.trans[axis - 1][i] = -this.trans[axis - 1][i];
        }
    }

    public void addScaling(double scale) {
        this.inv = null;
        for (int i = 0; i < this.dim; ++i) {
            for (int j = 0; j <= this.dim; ++j) {
                this.trans[i][j] = this.trans[i][j] * scale;
            }
        }
    }

    public double[][] getTransformation() {
        return this.trans;
    }

    public double[][] getInverse() {
        if (this.inv == null) {
            this.updateInverse();
        }
        return this.inv;
    }

    private void updateInverse() {
        this.inv = VMath.inverse(this.trans);
    }

    public double[] homogeneVector(double[] v) {
        assert (v.length == this.dim);
        double[] dv = Arrays.copyOf(v, this.dim + 1);
        dv[this.dim] = 1.0;
        return dv;
    }

    public double[] homogeneRelativeVector(double[] v) {
        assert (v.length == this.dim);
        double[] dv = Arrays.copyOf(v, this.dim + 1);
        dv[this.dim] = 0.0;
        return dv;
    }

    public double[] unhomogeneVector(double[] v) {
        assert (v.length == this.dim + 1);
        double[] dv = new double[this.dim];
        double scale = v[this.dim];
        assert (Math.abs(scale) > 0.0);
        for (int i = 0; i < this.dim; ++i) {
            dv[i] = v[i] / scale;
        }
        return dv;
    }

    public double[] unhomogeneRelativeVector(double[] v) {
        assert (v.length == this.dim + 1);
        double[] dv = new double[this.dim];
        System.arraycopy(v, 0, dv, 0, this.dim);
        assert (Math.abs(v[this.dim]) < Double.MIN_NORMAL);
        return dv;
    }

    public double[] apply(double[] v) {
        return this.unhomogeneVector(VMath.times(this.trans, this.homogeneVector(v)));
    }

    public double[] applyInverse(double[] v) {
        if (this.inv == null) {
            this.updateInverse();
        }
        return this.unhomogeneVector(VMath.times(this.inv, this.homogeneVector(v)));
    }

    public double[] applyRelative(double[] v) {
        return this.unhomogeneRelativeVector(VMath.times(this.trans, this.homogeneRelativeVector(v)));
    }

    public double[] applyRelativeInverse(double[] v) {
        if (this.inv == null) {
            this.updateInverse();
        }
        return this.unhomogeneRelativeVector(VMath.times(this.inv, this.homogeneRelativeVector(v)));
    }
}

