/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.linearalgebra;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;

public class Centroid
implements NumberVector {
    protected double wsum;
    protected double[] elements;

    public Centroid(int dim) {
        this.elements = new double[dim];
        this.wsum = 0.0;
    }

    public void put(double[] val) {
        assert (val.length == this.elements.length);
        this.wsum += 1.0;
        int i = 0;
        while (i < this.elements.length) {
            double delta = val[i] - this.elements[i];
            int n = i++;
            this.elements[n] = this.elements[n] + delta / this.wsum;
        }
    }

    public void put(double[] val, double weight) {
        assert (val.length == this.elements.length);
        if (weight == 0.0) {
            return;
        }
        double nwsum = weight + this.wsum;
        int i = 0;
        while (i < this.elements.length) {
            double delta = val[i] - this.elements[i];
            double rval = delta * weight / nwsum;
            int n = i++;
            this.elements[n] = this.elements[n] + rval;
        }
        this.wsum = nwsum;
    }

    public void put(NumberVector val) {
        assert (val.getDimensionality() == this.elements.length);
        this.wsum += 1.0;
        int i = 0;
        while (i < this.elements.length) {
            double delta = val.doubleValue(i) - this.elements[i];
            int n = i++;
            this.elements[n] = this.elements[n] + delta / this.wsum;
        }
    }

    public void put(NumberVector val, double weight) {
        assert (val.getDimensionality() == this.elements.length);
        if (weight == 0.0) {
            return;
        }
        double nwsum = weight + this.wsum;
        int i = 0;
        while (i < this.elements.length) {
            double delta = val.doubleValue(i) - this.elements[i];
            double rval = delta * weight / nwsum;
            int n = i++;
            this.elements[n] = this.elements[n] + rval;
        }
        this.wsum = nwsum;
    }

    @Override
    public double doubleValue(int dimension) {
        return this.elements[dimension];
    }

    @Override
    public long longValue(int dimension) {
        return (long)this.elements[dimension];
    }

    @Override
    public int getDimensionality() {
        return this.elements.length;
    }

    @Override
    public double[] toArray() {
        return (double[])this.elements.clone();
    }

    public static Centroid make(Relation<? extends NumberVector> relation, DBIDs ids) {
        int dim = RelationUtil.dimensionality(relation);
        Centroid c = new Centroid(dim);
        double[] elems = c.elements;
        int count = 0;
        DBIDIter iter = ids.iter();
        while (iter.valid()) {
            NumberVector v = relation.get(iter);
            for (int i = 0; i < dim; ++i) {
                int n = i;
                elems[n] = elems[n] + v.doubleValue(i);
            }
            ++count;
            iter.advance();
        }
        if (count == 0) {
            return c;
        }
        int i = 0;
        while (i < dim) {
            int n = i++;
            elems[n] = elems[n] / (double)count;
        }
        c.wsum = count;
        return c;
    }

    public double[] getArrayRef() {
        return this.elements;
    }
}

