/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.linearalgebra;

import de.lmu.ifi.dbs.elki.math.linearalgebra.VMath;
import java.util.Arrays;
import net.jafama.FastMath;

public class CholeskyDecomposition {
    private double[][] L;
    private boolean isspd;

    public CholeskyDecomposition(double[][] A) {
        int n = A.length;
        this.L = new double[n][n];
        this.isspd = A[0].length == n;
        double d = A[0][0];
        this.isspd &= d > 0.0;
        this.L[0][0] = d > 0.0 ? FastMath.sqrt(d) : 0.0;
        Arrays.fill(this.L[0], 1, n, 0.0);
        for (int j = 1; j < n; ++j) {
            double[] Lj = this.L[j];
            double[] Aj = A[j];
            double d2 = 0.0;
            for (int k = 0; k < j; ++k) {
                double[] Lk = this.L[k];
                double s = 0.0;
                for (int i = 0; i < k; ++i) {
                    s += Lk[i] * Lj[i];
                }
                Lj[k] = s = (Aj[k] - s) / Lk[k];
                d2 += s * s;
                this.isspd &= A[k][j] == Aj[k];
            }
            this.isspd &= (d2 = Aj[j] - d2) > 0.0;
            Lj[j] = d2 > 0.0 ? FastMath.sqrt(d2) : 0.0;
            Arrays.fill(Lj, j + 1, n, 0.0);
        }
    }

    public boolean isSPD() {
        return this.isspd;
    }

    public double[][] getL() {
        return this.L;
    }

    public double[][] solve(double[][] B) {
        if (B.length != this.L.length) {
            throw new IllegalArgumentException("Matrix dimensions do not agree.");
        }
        if (!this.isspd) {
            throw new ArithmeticException("Matrix is not symmetric positive definite.");
        }
        return this.solveLtransposed(this.solveL(VMath.copy(B)));
    }

    private double[][] solveL(double[][] X) {
        int n = this.L.length;
        int m = X[0].length;
        double[] X0 = X[0];
        double[] L0 = this.L[0];
        int j = 0;
        while (j < m) {
            int n2 = j++;
            X0[n2] = X0[n2] / L0[0];
        }
        for (int k = 1; k < n; ++k) {
            double[] Xk = X[k];
            double[] Lk = this.L[k];
            double iLkk = 1.0 / Lk[k];
            for (int j2 = 0; j2 < m; ++j2) {
                double Xkj = Xk[j2];
                for (int i = 0; i < k; ++i) {
                    Xkj -= X[i][j2] * Lk[i];
                }
                Xk[j2] = Xkj * iLkk;
            }
        }
        return X;
    }

    private double[][] solveLtransposed(double[][] X) {
        for (int k = this.L.length - 1; k >= 0; --k) {
            double[] Lk = this.L[k];
            double[] Xk = X[k];
            VMath.timesEquals(Xk, 1.0 / Lk[k]);
            for (int i = 0; i < k; ++i) {
                VMath.minusTimesEquals(X[i], Xk, Lk[i]);
            }
        }
        return X;
    }

    public double[] solve(double[] b) {
        if (b.length != this.L.length) {
            throw new IllegalArgumentException("Matrix dimensions do not agree.");
        }
        if (!this.isspd) {
            throw new ArithmeticException("Matrix is not symmetric positive definite.");
        }
        return this.solveLtransposed(this.solveLInplace(VMath.copy(b)));
    }

    public double[] solveLInplace(double[] X) {
        int n = this.L.length;
        X[0] = X[0] / this.L[0][0];
        for (int k = 1; k < n; ++k) {
            double[] Lk = this.L[k];
            for (int i = 0; i < k; ++i) {
                int n2 = k;
                X[n2] = X[n2] - X[i] * Lk[i];
            }
            int n3 = k;
            X[n3] = X[n3] / Lk[k];
        }
        return X;
    }

    private double[] solveLtransposed(double[] X) {
        for (int k = this.L.length - 1; k >= 0; --k) {
            double[] Lk = this.L[k];
            int n = k;
            X[n] = X[n] / Lk[k];
            for (int i = 0; i < k; ++i) {
                int n2 = i;
                X[n2] = X[n2] - X[k] * Lk[i];
            }
        }
        return X;
    }
}

