/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.linearalgebra;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.math.linearalgebra.VMath;
import java.util.Arrays;

public class CovarianceMatrix {
    public static final String ERR_TOO_LITTLE_WEIGHT = "Too few elements (too little total weight) used to obtain a valid covariance matrix.";
    double[] mean;
    double[][] elements;
    double[] nmea;
    protected double wsum;

    public CovarianceMatrix(int dim) {
        this.mean = new double[dim];
        this.nmea = new double[dim];
        this.elements = new double[dim][dim];
        this.wsum = 0.0;
    }

    public int getDimensionality() {
        return this.mean.length;
    }

    public void put(double[] val) {
        int i;
        assert (val.length == this.mean.length);
        double nwsum = this.wsum + 1.0;
        for (i = 0; i < this.mean.length; ++i) {
            double delta = val[i] - this.mean[i];
            this.nmea[i] = this.mean[i] + delta / nwsum;
        }
        for (i = 0; i < this.mean.length; ++i) {
            for (int j = i; j < this.mean.length; ++j) {
                double delta = (val[i] - this.nmea[i]) * (val[j] - this.mean[j]);
                this.elements[i][j] = this.elements[i][j] + delta;
                if (i == j) continue;
                this.elements[j][i] = this.elements[j][i] + delta;
            }
        }
        this.wsum = nwsum;
        System.arraycopy(this.nmea, 0, this.mean, 0, this.nmea.length);
    }

    public void put(double[] val, double weight) {
        int i;
        assert (val.length == this.mean.length);
        double nwsum = this.wsum + weight;
        for (i = 0; i < this.mean.length; ++i) {
            double delta = val[i] - this.mean[i];
            double rval = delta * weight / nwsum;
            this.nmea[i] = this.mean[i] + rval;
        }
        for (i = 0; i < this.mean.length; ++i) {
            for (int j = i; j < this.mean.length; ++j) {
                double delta = (val[i] - this.nmea[i]) * (val[j] - this.mean[j]) * weight;
                this.elements[i][j] = this.elements[i][j] + delta;
                if (i == j) continue;
                this.elements[j][i] = this.elements[j][i] + delta;
            }
        }
        this.wsum = nwsum;
        System.arraycopy(this.nmea, 0, this.mean, 0, this.nmea.length);
    }

    public void put(NumberVector val) {
        int i;
        assert (val.getDimensionality() == this.mean.length);
        double nwsum = this.wsum + 1.0;
        for (i = 0; i < this.mean.length; ++i) {
            double delta = val.doubleValue(i) - this.mean[i];
            this.nmea[i] = this.mean[i] + delta / nwsum;
        }
        for (i = 0; i < this.mean.length; ++i) {
            for (int j = i; j < this.mean.length; ++j) {
                double delta = (val.doubleValue(i) - this.nmea[i]) * (val.doubleValue(j) - this.mean[j]);
                this.elements[i][j] = this.elements[i][j] + delta;
                if (i == j) continue;
                this.elements[j][i] = this.elements[j][i] + delta;
            }
        }
        this.wsum = nwsum;
        System.arraycopy(this.nmea, 0, this.mean, 0, this.nmea.length);
    }

    public void put(NumberVector val, double weight) {
        int i;
        assert (val.getDimensionality() == this.mean.length);
        double nwsum = this.wsum + weight;
        for (i = 0; i < this.mean.length; ++i) {
            double delta = val.doubleValue(i) - this.mean[i];
            double rval = delta * weight / nwsum;
            this.nmea[i] = this.mean[i] + rval;
        }
        for (i = 0; i < this.mean.length; ++i) {
            for (int j = i; j < this.mean.length; ++j) {
                double delta = (val.doubleValue(i) - this.nmea[i]) * (val.doubleValue(j) - this.mean[j]) * weight;
                this.elements[i][j] = this.elements[i][j] + delta;
                if (i == j) continue;
                this.elements[j][i] = this.elements[j][i] + delta;
            }
        }
        this.wsum = nwsum;
        System.arraycopy(this.nmea, 0, this.mean, 0, this.nmea.length);
    }

    public double getWeight() {
        return this.wsum;
    }

    public double[] getMeanVector() {
        return this.mean;
    }

    public <F extends NumberVector> F getMeanVector(Relation<? extends F> relation) {
        return RelationUtil.getNumberVectorFactory(relation).newNumberVector(this.mean);
    }

    public double[][] makeSampleMatrix() {
        if (this.wsum <= 1.0) {
            throw new IllegalStateException(ERR_TOO_LITTLE_WEIGHT);
        }
        return VMath.times(this.elements, 1.0 / (this.wsum - 1.0));
    }

    public double[][] makePopulationMatrix() {
        if (this.wsum <= 0.0) {
            throw new IllegalStateException(ERR_TOO_LITTLE_WEIGHT);
        }
        return VMath.times(this.elements, 1.0 / this.wsum);
    }

    public double[][] destroyToSampleMatrix() {
        if (this.wsum <= 1.0) {
            throw new IllegalStateException(ERR_TOO_LITTLE_WEIGHT);
        }
        return VMath.timesEquals(this.elements, 1.0 / (this.wsum - 1.0));
    }

    public double[][] destroyToPopulationMatrix() {
        if (this.wsum <= 0.0) {
            throw new IllegalStateException(ERR_TOO_LITTLE_WEIGHT);
        }
        return VMath.timesEquals(this.elements, 1.0 / this.wsum);
    }

    public void reset() {
        Arrays.fill(this.mean, 0.0);
        Arrays.fill(this.nmea, 0.0);
        if (this.elements != null) {
            for (int i = 0; i < this.elements.length; ++i) {
                Arrays.fill(this.elements[i], 0.0);
            }
        } else {
            this.elements = new double[this.mean.length][this.mean.length];
        }
        this.wsum = 0.0;
    }

    public static CovarianceMatrix make(Relation<? extends NumberVector> relation) {
        int dim = RelationUtil.dimensionality(relation);
        CovarianceMatrix c = new CovarianceMatrix(dim);
        double[] mean = c.mean;
        int count = 0;
        DBIDIter iditer = relation.iterDBIDs();
        while (iditer.valid()) {
            NumberVector vec = relation.get(iditer);
            for (int i = 0; i < dim; ++i) {
                int n = i;
                mean[n] = mean[n] + vec.doubleValue(i);
            }
            ++count;
            iditer.advance();
        }
        if (count == 0) {
            return c;
        }
        int i = 0;
        while (i < dim) {
            int n = i++;
            mean[n] = mean[n] / (double)count;
        }
        double[] tmp = c.nmea;
        double[][] elems = c.elements;
        DBIDIter iditer2 = relation.iterDBIDs();
        while (iditer2.valid()) {
            int i2;
            NumberVector vec = relation.get(iditer2);
            for (i2 = 0; i2 < dim; ++i2) {
                tmp[i2] = vec.doubleValue(i2) - mean[i2];
            }
            for (i2 = 0; i2 < dim; ++i2) {
                for (int j = i2; j < dim; ++j) {
                    double[] dArray = elems[i2];
                    int n = j;
                    dArray[n] = dArray[n] + tmp[i2] * tmp[j];
                }
            }
            iditer2.advance();
        }
        for (int i3 = 0; i3 < dim; ++i3) {
            for (int j = i3 + 1; j < dim; ++j) {
                elems[j][i3] = elems[i3][j];
            }
        }
        c.wsum = count;
        return c;
    }

    public static CovarianceMatrix make(Relation<? extends NumberVector> relation, DBIDs ids) {
        int dim = RelationUtil.dimensionality(relation);
        CovarianceMatrix c = new CovarianceMatrix(dim);
        double[] mean = c.mean;
        int count = 0;
        DBIDIter iditer = ids.iter();
        while (iditer.valid()) {
            NumberVector vec = relation.get(iditer);
            for (int i = 0; i < dim; ++i) {
                int n = i;
                mean[n] = mean[n] + vec.doubleValue(i);
            }
            ++count;
            iditer.advance();
        }
        if (count == 0) {
            return c;
        }
        int i = 0;
        while (i < dim) {
            int n = i++;
            mean[n] = mean[n] / (double)count;
        }
        double[] tmp = c.nmea;
        double[][] elems = c.elements;
        DBIDIter iditer2 = ids.iter();
        while (iditer2.valid()) {
            int i2;
            NumberVector vec = relation.get(iditer2);
            for (i2 = 0; i2 < dim; ++i2) {
                tmp[i2] = vec.doubleValue(i2) - mean[i2];
            }
            for (i2 = 0; i2 < dim; ++i2) {
                for (int j = i2; j < dim; ++j) {
                    double[] dArray = elems[i2];
                    int n = j;
                    dArray[n] = dArray[n] + tmp[i2] * tmp[j];
                }
            }
            iditer2.advance();
        }
        for (int i3 = 0; i3 < dim; ++i3) {
            for (int j = i3 + 1; j < dim; ++j) {
                elems[j][i3] = elems[i3][j];
            }
        }
        c.wsum = count;
        return c;
    }
}

