/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.linearalgebra;

import de.lmu.ifi.dbs.elki.math.linearalgebra.VMath;
import java.util.Arrays;
import net.jafama.FastMath;

public class EigenvalueDecomposition {
    private final int n;
    private double[] d;
    private double[] e;
    private double[][] V;
    private double[][] H;
    private double[] ort;

    public EigenvalueDecomposition(double[][] A) {
        this.n = A.length;
        this.d = new double[this.n];
        this.e = new double[this.n];
        boolean issymmetric = true;
        for (int j = 0; j < this.n && issymmetric; ++j) {
            for (int i = 0; i < this.n && issymmetric; ++i) {
                boolean bl = issymmetric = A[i][j] == A[j][i];
                if (Double.isNaN(A[i][j])) {
                    throw new IllegalArgumentException("NaN in EigenvalueDecomposition!");
                }
                if (!Double.isInfinite(A[i][j])) continue;
                throw new IllegalArgumentException("+-inf in EigenvalueDecomposition!");
            }
        }
        if (issymmetric) {
            this.V = VMath.copy(A);
            this.tred2();
            this.tql2();
        } else {
            this.V = new double[this.n][this.n];
            this.H = VMath.copy(A);
            this.ort = new double[this.n];
            this.orthes();
            this.hqr2();
        }
        this.sortEigen();
    }

    private void tred2() {
        System.arraycopy(this.V[this.n - 1], 0, this.d, 0, this.n);
        for (int i = this.n - 1; i > 0; --i) {
            int j;
            double[] V_i = this.V[i];
            double[] V_im1 = this.V[i - 1];
            double scale = 0.0;
            for (int k = 0; k < i; ++k) {
                scale += Math.abs(this.d[k]);
            }
            if (scale < Double.MIN_NORMAL) {
                this.e[i] = this.d[i - 1];
                for (int j2 = 0; j2 < i; ++j2) {
                    this.d[j2] = V_im1[j2];
                    this.V[j2][i] = 0.0;
                    V_i[j2] = 0.0;
                }
                this.d[i] = 0.0;
                continue;
            }
            double h = 0.0;
            int k = 0;
            while (k < i) {
                int n = k++;
                double d = this.d[n] / scale;
                this.d[n] = d;
                double dk = d;
                h += dk * dk;
            }
            double f = this.d[i - 1];
            double g = FastMath.sqrt(h);
            g = f > 0.0 ? -g : g;
            this.e[i] = scale * g;
            h -= f * g;
            this.d[i - 1] = f - g;
            Arrays.fill(this.e, 0, i, 0.0);
            for (int j3 = 0; j3 < i; ++j3) {
                double[] Vj = this.V[j3];
                double dj = Vj[i] = this.d[j3];
                double ej = this.e[j3] + Vj[j3] * dj;
                int k2 = j3 + 1;
                while (k2 <= i - 1) {
                    double Vkj = this.V[k2][j3];
                    ej += Vkj * this.d[k2];
                    int n = k2++;
                    this.e[n] = this.e[n] + Vkj * dj;
                }
                this.e[j3] = ej;
            }
            double sum = 0.0;
            for (int j4 = 0; j4 < i; ++j4) {
                int n = j4;
                double d = this.e[n] / h;
                this.e[n] = d;
                sum += d * this.d[j4];
            }
            double hh = sum / (h + h);
            for (j = 0; j < i; ++j) {
                int n = j;
                this.e[n] = this.e[n] - hh * this.d[j];
            }
            for (j = 0; j < i; ++j) {
                double dj = this.d[j];
                double ej = this.e[j];
                for (int k3 = j; k3 <= i - 1; ++k3) {
                    double[] dArray = this.V[k3];
                    int n = j;
                    dArray[n] = dArray[n] - (dj * this.e[k3] + ej * this.d[k3]);
                }
                this.d[j] = V_im1[j];
                V_i[j] = 0.0;
            }
            this.d[i] = h;
        }
        this.tred2AccumulateTransformations();
        System.arraycopy(this.V[this.n - 1], 0, this.d, 0, this.n);
        Arrays.fill(this.V[this.n - 1], 0.0);
        this.V[this.n - 1][this.n - 1] = 1.0;
        this.e[0] = 0.0;
    }

    private void tred2AccumulateTransformations() {
        for (int i = 0; i < this.n - 1; ++i) {
            int k;
            double[] Vi = this.V[i];
            this.V[this.n - 1][i] = Vi[i];
            Vi[i] = 1.0;
            double h = this.d[i + 1];
            if (h > 0.0 || h < 0.0) {
                for (k = 0; k <= i; ++k) {
                    this.d[k] = this.V[k][i + 1] / h;
                }
                for (int j = 0; j <= i; ++j) {
                    int k2;
                    double g = 0.0;
                    for (k2 = 0; k2 <= i; ++k2) {
                        double[] Vk = this.V[k2];
                        g += Vk[i + 1] * Vk[j];
                    }
                    for (k2 = 0; k2 <= i; ++k2) {
                        double[] dArray = this.V[k2];
                        int n = j;
                        dArray[n] = dArray[n] - g * this.d[k2];
                    }
                }
            }
            for (k = 0; k <= i; ++k) {
                this.V[k][i + 1] = 0.0;
            }
        }
    }

    private void tql2() {
        System.arraycopy(this.e, 1, this.e, 0, this.n - 1);
        this.e[this.n - 1] = 0.0;
        double f = 0.0;
        double tst1 = 0.0;
        for (int l = 0; l < this.n; ++l) {
            int m;
            tst1 = Math.max(tst1, Math.abs(this.d[l]) + Math.abs(this.e[l]));
            for (m = l; m < this.n && !(Math.abs(this.e[m]) <= 2.220446049250313E-16 * tst1); ++m) {
            }
            if (m > l) {
                do {
                    f += this.tql2ComputeImplicitShift(l);
                    this.tql2ImplicitQL(l, m, this.d[l + 1]);
                } while (Math.abs(this.e[l]) > 2.220446049250313E-16 * tst1);
            }
            int n = l;
            this.d[n] = this.d[n] + f;
            this.e[l] = 0.0;
        }
    }

    private double tql2ComputeImplicitShift(int l) {
        double el = this.e[l];
        double g = this.d[l];
        double p = (this.d[l + 1] - g) / (2.0 * el);
        double r = FastMath.sqrt(p * p + 1.0);
        double pr = p >= 0.0 ? p + r : p - r;
        double dl = this.d[l] = el / pr;
        this.d[l + 1] = el * pr;
        double h = g - dl;
        int i = l + 2;
        while (i < this.n) {
            int n = i++;
            this.d[n] = this.d[n] - h;
        }
        return h;
    }

    private void tql2ImplicitQL(int l, int m, double dl1) {
        double p = this.d[m];
        double c = 1.0;
        double c2 = 1.0;
        double c3 = 1.0;
        double s = 0.0;
        double s2 = 0.0;
        double el1 = this.e[l + 1];
        for (int i = m - 1; i >= l; --i) {
            c3 = c2;
            c2 = c;
            s2 = s;
            double di = this.d[i];
            double ei = this.e[i];
            double g = c * ei;
            double h = c * p;
            double r = FastMath.hypot(p, ei);
            this.e[i + 1] = s * r;
            s = ei / r;
            c = p / r;
            p = c * di - s * g;
            this.d[i + 1] = h + s * (c * g + s * di);
            for (int k = 0; k < this.n; ++k) {
                double[] Vk = this.V[k];
                h = Vk[i + 1];
                Vk[i + 1] = s * Vk[i] + c * h;
                Vk[i] = c * Vk[i] - s * h;
            }
        }
        p = -s * s2 * c3 * el1 * this.e[l] / dl1;
        this.e[l] = s * p;
        this.d[l] = c * p;
    }

    private void sortEigen() {
        for (int i = 0; i < this.n - 1; ++i) {
            int k = i;
            double p = Math.abs(this.d[i]);
            for (int j = i + 1; j < this.n; ++j) {
                double d_j = Math.abs(this.d[j]);
                if (!(d_j > p)) continue;
                k = j;
                p = d_j;
            }
            if (k == i) continue;
            double tmp = this.d[k];
            this.d[k] = this.d[i];
            this.d[i] = tmp;
            for (int j = 0; j < this.n; ++j) {
                double[] Vj = this.V[j];
                double swap = Vj[i];
                Vj[i] = Vj[k];
                Vj[k] = swap;
            }
        }
    }

    private void orthes() {
        double g;
        int m;
        boolean low = false;
        int high = this.n - 1;
        for (m = 1; m <= high - 1; ++m) {
            double scale = 0.0;
            for (int i = m; i <= high; ++i) {
                scale += Math.abs(this.H[i][m - 1]);
            }
            if (!(scale > 0.0) && !(scale < 0.0)) continue;
            double h = 0.0;
            for (int i = high; i >= m; --i) {
                double oi = this.ort[i] = this.H[i][m - 1] / scale;
                h += oi * oi;
            }
            g = FastMath.sqrt(h);
            double om = this.ort[m];
            g = om > 0.0 ? -g : g;
            h -= om * g;
            this.ort[m] = om - g;
            for (int j = m; j < this.n; ++j) {
                int i;
                double f = 0.0;
                for (i = high; i >= m; --i) {
                    f += this.ort[i] * this.H[i][j];
                }
                f /= h;
                for (i = m; i <= high; ++i) {
                    double[] dArray = this.H[i];
                    int n = j;
                    dArray[n] = dArray[n] - f * this.ort[i];
                }
            }
            for (int i = 0; i <= high; ++i) {
                int j;
                double[] Hi = this.H[i];
                double f = 0.0;
                for (j = high; j >= m; --j) {
                    f += this.ort[j] * Hi[j];
                }
                f /= h;
                for (j = m; j <= high; ++j) {
                    int n = j;
                    Hi[n] = Hi[n] - f * this.ort[j];
                }
            }
            int n = m;
            this.ort[n] = this.ort[n] * scale;
            this.H[m][m - 1] = scale * g;
        }
        for (int i = 0; i < this.n; ++i) {
            Arrays.fill(this.V[i], 0.0);
            this.V[i][i] = 1.0;
        }
        for (m = high - 1; m >= 1; --m) {
            double[] H_m = this.H[m];
            if (H_m[m - 1] == 0.0) continue;
            for (int i = m + 1; i <= high; ++i) {
                this.ort[i] = this.H[i][m - 1];
            }
            double ort_m = this.ort[m];
            for (int j = m; j <= high; ++j) {
                int i;
                g = 0.0;
                for (i = m; i <= high; ++i) {
                    g += this.ort[i] * this.V[i][j];
                }
                g = g / ort_m / H_m[m - 1];
                for (i = m; i <= high; ++i) {
                    double[] dArray = this.V[i];
                    int n = j;
                    dArray[n] = dArray[n] + g * this.ort[i];
                }
            }
        }
    }

    private static void cdiv(double xr, double xi, double yr, double yi, double[] buf, int off) {
        if (Math.abs(yr) > Math.abs(yi)) {
            double r = yi / yr;
            double d = yr + r * yi;
            buf[off] = (xr + r * xi) / d;
            buf[off + 1] = (xi - r * xr) / d;
        } else {
            double r = yr / yi;
            double d = yi + r * yr;
            buf[off] = (r * xr + xi) / d;
            buf[off + 1] = (r * xi - xr) / d;
        }
    }

    private void hqr2() {
        int nn = this.n;
        boolean low = false;
        int high = nn - 1;
        double norm = 0.0;
        for (int i = 0; i < nn; ++i) {
            int j;
            int n = j = i > 0 ? i - 1 : 0;
            while (j < nn) {
                norm += Math.abs(this.H[i][j]);
                ++j;
            }
        }
        double exshift = 0.0;
        int iter = 0;
        int n = nn - 1;
        while (n >= 0) {
            int m;
            double s;
            int l;
            for (l = n; l > 0; --l) {
                double s2 = Math.abs(this.H[l - 1][l - 1]) + Math.abs(this.H[l][l]);
                if (Math.abs(this.H[l][l - 1]) < 2.220446049250313E-16 * (s2 == 0.0 ? norm : s2)) break;
            }
            if (l == n) {
                double[] dArray = this.H[n];
                int n2 = n;
                double d = dArray[n2] + exshift;
                dArray[n2] = d;
                this.d[n] = d;
                this.e[n] = 0.0;
                --n;
                iter = 0;
                continue;
            }
            double[] Hn = this.H[n];
            double[] Hnm1 = this.H[n - 1];
            if (l == n - 1) {
                double w = Hn[n - 1] * Hnm1[n];
                double p = (Hnm1[n - 1] - Hn[n]) * 0.5;
                double q = p * p + w;
                int n3 = n;
                double d = Hn[n3] + exshift;
                Hn[n3] = d;
                double x = d;
                double z = FastMath.sqrt(Math.abs(q));
                int n4 = n - 1;
                Hnm1[n4] = Hnm1[n4] + exshift;
                if (q >= 0.0) {
                    int i;
                    z = p >= 0.0 ? p + z : p - z;
                    this.d[n - 1] = x + z;
                    this.d[n] = z != 0.0 ? x - w / z : this.d[n - 1];
                    this.e[n - 1] = 0.0;
                    this.e[n] = 0.0;
                    x = Hn[n - 1];
                    double s3 = Math.abs(x) + Math.abs(z);
                    p = x / s3;
                    q = z / s3;
                    double r = FastMath.hypot(p, q);
                    p /= r;
                    q /= r;
                    for (int j = n - 1; j < nn; ++j) {
                        double tmp = Hnm1[j];
                        Hnm1[j] = q * tmp + p * Hn[j];
                        Hn[j] = q * Hn[j] - p * tmp;
                    }
                    for (i = 0; i <= n; ++i) {
                        EigenvalueDecomposition.modifyQP(this.H[i], n, p, q);
                    }
                    for (i = 0; i <= high; ++i) {
                        EigenvalueDecomposition.modifyQP(this.V[i], n, p, q);
                    }
                } else {
                    double d2 = x + p;
                    this.d[n - 1] = d2;
                    this.d[n] = d2;
                    double d3 = z;
                    this.e[n - 1] = d3;
                    this.e[n] = -d3;
                }
                n -= 2;
                iter = 0;
                continue;
            }
            double x = Hn[n];
            double y = 0.0;
            double w = 0.0;
            y = Hnm1[n - 1];
            w = Hn[n - 1] * Hnm1[n];
            if (iter == 10) {
                exshift += x;
                int i = 0;
                while (i <= n) {
                    double[] dArray = this.H[i];
                    int n5 = i++;
                    dArray[n5] = dArray[n5] - x;
                }
                s = Math.abs(Hn[n - 1]) + Math.abs(Hnm1[n - 2]);
                x = y = 0.75 * s;
                w = -0.4375 * s * s;
            }
            if (iter == 30) {
                s = (y - x) * 0.5;
                if ((s = s * s + w) > 0.0) {
                    s = FastMath.sqrt(s);
                    s = y < x ? -s : s;
                    s = x - w / ((y - x) * 0.5 + s);
                    int i = 0;
                    while (i <= n) {
                        double[] dArray = this.H[i];
                        int n6 = i++;
                        dArray[n6] = dArray[n6] - s;
                    }
                    exshift += s;
                    w = 0.964;
                    y = 0.964;
                    x = 0.964;
                }
            }
            ++iter;
            double p = 0.0;
            double q = 0.0;
            double r = 0.0;
            for (m = n - 2; m >= l; --m) {
                double[] Hm = this.H[m];
                double[] Hmp1 = this.H[m + 1];
                double z = Hm[m];
                double xz = x - z;
                p = (xz * (y - z) - w) / Hmp1[m] + Hm[m + 1];
                q = Hmp1[m + 1] - xz - y;
                r = this.H[m + 2][m + 1];
                double tmp = Math.abs(p) + Math.abs(q) + Math.abs(r);
                if (m == l || Math.abs(Hm[m - 1]) * (Math.abs(q /= tmp) + Math.abs(r /= tmp)) < 2.220446049250313E-16 * (Math.abs(p /= tmp) * (Math.abs(this.H[m - 1][m - 1]) + Math.abs(z) + Math.abs(Hmp1[m + 1])))) break;
            }
            for (int i = m + 2; i <= n; ++i) {
                double[] Hi = this.H[i];
                Hi[i - 2] = 0.0;
                if (i <= m + 2) continue;
                Hi[i - 3] = 0.0;
            }
            int last = n - 1;
            for (int k = m; k <= last; ++k) {
                int i;
                double[] Hkp2;
                boolean notlast = k != last;
                double[] Hk = this.H[k];
                double[] Hkp1 = this.H[k + 1];
                double[] dArray = Hkp2 = notlast ? this.H[k + 2] : null;
                if (k != m) {
                    p = Hk[k - 1];
                    q = Hkp1[k - 1];
                    r = notlast ? Hkp2[k - 1] : 0.0;
                    x = Math.abs(p) + Math.abs(q) + Math.abs(r);
                    if (x == 0.0) continue;
                    p /= x;
                    q /= x;
                    r /= x;
                }
                double s4 = FastMath.hypot(p, q, r);
                double d = s4 = p < 0.0 ? -s4 : s4;
                if (s4 == 0.0) continue;
                if (k != m) {
                    Hk[k - 1] = -s4 * x;
                } else if (l != m) {
                    Hk[k - 1] = -Hk[k - 1];
                }
                x = (p += s4) / s4;
                y = q / s4;
                double z = r / s4;
                q /= p;
                r /= p;
                int j = k;
                while (j < nn) {
                    double tmp = Hk[j] + q * Hkp1[j];
                    if (notlast) {
                        int n7 = j;
                        Hkp2[n7] = Hkp2[n7] - (tmp += r * Hkp2[j]) * z;
                    }
                    int n8 = j;
                    Hk[n8] = Hk[n8] - tmp * x;
                    int n9 = j++;
                    Hkp1[n9] = Hkp1[n9] - tmp * y;
                }
                for (i = 0; i <= Math.min(n, k + 3); ++i) {
                    EigenvalueDecomposition.modifyQR(this.H[i], k, notlast, q, r, x, y, z);
                }
                for (i = 0; i <= high; ++i) {
                    EigenvalueDecomposition.modifyQR(this.V[i], k, notlast, q, r, x, y, z);
                }
            }
        }
        if (norm == 0.0) {
            return;
        }
        for (int n10 = nn - 1; n10 >= 0; --n10) {
            double p = this.d[n10];
            double q = this.e[n10];
            if (q == 0.0) {
                this.hqr2BacksubstituteReal(n10, p, norm);
                continue;
            }
            if (!(q < 0.0)) continue;
            this.hqr2BacksubstituteComplex(n10, p, q, norm);
        }
        this.hqr2BackTransformation(nn, 0, high);
    }

    private static void modifyQP(double[] Hi, int n, double p, double q) {
        double tmp = Hi[n - 1];
        Hi[n - 1] = q * tmp + p * Hi[n];
        Hi[n] = q * Hi[n] - p * tmp;
    }

    private static void modifyQR(double[] Hi, int k, boolean notlast, double q, double r, double x, double y, double z) {
        double tmp = x * Hi[k] + y * Hi[k + 1];
        if (notlast) {
            int n = k + 2;
            Hi[n] = Hi[n] - (tmp += z * Hi[k + 2]) * r;
        }
        int n = k;
        Hi[n] = Hi[n] - tmp;
        int n2 = k + 1;
        Hi[n2] = Hi[n2] - tmp * q;
    }

    private void hqr2BacksubstituteReal(int n, double p, double norm) {
        this.H[n][n] = 1.0;
        double s = 0.0;
        double z = 0.0;
        int l = n;
        for (int i = n - 1; i >= 0; --i) {
            double[] Hi = this.H[i];
            double w = Hi[i] - p;
            double r = 0.0;
            for (int j = l; j <= n; ++j) {
                r += Hi[j] * this.H[j][n];
            }
            if (this.e[i] < 0.0) {
                z = w;
                s = r;
                continue;
            }
            l = i;
            if (!(this.e[i] > 0.0)) {
                Hi[n] = -r / (w > 0.0 || w < 0.0 ? w : 2.220446049250313E-16 * norm);
            } else {
                double[] Hip1 = this.H[i + 1];
                double x = Hi[i + 1];
                double y = Hip1[i];
                double dip = this.d[i] - p;
                double ei = this.e[i];
                double t = Hi[n] = (x * s - z * r) / (dip * dip + ei * ei);
                Hip1[n] = Math.abs(x) > Math.abs(z) ? (-r - w * t) / x : (-s - y * t) / z;
            }
            double t = Math.abs(Hi[n]);
            if (!(2.220446049250313E-16 * t * t > 1.0)) continue;
            for (int j = i; j <= n; ++j) {
                double[] dArray = this.H[j];
                int n2 = n;
                dArray[n2] = dArray[n2] / t;
            }
        }
    }

    private void hqr2BacksubstituteComplex(int n, double p, double q, double norm) {
        double[] Hn = this.H[n];
        double[] Hnm1 = this.H[n - 1];
        double tmp = Hn[n - 1];
        if (Math.abs(tmp) > Math.abs(Hnm1[n])) {
            Hnm1[n - 1] = q / tmp;
            Hnm1[n] = -(Hn[n] - p) / tmp;
        } else {
            EigenvalueDecomposition.cdiv(0.0, -Hnm1[n], Hnm1[n - 1] - p, q, Hnm1, n - 1);
        }
        Hn[n - 1] = 0.0;
        Hn[n] = 1.0;
        double r = 0.0;
        double s = 0.0;
        double z = 0.0;
        int l = n - 1;
        for (int i = n - 2; i >= 0; --i) {
            double[] Hj;
            double[] Hi = this.H[i];
            double[] Hip1 = this.H[i + 1];
            double w = Hi[i] - p;
            double ra = 0.0;
            double sa = 0.0;
            for (int j = l; j <= n; ++j) {
                double Hij = Hi[j];
                Hj = this.H[j];
                ra += Hij * Hj[n - 1];
                sa += Hij * Hj[n];
            }
            if (this.e[i] < 0.0) {
                z = w;
                r = ra;
                s = sa;
                continue;
            }
            l = i;
            if (!(this.e[i] > 0.0)) {
                EigenvalueDecomposition.cdiv(-ra, -sa, w, q, Hi, n - 1);
            } else {
                double x = Hi[i + 1];
                double y = Hip1[i];
                double dip = this.d[i] - p;
                double vr = dip * dip + this.e[i] * this.e[i] - q * q;
                double vi = dip * 2.0 * q;
                if (vr == 0.0 && vi == 0.0) {
                    vr = 2.220446049250313E-16 * norm * (Math.abs(w) + Math.abs(q) + Math.abs(x) + Math.abs(y) + Math.abs(z));
                }
                EigenvalueDecomposition.cdiv(x * r - z * ra + q * sa, x * s - z * sa - q * ra, vr, vi, Hi, n - 1);
                if (Math.abs(x) > Math.abs(z) + Math.abs(q)) {
                    Hip1[n - 1] = (-ra - w * Hi[n - 1] + q * Hi[n]) / x;
                    Hip1[n] = (-sa - w * Hi[n] - q * Hi[n - 1]) / x;
                } else {
                    EigenvalueDecomposition.cdiv(-r - y * Hi[n - 1], -s - y * Hi[n], z, q, Hip1, n - 1);
                }
            }
            double t = Math.max(Math.abs(Hi[n - 1]), Math.abs(Hi[n]));
            if (!(2.220446049250313E-16 * t * t > 1.0)) continue;
            for (int j = i; j <= n; ++j) {
                Hj = this.H[j];
                int n2 = n - 1;
                Hj[n2] = Hj[n2] / t;
                int n3 = n;
                Hj[n3] = Hj[n3] / t;
            }
        }
    }

    private void hqr2BackTransformation(int nn, int low, int high) {
        for (int j = nn - 1; j >= low; --j) {
            int last = j < high ? j : high;
            for (int i = low; i <= high; ++i) {
                double[] Vi = this.V[i];
                double sum = 0.0;
                for (int k = low; k <= last; ++k) {
                    sum += Vi[k] * this.H[k][j];
                }
                Vi[j] = sum;
            }
        }
    }

    public double[][] getV() {
        return this.V;
    }

    public double[] getRealEigenvalues() {
        return this.d;
    }

    public double[] getImagEigenvalues() {
        return this.e;
    }

    public double[][] getD() {
        double[][] D = new double[this.n][this.n];
        for (int i = 0; i < this.n; ++i) {
            double e_i = this.e[i];
            double[] D_i = D[i];
            D_i[i] = this.d[i];
            if (e_i > 0.0) {
                D_i[i + 1] = e_i;
                continue;
            }
            if (!(e_i < 0.0)) continue;
            D_i[i - 1] = e_i;
        }
        return D;
    }
}

