/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.linearalgebra;

import de.lmu.ifi.dbs.elki.math.linearalgebra.VMath;
import java.io.Serializable;
import java.util.Arrays;

public class LUDecomposition
implements Serializable {
    private static final long serialVersionUID = 1L;
    private double[][] LU;
    private int m;
    private int n;
    private int pivsign;
    private int[] piv;

    public LUDecomposition(double[][] LU) {
        this(LU, LU.length, LU[0].length);
    }

    public LUDecomposition(double[][] LU, int m, int n) {
        LU = VMath.copy(LU);
        this.LU = LU;
        this.m = m;
        this.n = n;
        this.piv = new int[m];
        for (int i = 0; i < m; ++i) {
            this.piv[i] = i;
        }
        this.pivsign = 1;
        double[] LUcolj = new double[m];
        for (int j = 0; j < n; ++j) {
            int i;
            for (i = 0; i < m; ++i) {
                LUcolj[i] = LU[i][j];
            }
            i = 0;
            while (i < m) {
                int kmax = Math.min(i, j);
                double s = 0.0;
                double[] LUrowi = LU[i];
                for (int k = 0; k < kmax; ++k) {
                    s += LUrowi[k] * LUcolj[k];
                }
                int n2 = i++;
                double d = LUcolj[n2] - s;
                LUcolj[n2] = d;
                LUrowi[j] = d;
            }
            int p = j;
            for (int i2 = j + 1; i2 < m; ++i2) {
                if (!(Math.abs(LUcolj[i2]) > Math.abs(LUcolj[p]))) continue;
                p = i2;
            }
            if (p != j) {
                double[] tmp = LU[j];
                LU[j] = LU[p];
                LU[p] = tmp;
                int k = this.piv[p];
                this.piv[p] = this.piv[j];
                this.piv[j] = k;
                this.pivsign = -this.pivsign;
            }
            double LUjj = LU[j][j];
            if (j >= m || LUjj == 0.0) continue;
            for (int i3 = j + 1; i3 < m; ++i3) {
                double[] dArray = LU[i3];
                int n3 = j;
                dArray[n3] = dArray[n3] / LUjj;
            }
        }
    }

    public boolean isNonsingular() {
        for (int j = 0; j < this.n; ++j) {
            if (this.LU[j][j] != 0.0) continue;
            return false;
        }
        return true;
    }

    public double[][] getL() {
        double[][] L = new double[this.m][this.n];
        L[0][0] = 1.0;
        for (int i = 1; i < this.m; ++i) {
            double[] Li = L[i];
            System.arraycopy(this.LU[i], 0, Li, 0, Math.min(i, this.n));
            if (i >= this.n) continue;
            Li[i] = 1.0;
        }
        return L;
    }

    public double[][] getU() {
        double[][] U = new double[this.n][this.n];
        for (int i = 0; i < this.n; ++i) {
            System.arraycopy(this.LU[i], i, U[i], i, this.n - i);
        }
        return U;
    }

    public int[] getPivot() {
        return (int[])this.piv.clone();
    }

    public double det() {
        if (this.m != this.n) {
            throw new IllegalArgumentException("Matrix must be square.");
        }
        double d = this.pivsign;
        for (int j = 0; j < this.n; ++j) {
            d *= this.LU[j][j];
        }
        return d;
    }

    public double[][] solve(double[][] B) {
        if (B.length != this.m) {
            throw new IllegalArgumentException("Matrix dimensions do not agree.");
        }
        double[][] sol = this.solveInplace(VMath.getMatrix(B, this.piv, 0, B[0].length));
        return this.n < sol.length ? (double[][])Arrays.copyOf(sol, this.n) : sol;
    }

    private double[][] solveInplace(double[][] B) {
        int i;
        double[] Bk;
        int k;
        int mx = B.length;
        if (mx != this.m) {
            throw new IllegalArgumentException("Matrix dimensions do not agree.");
        }
        if (!this.isNonsingular()) {
            throw new ArithmeticException("Matrix is singular.");
        }
        for (k = 0; k < this.n; ++k) {
            Bk = B[k];
            for (i = k + 1; i < this.n; ++i) {
                VMath.minusTimesEquals(B[i], Bk, this.LU[i][k]);
            }
        }
        for (k = this.n - 1; k >= 0; --k) {
            Bk = B[k];
            VMath.timesEquals(Bk, 1.0 / this.LU[k][k]);
            for (i = 0; i < k; ++i) {
                VMath.minusTimesEquals(B[i], Bk, this.LU[i][k]);
            }
        }
        return B;
    }

    public double[] solve(double[] b) {
        if (b.length != this.m) {
            throw new IllegalArgumentException("Matrix dimensions do not agree.");
        }
        if (!this.isNonsingular()) {
            throw new ArithmeticException("Matrix is singular.");
        }
        double[] bc = new double[this.piv.length];
        for (int i = 0; i < this.piv.length; ++i) {
            bc[i] = b[this.piv[i]];
        }
        this.solveInplace(bc);
        return this.n < bc.length ? Arrays.copyOf(bc, this.n) : bc;
    }

    public double[] solveInplace(double[] b) {
        int i;
        int k;
        if (b.length != this.m) {
            throw new IllegalArgumentException("Matrix dimensions do not agree.");
        }
        if (!this.isNonsingular()) {
            throw new ArithmeticException("Matrix is singular.");
        }
        for (k = 0; k < this.n; ++k) {
            for (i = k + 1; i < this.n; ++i) {
                int n = i;
                b[n] = b[n] - b[k] * this.LU[i][k];
            }
        }
        for (k = this.n - 1; k >= 0; --k) {
            int n = k;
            b[n] = b[n] / this.LU[k][k];
            for (i = 0; i < k; ++i) {
                int n2 = i;
                b[n2] = b[n2] - b[k] * this.LU[i][k];
            }
        }
        return b;
    }

    public double[][] inverse() {
        double[][] b = new double[this.piv.length][this.m];
        for (int i = 0; i < this.piv.length; ++i) {
            b[this.piv[i]][i] = 1.0;
        }
        return this.solveInplace(b);
    }
}

