/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.linearalgebra;

import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.io.FormatUtil;
import de.lmu.ifi.dbs.elki.utilities.pairs.IntIntPair;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Locale;
import net.jafama.FastMath;

public class LinearEquationSystem {
    private static final Logging LOG = Logging.getLogger(LinearEquationSystem.class);
    private static final double DELTA = 0.001;
    private static final int TRIVAL_PIVOT_SEARCH = 0;
    private static final int TOTAL_PIVOT_SEARCH = 1;
    private boolean solvable;
    private boolean solved;
    private int rank;
    private double[][] coeff;
    private double[] rhs;
    private int[] row;
    private int[] col;
    private double[] x_0;
    private double[][] u;
    private boolean reducedRowEchelonForm;

    public LinearEquationSystem(double[][] a, double[] b) {
        if (a == null) {
            throw new IllegalArgumentException("Coefficient array is null!");
        }
        if (b == null) {
            throw new IllegalArgumentException("Right hand side is null!");
        }
        if (a.length != b.length) {
            throw new IllegalArgumentException("Coefficient matrix and right hand side differ in row dimensionality!");
        }
        this.coeff = a;
        this.rhs = b;
        this.row = new int[this.coeff.length];
        for (int i = 0; i < this.coeff.length; ++i) {
            this.row[i] = i;
        }
        this.col = new int[this.coeff[0].length];
        for (int j = 0; j < this.coeff[0].length; ++j) {
            this.col[j] = j;
        }
        this.rank = 0;
        this.x_0 = null;
        this.solved = false;
        this.solvable = false;
        this.reducedRowEchelonForm = false;
    }

    public LinearEquationSystem(double[][] a, double[] b, int[] rowPermutations, int[] columnPermutations) {
        if (a == null) {
            throw new IllegalArgumentException("Coefficient array is null!");
        }
        if (b == null) {
            throw new IllegalArgumentException("Right hand side is null!");
        }
        if (a.length != b.length) {
            throw new IllegalArgumentException("Coefficient matrix and right hand side differ in row dimensionality!");
        }
        if (rowPermutations.length != a.length) {
            throw new IllegalArgumentException("Coefficient matrix and row permutation array differ in row dimensionality!");
        }
        if (columnPermutations.length != a[0].length) {
            throw new IllegalArgumentException("Coefficient matrix and column permutation array differ in column dimensionality!");
        }
        this.coeff = a;
        this.rhs = b;
        this.row = rowPermutations;
        this.col = columnPermutations;
        this.rank = 0;
        this.x_0 = null;
        this.solved = false;
        this.solvable = false;
        this.reducedRowEchelonForm = false;
    }

    public double[][] getCoefficents() {
        return (double[][])this.coeff.clone();
    }

    public double[] getRHS() {
        return (double[])this.rhs.clone();
    }

    public int[] getRowPermutations() {
        return (int[])this.row.clone();
    }

    public int[] getColumnPermutations() {
        return (int[])this.col.clone();
    }

    public boolean isSolved() {
        return this.solved;
    }

    public void solveByTotalPivotSearch() {
        this.solve(1);
    }

    public void solveByTrivialPivotSearch() {
        this.solve(0);
    }

    public boolean isSolvable() {
        return this.solvable && this.solved;
    }

    public String equationsToString(String prefix, int fractionDigits) {
        DecimalFormat nf = new DecimalFormat();
        nf.setMinimumFractionDigits(fractionDigits);
        nf.setMaximumFractionDigits(fractionDigits);
        nf.setDecimalFormatSymbols(new DecimalFormatSymbols(Locale.US));
        nf.setNegativePrefix("");
        nf.setPositivePrefix("");
        return this.equationsToString(prefix, nf);
    }

    public String equationsToString(String prefix, NumberFormat nf) {
        if (this.coeff == null || this.rhs == null || this.row == null || this.col == null) {
            throw new NullPointerException();
        }
        int[] coeffDigits = this.maxIntegerDigits(this.coeff);
        int rhsDigits = this.maxIntegerDigits(this.rhs);
        StringBuilder buffer = new StringBuilder();
        buffer.append(prefix).append('\n').append(prefix);
        for (int i = 0; i < this.coeff.length; ++i) {
            for (int j = 0; j < this.coeff[this.row[0]].length; ++j) {
                this.format(nf, buffer, this.coeff[this.row[i]][this.col[j]], coeffDigits[this.col[j]]);
                buffer.append(" * x_").append(this.col[j]);
            }
            buffer.append(" =");
            this.format(nf, buffer, this.rhs[this.row[i]], rhsDigits);
            if (i < this.coeff.length - 1) {
                buffer.append('\n').append(prefix);
                continue;
            }
            buffer.append('\n').append(prefix);
        }
        return buffer.toString();
    }

    public String equationsToString(NumberFormat nf) {
        return this.equationsToString("", nf);
    }

    public String equationsToString(int fractionDigits) {
        return this.equationsToString("", fractionDigits);
    }

    public String solutionToString(int fractionDigits) {
        if (!this.isSolvable()) {
            throw new IllegalStateException("System is not solvable!");
        }
        DecimalFormat nf = new DecimalFormat();
        nf.setMinimumFractionDigits(fractionDigits);
        nf.setMaximumFractionDigits(fractionDigits);
        nf.setDecimalFormatSymbols(new DecimalFormatSymbols(Locale.US));
        nf.setNegativePrefix("");
        nf.setPositivePrefix("");
        int row = this.coeff[0].length >> 1;
        int params = this.u.length;
        int paramsDigits = this.integerDigits(params);
        int x0Digits = this.maxIntegerDigits(this.x_0);
        int[] uDigits = this.maxIntegerDigits(this.u);
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < this.x_0.length; ++i) {
            double value = this.x_0[i];
            this.format(nf, buffer, value, x0Digits);
            for (int j = 0; j < this.u[0].length; ++j) {
                if (i == row) {
                    buffer.append("  +  a_").append(j).append(" * ");
                } else {
                    buffer.append("          ");
                    for (int d = 0; d < paramsDigits; ++d) {
                        buffer.append(' ');
                    }
                }
                this.format(nf, buffer, this.u[i][j], uDigits[j]);
            }
            buffer.append('\n');
        }
        return buffer.toString();
    }

    private void reducedRowEchelonForm(int method) {
        int rows = this.coeff.length;
        int cols = this.coeff[0].length;
        int k = -1;
        boolean exitLoop = false;
        while (!exitLoop) {
            IntIntPair pivotPos = new IntIntPair(0, 0);
            IntIntPair currPos = new IntIntPair(++k, k);
            switch (method) {
                case 0: {
                    pivotPos = this.nonZeroPivotSearch(k);
                    break;
                }
                case 1: {
                    pivotPos = this.totalPivotSearch(k);
                }
            }
            int pivotRow = pivotPos.first;
            int pivotCol = pivotPos.second;
            double pivot = this.coeff[this.row[pivotRow]][this.col[pivotCol]];
            if (LOG.isDebugging()) {
                StringBuilder msg = new StringBuilder();
                msg.append("equations ").append(this.equationsToString(4));
                msg.append("  *** pivot at (").append(pivotRow).append(',').append(pivotCol).append(") = ").append(pivot).append('\n');
                LOG.debugFine(msg.toString());
            }
            this.permutePivot(pivotPos, currPos);
            if (Math.abs(pivot) <= 0.001) {
                exitLoop = true;
            }
            if (Math.abs(pivot) > 0.001) {
                ++this.rank;
                this.pivotOperation(k);
            }
            if (k != rows - 1 && k != cols - 1) continue;
            exitLoop = true;
        }
        this.reducedRowEchelonForm = true;
    }

    private IntIntPair totalPivotSearch(int k) {
        double max = 0.0;
        int pivotRow = k;
        int pivotCol = k;
        for (int i = k; i < this.coeff.length; ++i) {
            for (int j = k; j < this.coeff[0].length; ++j) {
                double absValue = Math.abs(this.coeff[this.row[i]][this.col[j]]);
                if (!(max < absValue)) continue;
                max = absValue;
                pivotRow = i;
                pivotCol = j;
            }
        }
        return new IntIntPair(pivotRow, pivotCol);
    }

    private IntIntPair nonZeroPivotSearch(int k) {
        for (int i = k; i < this.coeff.length; ++i) {
            for (int j = k; j < this.coeff[0].length; ++j) {
                double absValue = Math.abs(this.coeff[this.row[i]][this.col[j]]);
                if (!(absValue > 0.0)) continue;
                return new IntIntPair(i, j);
            }
        }
        return new IntIntPair(k, k);
    }

    private void permutePivot(IntIntPair pos1, IntIntPair pos2) {
        int r1 = pos1.first;
        int c1 = pos1.second;
        int r2 = pos2.first;
        int c2 = pos2.second;
        int index = this.row[r2];
        this.row[r2] = this.row[r1];
        this.row[r1] = index;
        index = this.col[c2];
        this.col[c2] = this.col[c1];
        this.col[c1] = index;
    }

    private void pivotOperation(int k) {
        int i;
        double pivot = this.coeff[this.row[k]][this.col[k]];
        this.coeff[this.row[k]][this.col[k]] = 1.0;
        for (i = k + 1; i < this.coeff[k].length; ++i) {
            double[] dArray = this.coeff[this.row[k]];
            int n = this.col[i];
            dArray[n] = dArray[n] / pivot;
        }
        int n = this.row[k];
        this.rhs[n] = this.rhs[n] / pivot;
        if (LOG.isDebugging()) {
            StringBuilder msg = new StringBuilder();
            msg.append("set pivot element to 1 ").append(this.equationsToString(4));
            LOG.debugFine(msg.toString());
        }
        for (i = 0; i < this.coeff.length; ++i) {
            if (i == k) continue;
            double q = this.coeff[this.row[i]][this.col[k]];
            this.coeff[this.row[i]][this.col[k]] = 0.0;
            for (int j = k + 1; j < this.coeff[0].length; ++j) {
                this.coeff[this.row[i]][this.col[j]] = this.coeff[this.row[i]][this.col[j]] - this.coeff[this.row[k]][this.col[j]] * q;
            }
            this.rhs[this.row[i]] = this.rhs[this.row[i]] - this.rhs[this.row[k]] * q;
        }
        if (LOG.isDebugging()) {
            StringBuilder msg = new StringBuilder();
            msg.append("after pivot operation ").append(this.equationsToString(4));
            LOG.debugFine(msg.toString());
        }
    }

    private void solve(int method) throws NullPointerException {
        if (this.solved) {
            return;
        }
        if (!this.reducedRowEchelonForm) {
            this.reducedRowEchelonForm(method);
        }
        if (!this.isSolvable(method)) {
            if (LOG.isDebugging()) {
                LOG.debugFine("Equation system is not solvable!");
            }
            return;
        }
        int cols = this.coeff[0].length;
        int numbound = 0;
        int numfree = 0;
        int[] boundIndices = new int[cols];
        int[] freeIndices = new int[cols];
        this.x_0 = new double[cols];
        block0: for (int i = 0; i < this.coeff.length; ++i) {
            for (int j = i; j < this.coeff[this.row[i]].length; ++j) {
                if (this.coeff[this.row[i]][this.col[j]] != 1.0) continue;
                this.x_0[this.col[i]] = this.rhs[this.row[i]];
                boundIndices[numbound++] = this.col[i];
                continue block0;
            }
            freeIndices[numfree++] = i;
        }
        StringBuilder msg = new StringBuilder();
        if (LOG.isDebugging()) {
            msg.append("\nSpecial solution x_0 = [").append(FormatUtil.format(this.x_0, ",", FormatUtil.NF4)).append(']').append("\nbound Indices ").append(FormatUtil.format(boundIndices, ",")).append("\nfree Indices ").append(FormatUtil.format(freeIndices, ","));
        }
        Arrays.sort(boundIndices, 0, numbound);
        int freeIndex = 0;
        int boundIndex = 0;
        this.u = new double[cols][numfree];
        for (int j = 0; j < this.u[0].length; ++j) {
            for (int i = 0; i < this.u.length; ++i) {
                if (freeIndex < numfree && i == freeIndices[freeIndex]) {
                    this.u[i][j] = 1.0;
                    continue;
                }
                if (boundIndex >= numbound || i != boundIndices[boundIndex]) continue;
                this.u[i][j] = -this.coeff[this.row[boundIndex]][freeIndices[freeIndex]];
                ++boundIndex;
            }
            ++freeIndex;
            boundIndex = 0;
        }
        if (LOG.isDebugging()) {
            msg.append("\nU");
            for (double[] anU : this.u) {
                msg.append('\n').append(FormatUtil.format(anU, ",", FormatUtil.NF4));
            }
            LOG.debugFine(msg.toString());
        }
        this.solved = true;
    }

    private boolean isSolvable(int method) throws NullPointerException {
        if (this.solved) {
            return this.solvable;
        }
        if (!this.reducedRowEchelonForm) {
            this.reducedRowEchelonForm(method);
        }
        for (int i = this.rank; i < this.rhs.length; ++i) {
            if (!(Math.abs(this.rhs[this.row[i]]) > 0.001)) continue;
            this.solvable = false;
            return false;
        }
        this.solvable = true;
        return true;
    }

    private int[] maxIntegerDigits(double[][] values) {
        int[] digits = new int[values[0].length];
        for (int j = 0; j < values[0].length; ++j) {
            for (double[] value : values) {
                digits[j] = Math.max(digits[j], this.integerDigits(value[j]));
            }
        }
        return digits;
    }

    private int maxIntegerDigits(double[] values) {
        int digits = 0;
        for (double value : values) {
            digits = Math.max(digits, this.integerDigits(value));
        }
        return digits;
    }

    private int integerDigits(double d) {
        double value = Math.abs(d);
        if (value < 10.0) {
            return 1;
        }
        return (int)FastMath.log10(value) + 1;
    }

    private void format(NumberFormat nf, StringBuilder buffer, double value, int maxIntegerDigits) {
        if (value >= 0.0) {
            buffer.append(" + ");
        } else {
            buffer.append(" - ");
        }
        int digits = maxIntegerDigits - this.integerDigits(value);
        for (int d = 0; d < digits; ++d) {
            buffer.append(' ');
        }
        buffer.append(nf.format(Math.abs(value)));
    }

    public int subspacedim() {
        return this.coeff[0].length - this.coeff.length;
    }
}

