/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.linearalgebra;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Centroid;
import de.lmu.ifi.dbs.elki.utilities.datastructures.BitsUtil;

public class ProjectedCentroid
extends Centroid {
    private long[] dims;

    public ProjectedCentroid(long[] dims, int dim) {
        super(dim);
        this.dims = dims;
    }

    @Override
    public void put(double[] val) {
        assert (val.length == this.elements.length);
        this.wsum += 1.0;
        int i = BitsUtil.nextSetBit(this.dims, 0);
        while (i >= 0) {
            double delta = val[i] - this.elements[i];
            int n = i;
            this.elements[n] = this.elements[n] + delta / this.wsum;
            i = BitsUtil.nextSetBit(this.dims, i + 1);
        }
    }

    @Override
    public void put(double[] val, double weight) {
        assert (val.length == this.elements.length);
        if (weight == 0.0) {
            return;
        }
        double nwsum = weight + this.wsum;
        int i = BitsUtil.nextSetBit(this.dims, 0);
        while (i >= 0) {
            double delta = val[i] - this.elements[i];
            double rval = delta * weight / nwsum;
            int n = i;
            this.elements[n] = this.elements[n] + rval;
            i = BitsUtil.nextSetBit(this.dims, i + 1);
        }
        this.wsum = nwsum;
    }

    @Override
    public void put(NumberVector val) {
        assert (val.getDimensionality() == this.elements.length);
        this.wsum += 1.0;
        int i = BitsUtil.nextSetBit(this.dims, 0);
        while (i >= 0) {
            double delta = val.doubleValue(i) - this.elements[i];
            int n = i;
            this.elements[n] = this.elements[n] + delta / this.wsum;
            i = BitsUtil.nextSetBit(this.dims, i + 1);
        }
    }

    @Override
    public void put(NumberVector val, double weight) {
        assert (val.getDimensionality() == this.elements.length);
        if (weight == 0.0) {
            return;
        }
        double nwsum = weight + this.wsum;
        int i = BitsUtil.nextSetBit(this.dims, 0);
        while (i >= 0) {
            double delta = val.doubleValue(i) - this.elements[i];
            double rval = delta * weight / nwsum;
            int n = i;
            this.elements[n] = this.elements[n] + rval;
            i = BitsUtil.nextSetBit(this.dims, i + 1);
        }
        this.wsum = nwsum;
    }

    public static ProjectedCentroid make(long[] dims, Relation<? extends NumberVector> relation) {
        ProjectedCentroid c = new ProjectedCentroid(dims, RelationUtil.dimensionality(relation));
        DBIDIter iditer = relation.iterDBIDs();
        while (iditer.valid()) {
            c.put(relation.get(iditer));
            iditer.advance();
        }
        return c;
    }

    public static ProjectedCentroid make(long[] dims, Relation<? extends NumberVector> relation, DBIDs ids) {
        ProjectedCentroid c = new ProjectedCentroid(dims, RelationUtil.dimensionality(relation));
        DBIDIter iter = ids.iter();
        while (iter.valid()) {
            c.put(relation.get(iter));
            iter.advance();
        }
        return c;
    }
}

