/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.linearalgebra;

import de.lmu.ifi.dbs.elki.math.linearalgebra.VMath;
import java.io.Serializable;
import java.util.Arrays;
import net.jafama.FastMath;

public class QRDecomposition
implements Serializable {
    protected static final String ERR_MATRIX_RANK_DEFICIENT = "Matrix is rank deficient.";
    private static final long serialVersionUID = 1L;
    private double[][] QR;
    private int m;
    private int n;
    private double[] Rdiag;

    public QRDecomposition(double[][] A) {
        this(A, A.length, A[0].length);
    }

    public QRDecomposition(double[][] A, int m, int n) {
        this.QR = VMath.copy(A);
        if (m < n) {
            throw new IllegalArgumentException("Matrix does not satisfy rows >= columns!");
        }
        this.m = m;
        this.n = n;
        this.Rdiag = new double[n];
        for (int k = 0; k < n; ++k) {
            double nrm = 0.0;
            for (int i = k; i < m; ++i) {
                nrm = FastMath.hypot(nrm, this.QR[i][k]);
            }
            if (nrm != 0.0) {
                double[] QRk = this.QR[k];
                nrm = QRk[k] < 0.0 ? -nrm : nrm;
                for (int i = k; i < m; ++i) {
                    double[] dArray = this.QR[i];
                    int n2 = k;
                    dArray[n2] = dArray[n2] / nrm;
                }
                int n3 = k;
                QRk[n3] = QRk[n3] + 1.0;
                for (int j = k + 1; j < n; ++j) {
                    double[] QRi;
                    int i;
                    double s = 0.0;
                    for (i = k; i < m; ++i) {
                        QRi = this.QR[i];
                        s += QRi[k] * QRi[j];
                    }
                    s /= QRk[k];
                    for (i = k; i < m; ++i) {
                        QRi = this.QR[i];
                        int n4 = j;
                        QRi[n4] = QRi[n4] - s * QRi[k];
                    }
                }
            }
            this.Rdiag[k] = -nrm;
        }
    }

    public boolean isFullRank() {
        int j;
        double t = 0.0;
        for (j = 0; j < this.n; ++j) {
            double v = this.Rdiag[j];
            if (v == 0.0) {
                return false;
            }
            t = (v = Math.abs(v)) > t ? v : t;
        }
        t *= 1.0E-15;
        for (j = 1; j < this.n; ++j) {
            if (!(Math.abs(this.Rdiag[j]) < t)) continue;
            return false;
        }
        return true;
    }

    public int rank(double t) {
        int rank = this.n;
        for (int j = 0; j < this.n; ++j) {
            if (!(Math.abs(this.Rdiag[j]) <= t)) continue;
            --rank;
        }
        return rank;
    }

    public double[][] getH() {
        double[][] H = new double[this.m][this.n];
        for (int i = 0; i < this.m; ++i) {
            System.arraycopy(this.QR[i], 0, H[i], 0, i < this.n ? i : this.n);
        }
        return H;
    }

    public double[][] getR() {
        double[][] R = new double[this.n][this.n];
        for (int i = 0; i < this.n; ++i) {
            System.arraycopy(this.QR[i], i + 1, R[i], i + 1, this.n - i - 1);
            R[i][i] = this.Rdiag[i];
        }
        return R;
    }

    public double[][] getQ() {
        double[][] Q = new double[this.m][this.n];
        for (int k = this.n - 1; k >= 0; --k) {
            for (int i = 0; i < this.m; ++i) {
                Q[i][k] = 0.0;
            }
            Q[k][k] = 1.0;
            for (int j = k; j < this.n; ++j) {
                int i;
                if (this.QR[k][k] == 0.0) continue;
                double s = 0.0;
                for (i = k; i < this.m; ++i) {
                    s += this.QR[i][k] * Q[i][j];
                }
                s /= this.QR[k][k];
                for (i = k; i < this.m; ++i) {
                    double[] dArray = Q[i];
                    int n = j;
                    dArray[n] = dArray[n] - s * this.QR[i][k];
                }
            }
        }
        return Q;
    }

    public double[][] solve(double[][] B) {
        double[][] sol = this.solveInplace(VMath.copy(B));
        return this.n < sol.length ? (double[][])Arrays.copyOf(sol, this.n) : sol;
    }

    private double[][] solveInplace(double[][] B) {
        int k;
        int rows = B.length;
        int nx = B[0].length;
        if (rows != this.m) {
            throw new IllegalArgumentException("Matrix dimensions do not agree.");
        }
        if (!this.isFullRank()) {
            throw new ArithmeticException(ERR_MATRIX_RANK_DEFICIENT);
        }
        for (k = 0; k < this.n; ++k) {
            for (int j = 0; j < nx; ++j) {
                int i;
                double s = 0.0;
                for (i = k; i < this.m; ++i) {
                    s += this.QR[i][k] * B[i][j];
                }
                s /= this.QR[k][k];
                for (i = k; i < this.m; ++i) {
                    double[] dArray = B[i];
                    int n = j;
                    dArray[n] = dArray[n] - s * this.QR[i][k];
                }
            }
        }
        for (k = this.n - 1; k >= 0; --k) {
            double[] Xk = B[k];
            int j = 0;
            while (j < nx) {
                int n = j++;
                Xk[n] = Xk[n] / this.Rdiag[k];
            }
            for (int i = 0; i < k; ++i) {
                double[] Xi = B[i];
                double QRik = this.QR[i][k];
                for (int j2 = 0; j2 < nx; ++j2) {
                    int n = j2;
                    Xi[n] = Xi[n] - Xk[j2] * QRik;
                }
            }
        }
        return B;
    }

    public double[] solve(double[] b) {
        double[] sol = this.solveInplace(VMath.copy(b));
        return this.n < sol.length ? Arrays.copyOf(sol, this.n) : sol;
    }

    public double[] solveInplace(double[] b) {
        int k;
        if (b.length != this.m) {
            throw new IllegalArgumentException("Matrix dimensions do not agree.");
        }
        if (!this.isFullRank()) {
            throw new ArithmeticException(ERR_MATRIX_RANK_DEFICIENT);
        }
        for (k = 0; k < this.n; ++k) {
            int i;
            double s = 0.0;
            for (i = k; i < this.m; ++i) {
                s += this.QR[i][k] * b[i];
            }
            s /= this.QR[k][k];
            for (i = k; i < this.m; ++i) {
                int n = i;
                b[n] = b[n] - s * this.QR[i][k];
            }
        }
        for (k = this.n - 1; k >= 0; --k) {
            int n = k;
            b[n] = b[n] / this.Rdiag[k];
            int i = 0;
            while (i < k) {
                double QRik = this.QR[i][k];
                int n2 = i++;
                b[n2] = b[n2] - b[k] * QRik;
            }
        }
        return b;
    }

    public double[][] inverse() {
        return this.solveInplace(VMath.unitMatrix(this.m));
    }
}

