/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.linearalgebra;

import de.lmu.ifi.dbs.elki.math.linearalgebra.VMath;
import net.jafama.FastMath;

public class SingularValueDecomposition {
    private double[][] U;
    private double[][] V;
    private double[] s;
    private int m;
    private int n;

    public SingularValueDecomposition(double[][] Arg2) {
        double[][] A = VMath.copy(Arg2);
        this.m = A.length;
        this.n = A[0].length;
        int nu = Math.min(this.m, this.n);
        this.s = new double[Math.min(this.m + 1, this.n)];
        this.U = new double[this.m][nu];
        this.V = new double[this.n][this.n];
        double[] e = new double[this.n];
        double[] work = new double[this.m];
        boolean wantu = true;
        boolean wantv = true;
        int nct = Math.min(this.m - 1, this.n);
        int nrt = Math.max(0, Math.min(this.n - 2, this.m));
        for (int k = 0; k < Math.max(nct, nrt); ++k) {
            int i;
            int i2;
            if (k < nct) {
                double sk = A[k][k];
                for (i2 = k + 1; i2 < this.m; ++i2) {
                    sk = FastMath.hypot(sk, A[i2][k]);
                }
                if (sk != 0.0) {
                    sk = A[k][k] < 0.0 ? -sk : sk;
                    for (i2 = k; i2 < this.m; ++i2) {
                        double[] dArray = A[i2];
                        int n = k;
                        dArray[n] = dArray[n] / sk;
                    }
                    double[] dArray = A[k];
                    int n = k;
                    dArray[n] = dArray[n] + 1.0;
                }
                this.s[k] = -sk;
            }
            for (int j = k + 1; j < this.n; ++j) {
                if (k < nct && this.s[k] != 0.0) {
                    double t = 0.0;
                    for (i = k; i < this.m; ++i) {
                        t += A[i][k] * A[i][j];
                    }
                    t /= -A[k][k];
                    for (i = k; i < this.m; ++i) {
                        double[] dArray = A[i];
                        int n = j;
                        dArray[n] = dArray[n] + t * A[i][k];
                    }
                }
                e[j] = A[k][j];
            }
            if (wantu && k < nct) {
                for (int i3 = k; i3 < this.m; ++i3) {
                    this.U[i3][k] = A[i3][k];
                }
            }
            if (k >= nrt) continue;
            double ek = e[k + 1];
            for (i2 = k + 2; i2 < this.n; ++i2) {
                ek = FastMath.hypot(ek, e[i2]);
            }
            if (ek != 0.0) {
                ek = e[k + 1] < 0.0 ? -ek : ek;
                i2 = k + 1;
                while (i2 < this.n) {
                    int n = i2++;
                    e[n] = e[n] / ek;
                }
                int n = k + 1;
                e[n] = e[n] + 1.0;
            }
            e[k] = -ek;
            if (k + 1 < this.m && ek != 0.0) {
                int j;
                for (i2 = k + 1; i2 < this.m; ++i2) {
                    work[i2] = 0.0;
                }
                for (j = k + 1; j < this.n; ++j) {
                    for (i = k + 1; i < this.m; ++i) {
                        int n = i;
                        work[n] = work[n] + e[j] * A[i][j];
                    }
                }
                for (j = k + 1; j < this.n; ++j) {
                    double t = -e[j] / e[k + 1];
                    for (int i4 = k + 1; i4 < this.m; ++i4) {
                        double[] dArray = A[i4];
                        int n = j;
                        dArray[n] = dArray[n] + t * work[i4];
                    }
                }
            }
            if (!wantv) continue;
            for (i2 = k + 1; i2 < this.n; ++i2) {
                this.V[i2][k] = e[i2];
            }
        }
        int p = Math.min(this.n, this.m + 1);
        if (nct < this.n) {
            this.s[nct] = A[nct][nct];
        }
        if (this.m < p) {
            this.s[p - 1] = 0.0;
        }
        if (nrt + 1 < p) {
            e[nrt] = A[nrt][p - 1];
        }
        e[p - 1] = 0.0;
        if (wantu) {
            this.generateU(nu, nct);
        }
        if (wantv) {
            this.generateV(nu, e, nrt);
        }
        int pp = p - 1;
        double eps = 2.220446049250313E-16;
        double tiny = 1.6033346880071782E-291;
        while (p > 0) {
            int ks;
            int k;
            for (k = p - 2; k > -1; --k) {
                if (!(Math.abs(e[k]) <= 1.6033346880071782E-291 + 2.220446049250313E-16 * (Math.abs(this.s[k]) + Math.abs(this.s[k + 1])))) continue;
                e[k] = 0.0;
                break;
            }
            if (k == p - 2) {
                ++k;
                k = this.convergence(k, pp, wantu, wantv);
                --p;
                continue;
            }
            for (ks = p - 1; ks > k; --ks) {
                double t = (ks != p ? Math.abs(e[ks]) : 0.0) + (ks != k + 1 ? Math.abs(e[ks - 1]) : 0.0);
                if (!(Math.abs(this.s[ks]) <= 1.6033346880071782E-291 + 2.220446049250313E-16 * t)) continue;
                this.s[ks] = 0.0;
                break;
            }
            if (ks == k) {
                this.qrStep(e, p, ++k, wantu, wantv);
                continue;
            }
            if (ks == p - 1) {
                this.deflate(e, p, ++k, wantv);
                continue;
            }
            k = ks;
            this.split(e, p, ++k, wantu);
        }
    }

    private void generateU(int nu, int nct) {
        int i;
        for (int j = nct; j < nu; ++j) {
            for (i = 0; i < this.m; ++i) {
                this.U[i][j] = 0.0;
            }
            this.U[j][j] = 1.0;
        }
        for (int k = nct - 1; k >= 0; --k) {
            if (this.s[k] != 0.0) {
                for (int j = k + 1; j < nu; ++j) {
                    double[] Ui;
                    int i2;
                    double t = 0.0;
                    for (i2 = k; i2 < this.m; ++i2) {
                        Ui = this.U[i2];
                        t += Ui[k] * Ui[j];
                    }
                    t /= -this.U[k][k];
                    for (i2 = k; i2 < this.m; ++i2) {
                        Ui = this.U[i2];
                        int n = j;
                        Ui[n] = Ui[n] + t * Ui[k];
                    }
                }
                for (i = k; i < this.m; ++i) {
                    double[] Ui = this.U[i];
                    Ui[k] = -Ui[k];
                }
                this.U[k][k] = 1.0 + this.U[k][k];
                for (i = 0; i < k - 1; ++i) {
                    this.U[i][k] = 0.0;
                }
                continue;
            }
            for (i = 0; i < this.m; ++i) {
                this.U[i][k] = 0.0;
            }
            this.U[k][k] = 1.0;
        }
    }

    private void generateV(int nu, double[] e, int nrt) {
        for (int k = this.n - 1; k >= 0; --k) {
            if (k < nrt && e[k] != 0.0) {
                for (int j = k + 1; j < nu; ++j) {
                    double[] Vi;
                    int i;
                    double t = 0.0;
                    for (i = k + 1; i < this.n; ++i) {
                        Vi = this.V[i];
                        t += Vi[k] * Vi[j];
                    }
                    t /= -this.V[k + 1][k];
                    for (i = k + 1; i < this.n; ++i) {
                        Vi = this.V[i];
                        int n = j;
                        Vi[n] = Vi[n] + t * Vi[k];
                    }
                }
            }
            for (int i = 0; i < this.n; ++i) {
                this.V[i][k] = 0.0;
            }
            this.V[k][k] = 1.0;
        }
    }

    private void deflate(double[] e, int p, int k, boolean wantv) {
        double f = e[p - 2];
        e[p - 2] = 0.0;
        for (int j = p - 2; j >= k; --j) {
            double t = FastMath.hypot(this.s[j], f);
            double cs = this.s[j] / t;
            double sn = f / t;
            this.s[j] = t;
            if (j != k) {
                f = -sn * e[j - 1];
                e[j - 1] = cs * e[j - 1];
            }
            if (!wantv) continue;
            for (int i = 0; i < this.n; ++i) {
                t = cs * this.V[i][j] + sn * this.V[i][p - 1];
                this.V[i][p - 1] = -sn * this.V[i][j] + cs * this.V[i][p - 1];
                this.V[i][j] = t;
            }
        }
    }

    private void split(double[] e, int p, int k, boolean wantu) {
        double f = e[k - 1];
        e[k - 1] = 0.0;
        for (int j = k; j < p; ++j) {
            double t = FastMath.hypot(this.s[j], f);
            double cs = this.s[j] / t;
            double sn = f / t;
            this.s[j] = t;
            f = -sn * e[j];
            e[j] = cs * e[j];
            if (!wantu) continue;
            for (int i = 0; i < this.m; ++i) {
                t = cs * this.U[i][j] + sn * this.U[i][k - 1];
                this.U[i][k - 1] = -sn * this.U[i][j] + cs * this.U[i][k - 1];
                this.U[i][j] = t;
            }
        }
    }

    private void qrStep(double[] e, int p, int k, boolean wantu, boolean wantv) {
        double scale = Math.max(Math.max(Math.max(Math.max(Math.abs(this.s[p - 1]), Math.abs(this.s[p - 2])), Math.abs(e[p - 2])), Math.abs(this.s[k])), Math.abs(e[k]));
        double sp = this.s[p - 1] / scale;
        double spm1 = this.s[p - 2] / scale;
        double epm1 = e[p - 2] / scale;
        double sk = this.s[k] / scale;
        double ek = e[k] / scale;
        double b = ((spm1 + sp) * (spm1 - sp) + epm1 * epm1) / 2.0;
        double c = sp * epm1 * (sp * epm1);
        double shift = 0.0;
        if (b != 0.0 || c != 0.0) {
            shift = FastMath.sqrt(b * b + c);
            shift = c / (b < 0.0 ? b - shift : b + shift);
        }
        double f = (sk + sp) * (sk - sp) + shift;
        double g = sk * ek;
        for (int j = k; j < p - 1; ++j) {
            double tmp;
            int i;
            double t = FastMath.hypot(f, g);
            double cs = f / t;
            double sn = g / t;
            if (j != k) {
                e[j - 1] = t;
            }
            f = cs * this.s[j] + sn * e[j];
            e[j] = cs * e[j] - sn * this.s[j];
            g = sn * this.s[j + 1];
            this.s[j + 1] = cs * this.s[j + 1];
            if (wantv) {
                for (i = 0; i < this.n; ++i) {
                    double[] Vi = this.V[i];
                    tmp = cs * Vi[j] + sn * Vi[j + 1];
                    Vi[j + 1] = -sn * Vi[j] + cs * Vi[j + 1];
                    Vi[j] = tmp;
                }
            }
            t = this.s[j] = FastMath.hypot(f, g);
            cs = f / t;
            sn = g / t;
            f = cs * e[j] + sn * this.s[j + 1];
            this.s[j + 1] = -sn * e[j] + cs * this.s[j + 1];
            g = sn * e[j + 1];
            e[j + 1] = cs * e[j + 1];
            if (!wantu || j >= this.m - 1) continue;
            for (i = 0; i < this.m; ++i) {
                double[] Ui = this.U[i];
                tmp = cs * Ui[j] + sn * Ui[j + 1];
                Ui[j + 1] = -sn * Ui[j] + cs * Ui[j + 1];
                Ui[j] = tmp;
            }
        }
        e[p - 2] = f;
    }

    private int convergence(int k, int pp, boolean wantu, boolean wantv) {
        if (this.s[k] <= 0.0) {
            double d = this.s[k] = this.s[k] < 0.0 ? -this.s[k] : 0.0;
            if (wantv) {
                for (int i = 0; i <= pp; ++i) {
                    this.V[i][k] = -this.V[i][k];
                }
            }
        }
        while (k < pp && !(this.s[k] >= this.s[k + 1])) {
            double swap;
            int i;
            double t = this.s[k];
            this.s[k] = this.s[k + 1];
            this.s[k + 1] = t;
            if (wantv && k < this.n - 1) {
                for (i = 0; i < this.n; ++i) {
                    double[] Vi = this.V[i];
                    swap = Vi[k + 1];
                    Vi[k + 1] = Vi[k];
                    Vi[k] = swap;
                }
            }
            if (wantu && k < this.m - 1) {
                for (i = 0; i < this.m; ++i) {
                    double[] Ui = this.U[i];
                    swap = Ui[k + 1];
                    Ui[k + 1] = Ui[k];
                    Ui[k] = swap;
                }
            }
            ++k;
        }
        return k;
    }

    public double[][] getU() {
        return this.U;
    }

    public double[][] getV() {
        return this.V;
    }

    public double[] getSingularValues() {
        return this.s;
    }

    public double[][] getS() {
        double[][] S = new double[this.n][this.n];
        for (int i = 0; i < this.n; ++i) {
            S[i][i] = this.s[i];
        }
        return S;
    }

    public double norm2() {
        return this.s[0];
    }

    public double cond() {
        return this.s[0] / this.s[Math.min(this.m, this.n) - 1];
    }

    public int rank() {
        double eps = 2.220446049250313E-16;
        double tol = (double)(this.m > this.n ? this.m : this.n) * this.s[0] * 2.220446049250313E-16;
        int r = 0;
        for (int i = 0; i < this.s.length; ++i) {
            if (!(this.s[i] > tol)) continue;
            ++r;
        }
        return r;
    }
}

