/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.linearalgebra;

import de.lmu.ifi.dbs.elki.math.linearalgebra.LUDecomposition;
import de.lmu.ifi.dbs.elki.math.linearalgebra.QRDecomposition;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import java.util.Arrays;
import net.jafama.FastMath;

@Title(value="Vector and Matrix Math Library")
public final class VMath {
    private static final double DELTA = 1.0E-5;
    protected static final String ERR_VEC_DIMENSIONS = "Vector dimensions do not agree.";
    protected static final String ERR_MATRIX_DIMENSIONS = "Matrix dimensions do not agree.";
    protected static final String ERR_MATRIX_INNERDIM = "Matrix inner dimensions do not agree.";
    protected static final String ERR_DIMENSIONS = "Dimensionalities do not agree.";
    protected static final String ERR_INVALID_RANGE = "Invalid range parameters.";
    protected static final String ERR_MATRIX_NONSQUARE = "Matrix must be square.";
    protected static final String ERR_SINGULAR = "Matrix is singular.";
    protected static final String ERR_MATRIX_NOT_SPD = "Matrix is not symmetric positive definite.";
    protected static final String ERR_MATRIX_RANK_DEFICIENT = "Matrix is rank deficient.";

    private VMath() {
    }

    public static double[] unitVector(int dimensionality, int i) {
        double[] v = new double[dimensionality];
        v[i] = 1.0;
        return v;
    }

    public static double[] copy(double[] v) {
        return (double[])v.clone();
    }

    public static double[][] transpose(double[] v) {
        return new double[][]{v};
    }

    public static double[] plus(double[] v1, double[] v2) {
        assert (v1.length == v2.length) : "Vector dimensions do not agree.";
        double[] result = new double[v1.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = v1[i] + v2[i];
        }
        return result;
    }

    public static double[] plusTimes(double[] v1, double[] v2, double s2) {
        assert (v1.length == v2.length) : "Vector dimensions do not agree.";
        double[] result = new double[v1.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = v1[i] + v2[i] * s2;
        }
        return result;
    }

    public static double[] timesPlus(double[] v1, double s1, double[] v2) {
        assert (v1.length == v2.length) : "Vector dimensions do not agree.";
        double[] result = new double[v1.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = v1[i] * s1 + v2[i];
        }
        return result;
    }

    public static double[] timesPlusTimes(double[] v1, double s1, double[] v2, double s2) {
        assert (v1.length == v2.length) : "Vector dimensions do not agree.";
        double[] result = new double[v1.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = v1[i] * s1 + v2[i] * s2;
        }
        return result;
    }

    public static double[] plusEquals(double[] v1, double[] v2) {
        assert (v1.length == v2.length) : "Vector dimensions do not agree.";
        for (int i = 0; i < v1.length; ++i) {
            int n = i;
            v1[n] = v1[n] + v2[i];
        }
        return v1;
    }

    public static double[] plusTimesEquals(double[] v1, double[] v2, double s2) {
        assert (v1.length == v2.length) : "Vector dimensions do not agree.";
        for (int i = 0; i < v1.length; ++i) {
            int n = i;
            v1[n] = v1[n] + s2 * v2[i];
        }
        return v1;
    }

    public static double[] timesPlusEquals(double[] v1, double s1, double[] v2) {
        assert (v1.length == v2.length) : "Vector dimensions do not agree.";
        for (int i = 0; i < v1.length; ++i) {
            v1[i] = v1[i] * s1 + v2[i];
        }
        return v1;
    }

    public static double[] timesPlusTimesEquals(double[] v1, double s1, double[] v2, double s2) {
        assert (v1.length == v2.length) : "Vector dimensions do not agree.";
        for (int i = 0; i < v1.length; ++i) {
            v1[i] = v1[i] * s1 + v2[i] * s2;
        }
        return v1;
    }

    public static double[] plus(double[] v1, double s1) {
        double[] result = new double[v1.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = v1[i] + s1;
        }
        return result;
    }

    public static double[] plusEquals(double[] v1, double s1) {
        int i = 0;
        while (i < v1.length) {
            int n = i++;
            v1[n] = v1[n] + s1;
        }
        return v1;
    }

    public static double[] minus(double[] v1, double[] v2) {
        assert (v1.length == v2.length) : "Vector dimensions do not agree.";
        double[] sub = new double[v1.length];
        for (int i = 0; i < v1.length; ++i) {
            sub[i] = v1[i] - v2[i];
        }
        return sub;
    }

    public static double[] minusTimes(double[] v1, double[] v2, double s2) {
        assert (v1.length == v2.length) : "Vector dimensions do not agree.";
        double[] sub = new double[v1.length];
        for (int i = 0; i < v1.length; ++i) {
            sub[i] = v1[i] - v2[i] * s2;
        }
        return sub;
    }

    public static double[] timesMinus(double[] v1, double s1, double[] v2) {
        assert (v1.length == v2.length) : "Vector dimensions do not agree.";
        double[] sub = new double[v1.length];
        for (int i = 0; i < v1.length; ++i) {
            sub[i] = v1[i] * s1 - v2[i];
        }
        return sub;
    }

    public static double[] timesMinusTimes(double[] v1, double s1, double[] v2, double s2) {
        assert (v1.length == v2.length) : "Vector dimensions do not agree.";
        double[] sub = new double[v1.length];
        for (int i = 0; i < v1.length; ++i) {
            sub[i] = v1[i] * s1 - v2[i] * s2;
        }
        return sub;
    }

    public static double[] minusEquals(double[] v1, double[] v2) {
        assert (v1.length == v2.length) : "Vector dimensions do not agree.";
        for (int i = 0; i < v1.length; ++i) {
            int n = i;
            v1[n] = v1[n] - v2[i];
        }
        return v1;
    }

    public static double[] minusTimesEquals(double[] v1, double[] v2, double s2) {
        assert (v1.length == v2.length) : "Vector dimensions do not agree.";
        for (int i = 0; i < v1.length; ++i) {
            int n = i;
            v1[n] = v1[n] - v2[i] * s2;
        }
        return v1;
    }

    public static double[] timesMinusEquals(double[] v1, double s1, double[] v2) {
        assert (v1.length == v2.length) : "Vector dimensions do not agree.";
        for (int i = 0; i < v1.length; ++i) {
            v1[i] = v1[i] * s1 - v2[i];
        }
        return v1;
    }

    public static double[] timesMinusTimesEquals(double[] v1, double s1, double[] v2, double s2) {
        assert (v1.length == v2.length) : "Vector dimensions do not agree.";
        for (int i = 0; i < v1.length; ++i) {
            v1[i] = v1[i] * s1 - v2[i] * s2;
        }
        return v1;
    }

    public static double[] minus(double[] v1, double s1) {
        double[] result = new double[v1.length];
        for (int i = 0; i < v1.length; ++i) {
            result[i] = v1[i] - s1;
        }
        return result;
    }

    public static double[] minusEquals(double[] v1, double s1) {
        int i = 0;
        while (i < v1.length) {
            int n = i++;
            v1[n] = v1[n] - s1;
        }
        return v1;
    }

    public static double[] times(double[] v1, double s1) {
        double[] v = new double[v1.length];
        for (int i = 0; i < v1.length; ++i) {
            v[i] = v1[i] * s1;
        }
        return v;
    }

    public static double[] timesEquals(double[] v1, double s) {
        int i = 0;
        while (i < v1.length) {
            int n = i++;
            v1[n] = v1[n] * s;
        }
        return v1;
    }

    public static double[] overwriteTimes(double[] v1, double[] v2, double s) {
        for (int i = 0; i < v1.length; ++i) {
            v1[i] = v2[i] * s;
        }
        return v1;
    }

    @Deprecated
    public static double[][] times(double[] v1, double[][] m2) {
        assert (m2.length == 1) : "Matrix inner dimensions do not agree.";
        int columndimension = m2[0].length;
        double[][] re = new double[v1.length][columndimension];
        for (int j = 0; j < columndimension; ++j) {
            for (int i = 0; i < v1.length; ++i) {
                re[i][j] = v1[i] * m2[0][j];
            }
        }
        return re;
    }

    public static double[][] transposeTimes(double[] v1, double[][] m2) {
        assert (m2.length == v1.length) : "Matrix inner dimensions do not agree.";
        int columndimension = m2[0].length;
        double[][] re = new double[1][columndimension];
        for (int j = 0; j < columndimension; ++j) {
            double s = 0.0;
            for (int k = 0; k < v1.length; ++k) {
                s += v1[k] * m2[k][j];
            }
            re[0][j] = s;
        }
        return re;
    }

    public static double transposeTimes(double[] v1, double[] v2) {
        assert (v2.length == v1.length) : "Vector dimensions do not agree.";
        double s = 0.0;
        for (int k = 0; k < v1.length; ++k) {
            s += v1[k] * v2[k];
        }
        return s;
    }

    @Deprecated
    public static double[][] timesTranspose(double[] v1, double[][] m2) {
        assert (m2[0].length == 1) : "Matrix inner dimensions do not agree.";
        double[][] re = new double[v1.length][m2.length];
        for (int j = 0; j < m2.length; ++j) {
            for (int i = 0; i < v1.length; ++i) {
                re[i][j] = v1[i] * m2[j][0];
            }
        }
        return re;
    }

    public static double[][] timesTranspose(double[] v1, double[] v2) {
        double[][] re = new double[v1.length][v2.length];
        for (int j = 0; j < v2.length; ++j) {
            for (int i = 0; i < v1.length; ++i) {
                re[i][j] = v1[i] * v2[j];
            }
        }
        return re;
    }

    public static double scalarProduct(double[] v1, double[] v2) {
        return VMath.transposeTimes(v1, v2);
    }

    public static double dot(double[] v1, double[] v2) {
        return VMath.transposeTimes(v1, v2);
    }

    public static double sum(double[] v1) {
        double acc = 0.0;
        for (int row = 0; row < v1.length; ++row) {
            acc += v1[row];
        }
        return acc;
    }

    public static double squareSum(double[] v1) {
        double acc = 0.0;
        for (int row = 0; row < v1.length; ++row) {
            double v = v1[row];
            acc += v * v;
        }
        return acc;
    }

    public static double euclideanLength(double[] v1) {
        return FastMath.sqrt(VMath.squareSum(v1));
    }

    public static int argmax(double[] v) {
        assert (v.length > 0);
        int maxIndex = 0;
        double currentMax = v[0];
        for (int i = 1; i < v.length; ++i) {
            double x = v[i];
            if (!(x > currentMax)) continue;
            maxIndex = i;
            currentMax = x;
        }
        return maxIndex;
    }

    public static double[] normalize(double[] v1) {
        double norm = 1.0 / VMath.euclideanLength(v1);
        double[] re = new double[v1.length];
        if (norm < Double.POSITIVE_INFINITY) {
            for (int row = 0; row < v1.length; ++row) {
                re[row] = v1[row] * norm;
            }
        }
        return re;
    }

    public static double[] normalizeEquals(double[] v1) {
        double norm = 1.0 / VMath.euclideanLength(v1);
        if (norm < Double.POSITIVE_INFINITY) {
            int row = 0;
            while (row < v1.length) {
                int n = row++;
                v1[n] = v1[n] * norm;
            }
        }
        return v1;
    }

    public static int hashCode(double[] v1) {
        return Arrays.hashCode(v1);
    }

    public static boolean equals(double[] v1, double[] v2) {
        return Arrays.equals(v1, v2);
    }

    public static void clear(double[] v1) {
        Arrays.fill(v1, 0.0);
    }

    public static void clear(double[][] m) {
        for (int i = 0; i < m.length; ++i) {
            Arrays.fill(m[i], 0.0);
        }
    }

    public static double[] rotate90Equals(double[] v1) {
        assert (v1.length == 2) : "rotate90Equals is only valid for 2d vectors.";
        double temp = v1[0];
        v1[0] = v1[1];
        v1[1] = -temp;
        return v1;
    }

    public static double[][] unitMatrix(int dim) {
        double[][] e = new double[dim][dim];
        for (int i = 0; i < dim; ++i) {
            e[i][i] = 1.0;
        }
        return e;
    }

    public static double[][] zeroMatrix(int dim) {
        return new double[dim][dim];
    }

    public static double[][] identity(int m, int n) {
        double[][] A = new double[m][n];
        int dim = m < n ? m : n;
        for (int i = 0; i < dim; ++i) {
            A[i][i] = 1.0;
        }
        return A;
    }

    public static double[][] diagonal(double[] v1) {
        int dim = v1.length;
        double[][] result = new double[dim][dim];
        for (int i = 0; i < dim; ++i) {
            result[i][i] = v1[i];
        }
        return result;
    }

    public static double[][] copy(double[][] m1) {
        int rowdim = m1.length;
        int coldim = VMath.getColumnDimensionality(m1);
        double[][] X = new double[rowdim][coldim];
        for (int i = 0; i < rowdim; ++i) {
            System.arraycopy(m1[i], 0, X[i], 0, coldim);
        }
        return X;
    }

    public static double[] rowPackedCopy(double[][] m1) {
        int rowdim = m1.length;
        int coldim = VMath.getColumnDimensionality(m1);
        double[] vals = new double[rowdim * coldim];
        int i = 0;
        int j = 0;
        while (i < rowdim) {
            System.arraycopy(m1[i], 0, vals, j, coldim);
            ++i;
            j += coldim;
        }
        return vals;
    }

    public static double[] columnPackedCopy(double[][] m1) {
        int rowdim = m1.length;
        int coldim = VMath.getColumnDimensionality(m1);
        double[] vals = new double[m1.length * coldim];
        for (int i = 0; i < rowdim; ++i) {
            double[] rowM = m1[i];
            int j = 0;
            int k = i;
            while (j < coldim) {
                vals[k] = rowM[j];
                ++j;
                k += rowdim;
            }
        }
        return vals;
    }

    public static double[][] getMatrix(double[][] m1, int r0, int r1, int c0, int c1) {
        assert (r0 <= r1 && c0 <= c1) : "Invalid range parameters.";
        assert (r1 <= m1.length && c1 <= m1[0].length) : "Matrix dimensions do not agree.";
        int rowdim = r1 - r0;
        int coldim = c1 - c0;
        double[][] X = new double[rowdim][coldim];
        for (int i = r0; i < r1; ++i) {
            System.arraycopy(m1[i], c0, X[i - r0], 0, coldim);
        }
        return X;
    }

    public static double[][] getMatrix(double[][] m1, int[] r, int[] c) {
        int rowdim = r.length;
        int coldim = c.length;
        double[][] X = new double[rowdim][coldim];
        for (int i = 0; i < rowdim; ++i) {
            double[] rowM = m1[r[i]];
            double[] rowX = X[i];
            for (int j = 0; j < coldim; ++j) {
                rowX[j] = rowM[c[j]];
            }
        }
        return X;
    }

    public static double[][] getMatrix(double[][] m1, int[] r, int c0, int c1) {
        assert (c0 <= c1) : "Invalid range parameters.";
        assert (c1 <= m1[0].length) : "Matrix dimensions do not agree.";
        int rowdim = r.length;
        int coldim = c1 - c0;
        double[][] X = new double[rowdim][coldim];
        for (int i = 0; i < rowdim; ++i) {
            System.arraycopy(m1[r[i]], c0, X[i], 0, coldim);
        }
        return X;
    }

    public static double[][] getMatrix(double[][] m1, int r0, int r1, int[] c) {
        assert (r0 <= r1) : "Invalid range parameters.";
        assert (r1 <= m1.length) : "Matrix dimensions do not agree.";
        int rowdim = r1 - r0;
        int coldim = c.length;
        double[][] X = new double[rowdim][coldim];
        for (int i = r0; i < r1; ++i) {
            double[] row = m1[i];
            double[] Xi = X[i - r0];
            for (int j = 0; j < coldim; ++j) {
                Xi[j] = row[c[j]];
            }
        }
        return X;
    }

    public static void setMatrix(double[][] m1, int r0, int r1, int c0, int c1, double[][] m2) {
        assert (r0 <= r1 && c0 <= c1) : "Invalid range parameters.";
        assert (r1 <= m1.length && c1 <= m1[0].length) : "Matrix dimensions do not agree.";
        int coldim = c1 - c0;
        for (int i = r0; i < r1; ++i) {
            System.arraycopy(m2[i - r0], 0, m1[i], c0, coldim);
        }
    }

    public static void setMatrix(double[][] m1, int[] r, int[] c, double[][] m2) {
        for (int i = 0; i < r.length; ++i) {
            double[] row1 = m1[r[i]];
            double[] row2 = m2[i];
            for (int j = 0; j < c.length; ++j) {
                row1[c[j]] = row2[j];
            }
        }
    }

    public static void setMatrix(double[][] m1, int[] r, int c0, int c1, double[][] m2) {
        assert (c0 <= c1) : "Invalid range parameters.";
        assert (c1 <= m1[0].length) : "Matrix dimensions do not agree.";
        for (int i = 0; i < r.length; ++i) {
            System.arraycopy(m2[i], 0, m1[r[i]], c0, c1 - c0);
        }
    }

    public static void setMatrix(double[][] m1, int r0, int r1, int[] c, double[][] m2) {
        assert (r0 <= r1) : "Invalid range parameters.";
        assert (r1 <= m1.length) : "Matrix dimensions do not agree.";
        for (int i = r0; i < r1; ++i) {
            double[] row1 = m1[i];
            double[] row2 = m2[i - r0];
            for (int j = 0; j < c.length; ++j) {
                row1[c[j]] = row2[j];
            }
        }
    }

    public static double[] getRow(double[][] m1, int r) {
        return (double[])m1[r].clone();
    }

    public static void setRow(double[][] m1, int r, double[] row) {
        int columndimension = VMath.getColumnDimensionality(m1);
        assert (row.length == columndimension) : "Dimensionalities do not agree.";
        System.arraycopy(row, 0, m1[r], 0, columndimension);
    }

    public static double[] getCol(double[][] m1, int col) {
        double[] ret = new double[m1.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = m1[i][col];
        }
        return ret;
    }

    public static void setCol(double[][] m1, int c, double[] column) {
        assert (column.length == m1.length) : "Dimensionalities do not agree.";
        for (int i = 0; i < m1.length; ++i) {
            m1[i][c] = column[i];
        }
    }

    public static double[][] transpose(double[][] m1) {
        int rowdim = m1.length;
        int coldim = VMath.getColumnDimensionality(m1);
        double[][] re = new double[coldim][rowdim];
        for (int i = 0; i < rowdim; ++i) {
            double[] row = m1[i];
            for (int j = 0; j < coldim; ++j) {
                re[j][i] = row[j];
            }
        }
        return re;
    }

    public static double[][] plus(double[][] m1, double[][] m2) {
        return VMath.plusEquals(VMath.copy(m1), m2);
    }

    public static double[][] plusTimes(double[][] m1, double[][] m2, double s2) {
        return VMath.plusTimesEquals(VMath.copy(m1), m2, s2);
    }

    public static double[][] plusEquals(double[][] m1, double[][] m2) {
        int rowdim = m1.length;
        int coldim = VMath.getColumnDimensionality(m1);
        assert (VMath.getRowDimensionality(m1) == VMath.getRowDimensionality(m2) && coldim == VMath.getColumnDimensionality(m2)) : "Matrix dimensions do not agree.";
        for (int i = 0; i < rowdim; ++i) {
            double[] row1 = m1[i];
            double[] row2 = m2[i];
            for (int j = 0; j < coldim; ++j) {
                int n = j;
                row1[n] = row1[n] + row2[j];
            }
        }
        return m1;
    }

    public static double[][] plusTimesEquals(double[][] m1, double[][] m2, double s2) {
        int rowdim = m1.length;
        int coldim = VMath.getColumnDimensionality(m1);
        assert (VMath.getRowDimensionality(m1) == VMath.getRowDimensionality(m2) && coldim == VMath.getColumnDimensionality(m2)) : "Matrix dimensions do not agree.";
        for (int i = 0; i < rowdim; ++i) {
            double[] row1 = m1[i];
            double[] row2 = m2[i];
            for (int j = 0; j < coldim; ++j) {
                int n = j;
                row1[n] = row1[n] + s2 * row2[j];
            }
        }
        return m1;
    }

    public static double[][] minus(double[][] m1, double[][] m2) {
        return VMath.minusEquals(VMath.copy(m1), m2);
    }

    public static double[][] minusTimes(double[][] m1, double[][] m2, double s2) {
        return VMath.minusTimesEquals(VMath.copy(m1), m2, s2);
    }

    public static double[][] minusEquals(double[][] m1, double[][] m2) {
        int columndimension = VMath.getColumnDimensionality(m1);
        assert (VMath.getRowDimensionality(m1) == VMath.getRowDimensionality(m2) && columndimension == VMath.getColumnDimensionality(m2)) : "Matrix dimensions do not agree.";
        for (int i = 0; i < m1.length; ++i) {
            double[] row1 = m1[i];
            double[] row2 = m2[i];
            for (int j = 0; j < columndimension; ++j) {
                int n = j;
                row1[n] = row1[n] - row2[j];
            }
        }
        return m1;
    }

    public static double[][] minusTimesEquals(double[][] m1, double[][] m2, double s2) {
        assert (VMath.getRowDimensionality(m1) == VMath.getRowDimensionality(m2) && VMath.getColumnDimensionality(m1) == VMath.getColumnDimensionality(m2)) : "Matrix dimensions do not agree.";
        for (int i = 0; i < m1.length; ++i) {
            double[] row1 = m1[i];
            double[] row2 = m2[i];
            for (int j = 0; j < row1.length; ++j) {
                int n = j;
                row1[n] = row1[n] - s2 * row2[j];
            }
        }
        return m1;
    }

    public static double[][] times(double[][] m1, double s1) {
        return VMath.timesEquals(VMath.copy(m1), s1);
    }

    public static double[][] timesEquals(double[][] m1, double s1) {
        int rowdim = m1.length;
        for (int i = 0; i < rowdim; ++i) {
            double[] row = m1[i];
            int j = 0;
            while (j < row.length) {
                int n = j++;
                row[n] = row[n] * s1;
            }
        }
        return m1;
    }

    public static double[][] times(double[][] m1, double[][] m2) {
        int rowdim1 = m1.length;
        int coldim1 = VMath.getColumnDimensionality(m1);
        int coldim2 = VMath.getColumnDimensionality(m2);
        assert (m2.length == coldim1) : "Matrix inner dimensions do not agree.";
        double[][] r2 = new double[rowdim1][coldim2];
        double[] Bcolj = new double[coldim1];
        for (int j = 0; j < coldim2; ++j) {
            for (int k = 0; k < coldim1; ++k) {
                Bcolj[k] = m2[k][j];
            }
            for (int i = 0; i < rowdim1; ++i) {
                double[] Arowi = m1[i];
                double s = 0.0;
                for (int k = 0; k < coldim1; ++k) {
                    s += Arowi[k] * Bcolj[k];
                }
                r2[i][j] = s;
            }
        }
        return r2;
    }

    public static double[] times(double[][] m1, double[] v2) {
        int rowdim = m1.length;
        int coldim = VMath.getColumnDimensionality(m1);
        assert (v2.length == coldim) : "Matrix inner dimensions do not agree.";
        double[] re = new double[rowdim];
        for (int i = 0; i < rowdim; ++i) {
            double[] Arowi = m1[i];
            double s = 0.0;
            for (int k = 0; k < coldim; ++k) {
                s += Arowi[k] * v2[k];
            }
            re[i] = s;
        }
        return re;
    }

    public static double[] transposeTimes(double[][] m1, double[] v2) {
        int rowdim = m1.length;
        int coldim = VMath.getColumnDimensionality(m1);
        assert (v2.length == rowdim) : "Matrix inner dimensions do not agree.";
        double[] re = new double[coldim];
        for (int i = 0; i < coldim; ++i) {
            double s = 0.0;
            for (int k = 0; k < rowdim; ++k) {
                s += m1[k][i] * v2[k];
            }
            re[i] = s;
        }
        return re;
    }

    public static double[][] transposeTimes(double[][] m1, double[][] m2) {
        int rowdim1 = m1.length;
        int coldim1 = VMath.getColumnDimensionality(m1);
        int coldim2 = VMath.getColumnDimensionality(m2);
        assert (m2.length == rowdim1) : "Matrix inner dimensions do not agree.";
        double[][] re = new double[coldim1][coldim2];
        double[] Bcolj = new double[rowdim1];
        for (int j = 0; j < coldim2; ++j) {
            for (int k = 0; k < rowdim1; ++k) {
                Bcolj[k] = m2[k][j];
            }
            for (int i = 0; i < coldim1; ++i) {
                double s = 0.0;
                for (int k = 0; k < rowdim1; ++k) {
                    s += m1[k][i] * Bcolj[k];
                }
                re[i][j] = s;
            }
        }
        return re;
    }

    public static double transposeTimesTimes(double[] v1, double[][] m2, double[] v3) {
        int rowdim = m2.length;
        int coldim = VMath.getColumnDimensionality(m2);
        assert (rowdim == v1.length) : "Matrix inner dimensions do not agree.";
        assert (coldim == v3.length) : "Matrix inner dimensions do not agree.";
        double sum = 0.0;
        for (int k = 0; k < rowdim; ++k) {
            double[] B_k = m2[k];
            double s = 0.0;
            for (int j = 0; j < coldim; ++j) {
                s += v3[j] * B_k[j];
            }
            sum += s * v1[k];
        }
        return sum;
    }

    public static double[][] timesTranspose(double[][] m1, double[][] m2) {
        int rowdim1 = m1.length;
        int coldim1 = VMath.getColumnDimensionality(m1);
        int rowdim2 = m2.length;
        assert (coldim1 == VMath.getColumnDimensionality(m2)) : "Matrix inner dimensions do not agree.";
        double[][] re = new double[rowdim1][rowdim2];
        for (int j = 0; j < rowdim2; ++j) {
            double[] Browj = m2[j];
            for (int i = 0; i < rowdim1; ++i) {
                double[] Arowi = m1[i];
                double s = 0.0;
                for (int k = 0; k < coldim1; ++k) {
                    s += Arowi[k] * Browj[k];
                }
                re[i][j] = s;
            }
        }
        return re;
    }

    public static double[][] transposeTimesTranspose(double[][] m1, double[][] m2) {
        assert (m1.length == VMath.getColumnDimensionality(m2)) : "Matrix inner dimensions do not agree.";
        double[][] re = new double[VMath.getColumnDimensionality(m1)][m2.length];
        double[] Acolj = new double[m1.length];
        for (int j = 0; j < re.length; ++j) {
            for (int k = 0; k < m1.length; ++k) {
                Acolj[k] = m1[k][j];
            }
            double[] Xrow = re[j];
            for (int i = 0; i < m2.length; ++i) {
                double[] Browi = m2[i];
                double s = 0.0;
                for (int k = 0; k < m1.length; ++k) {
                    s += Browi[k] * Acolj[k];
                }
                Xrow[i] = s;
            }
        }
        return re;
    }

    public static double[][] transposeDiagonalTimes(double[][] m1, double[] d2, double[][] m3) {
        int innerdim = d2.length;
        assert (m1.length == innerdim) : "Matrix inner dimensions do not agree.";
        assert (m3.length == innerdim) : "Matrix inner dimensions do not agree.";
        int coldim1 = VMath.getColumnDimensionality(m1);
        int coldim2 = VMath.getColumnDimensionality(m3);
        double[][] r = new double[coldim1][coldim2];
        double[] Acoli = new double[innerdim];
        for (int i = 0; i < coldim1; ++i) {
            double[] r_i = r[i];
            for (int k = 0; k < innerdim; ++k) {
                Acoli[k] = m1[k][i] * d2[k];
            }
            for (int j = 0; j < coldim2; ++j) {
                double s = 0.0;
                for (int k = 0; k < innerdim; ++k) {
                    s += Acoli[k] * m3[k][j];
                }
                r_i[j] = s;
            }
        }
        return r;
    }

    @Reference(authors="P. C. Mahalanobis", title="On the generalized distance in statistics", booktitle="Proceedings of the National Institute of Sciences of India. 2 (1)", bibkey="journals/misc/Mahalanobis36")
    public static double mahalanobisDistance(double[][] B, double[] a, double[] c) {
        int rowdim = B.length;
        int coldim = VMath.getColumnDimensionality(B);
        assert (rowdim == a.length) : "Matrix inner dimensions do not agree.";
        assert (coldim == c.length) : "Matrix inner dimensions do not agree.";
        assert (a.length == c.length) : "Vector dimensions do not agree.";
        double sum = 0.0;
        for (int k = 0; k < rowdim; ++k) {
            double[] B_k = B[k];
            double s = 0.0;
            for (int j = 0; j < coldim; ++j) {
                s += (a[j] - c[j]) * B_k[j];
            }
            sum += (a[k] - c[k]) * s;
        }
        return sum;
    }

    public static double[] getDiagonal(double[][] m1) {
        int dim = Math.min(VMath.getColumnDimensionality(m1), m1.length);
        double[] diagonal = new double[dim];
        for (int i = 0; i < dim; ++i) {
            diagonal[i] = m1[i][i];
        }
        return diagonal;
    }

    public static void normalizeColumns(double[][] m1) {
        int columndimension = VMath.getColumnDimensionality(m1);
        for (int col = 0; col < columndimension; ++col) {
            int row;
            double norm = 0.0;
            for (row = 0; row < m1.length; ++row) {
                double v = m1[row][col];
                norm += v * v;
            }
            if (!(norm > 0.0)) continue;
            norm = FastMath.sqrt(norm);
            for (row = 0; row < m1.length; ++row) {
                double[] dArray = m1[row];
                int n = col;
                dArray[n] = dArray[n] / norm;
            }
        }
    }

    public static double[][] appendColumns(double[][] m1, double[][] m2) {
        int columndimension = VMath.getColumnDimensionality(m1);
        int ccolumndimension = VMath.getColumnDimensionality(m2);
        assert (m1.length == m2.length) : "m.getRowDimension() != column.getRowDimension()";
        int rcolumndimension = columndimension + ccolumndimension;
        double[][] result = new double[m1.length][rcolumndimension];
        for (int i = 0; i < rcolumndimension; ++i) {
            if (i < columndimension) {
                VMath.setCol(result, i, VMath.getCol(m1, i));
                continue;
            }
            VMath.setCol(result, i, VMath.getCol(m2, i - columndimension));
        }
        return result;
    }

    public static double[][] orthonormalize(double[][] m1) {
        int columndimension = VMath.getColumnDimensionality(m1);
        double[][] v = VMath.copy(m1);
        for (int i = 1; i < columndimension; ++i) {
            double[] u_i = VMath.getCol(m1, i);
            double[] sum = new double[m1.length];
            for (int j = 0; j < i; ++j) {
                double[] v_j = VMath.getCol(v, j);
                double scalar = VMath.scalarProduct(u_i, v_j) / VMath.scalarProduct(v_j, v_j);
                VMath.plusEquals(sum, VMath.times(v_j, scalar));
            }
            double[] v_i = VMath.minus(u_i, sum);
            VMath.setCol(v, i, v_i);
        }
        VMath.normalizeColumns(v);
        return v;
    }

    public static double[][] solve(double[][] A, double[][] B) {
        int rows = A.length;
        int cols = A[0].length;
        return rows == cols ? new LUDecomposition(A, rows, cols).solve(B) : new QRDecomposition(A, rows, cols).solve(B);
    }

    public static double[] solve(double[][] A, double[] b) {
        int rows = A.length;
        int cols = A[0].length;
        return rows == cols ? new LUDecomposition(A, rows, cols).solve(b) : new QRDecomposition(A, rows, cols).solve(b);
    }

    public static double[][] inverse(double[][] A) {
        int rows = A.length;
        int cols = A[0].length;
        return rows == cols ? new LUDecomposition(A, rows, cols).inverse() : new QRDecomposition(A, rows, cols).inverse();
    }

    public static double normF(double[][] elements) {
        double f = 0.0;
        for (int i = 0; i < elements.length; ++i) {
            double[] row = elements[i];
            for (int j = 0; j < row.length; ++j) {
                double v = row[j];
                f += v * v;
            }
        }
        return FastMath.sqrt(f);
    }

    public static int hashCode(double[][] m1) {
        return Arrays.deepHashCode((Object[])m1);
    }

    public static boolean equals(double[][] m1, double[][] m2) {
        return Arrays.deepEquals((Object[])m1, (Object[])m2);
    }

    public static boolean almostEquals(double[][] m1, double[][] m2, double maxdelta) {
        if (m1 == m2) {
            return true;
        }
        if (m1 == null || m2 == null) {
            return false;
        }
        int rowdim = m1.length;
        int coldim = VMath.getColumnDimensionality(m1);
        if (rowdim != m2.length || coldim != VMath.getColumnDimensionality(m2)) {
            return false;
        }
        for (int i = 0; i < rowdim; ++i) {
            for (int j = 0; j < coldim; ++j) {
                if (!(Math.abs(m1[i][j] - m2[i][j]) > maxdelta)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean almostEquals(double[][] m1, double[][] m2) {
        return VMath.almostEquals(m1, m2, 1.0E-5);
    }

    public static boolean almostEquals(double[] m1, double[] m2, double maxdelta) {
        if (m1 == m2) {
            return true;
        }
        if (m1 == null || m2 == null) {
            return false;
        }
        int rowdim = m1.length;
        if (rowdim != m2.length) {
            return false;
        }
        for (int i = 0; i < rowdim; ++i) {
            if (!(Math.abs(m1[i] - m2[i]) > maxdelta)) continue;
            return false;
        }
        return true;
    }

    public static boolean almostEquals(double[] m1, double[] m2) {
        return VMath.almostEquals(m1, m2, 1.0E-5);
    }

    public static int getRowDimensionality(double[][] m1) {
        return m1.length;
    }

    public static int getColumnDimensionality(double[][] m1) {
        return m1[0].length;
    }

    public static double angle(double[] v1, double[] v2) {
        double r1;
        int k;
        int mindim = v1.length <= v2.length ? v1.length : v2.length;
        double s = 0.0;
        double e1 = 0.0;
        double e2 = 0.0;
        for (k = 0; k < mindim; ++k) {
            r1 = v1[k];
            double r2 = v2[k];
            s += r1 * r2;
            e1 += r1 * r1;
            e2 += r2 * r2;
        }
        for (k = mindim; k < v1.length; ++k) {
            r1 = v1[k];
            e1 += r1 * r1;
        }
        for (k = mindim; k < v2.length; ++k) {
            double r2 = v2[k];
            e2 += r2 * r2;
        }
        double a = FastMath.sqrt(s / e1 * (s / e2));
        return a < 1.0 ? a : 1.0;
    }

    public static double angle(double[] v1, double[] v2, double[] o) {
        double r1;
        double ok;
        int k;
        int mindim = v1.length <= v2.length ? v1.length : v2.length;
        double s = 0.0;
        double e1 = 0.0;
        double e2 = 0.0;
        for (k = 0; k < mindim; ++k) {
            ok = k < o.length ? o[k] : 0.0;
            r1 = v1[k] - ok;
            double r2 = v2[k] - ok;
            s += r1 * r2;
            e1 += r1 * r1;
            e2 += r2 * r2;
        }
        for (k = mindim; k < v1.length; ++k) {
            ok = k < o.length ? o[k] : 0.0;
            r1 = v1[k] - ok;
            e1 += r1 * r1;
        }
        for (k = mindim; k < v2.length; ++k) {
            ok = k < o.length ? o[k] : 0.0;
            double r2 = v2[k] - ok;
            e2 += r2 * r2;
        }
        double a = FastMath.sqrt(s / e1 * (s / e2));
        return a < 1.0 ? a : 1.0;
    }
}

