/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.linearalgebra.fitting;

import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.linearalgebra.fitting.FittingFunction;
import de.lmu.ifi.dbs.elki.math.linearalgebra.fitting.FittingFunctionResult;
import net.jafama.FastMath;

public class GaussianFittingFunction
implements FittingFunction {
    public static final GaussianFittingFunction STATIC = new GaussianFittingFunction();

    @Override
    public FittingFunctionResult eval(double x, double[] params) {
        int len = params.length;
        assert (len % 3 == 0);
        double y = 0.0;
        double[] gradients = new double[len];
        for (int i = 2; i < params.length; i += 3) {
            double stdpar = (x - params[i - 2]) / params[i - 1];
            double e = FastMath.exp(-0.5 * stdpar * stdpar);
            double localy = params[i] / (params[i - 1] * MathUtil.SQRTTWOPI) * e;
            y += localy;
            gradients[i - 2] = localy * stdpar;
            gradients[i - 1] = (stdpar * stdpar - 1.0) * localy;
            gradients[i] = e / (params[i - 1] * MathUtil.SQRTTWOPI);
        }
        return new FittingFunctionResult(y, gradients);
    }
}

