/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.linearalgebra.fitting;

import de.lmu.ifi.dbs.elki.math.linearalgebra.LinearEquationSystem;
import de.lmu.ifi.dbs.elki.math.linearalgebra.fitting.FittingFunction;
import de.lmu.ifi.dbs.elki.math.linearalgebra.fitting.FittingFunctionResult;
import java.util.Arrays;

public class LevenbergMarquardtMethod {
    public FittingFunction func;
    private double[] x;
    private double[] y;
    private double[] s;
    private int numparams;
    private double[] params;
    private double chisq;
    private int numfit;
    private boolean[] dofit;
    private double[][] covmat;
    private double[][] alpha;
    private double lambda;
    private double[] paramstry;
    private double[] beta;
    private double[] deltaparams;
    public int maxruns = 1000;
    public int maxsmall = 3;
    public double small = 0.01;

    public LevenbergMarquardtMethod(FittingFunction func, double[] params, boolean[] dofit, double[] x, double[] y, double[] s) {
        assert (x.length == y.length);
        assert (x.length == s.length);
        assert (params.length == dofit.length);
        this.func = func;
        this.x = x;
        this.y = y;
        this.s = s;
        this.params = params;
        this.dofit = dofit;
        this.numparams = this.params.length;
        this.numfit = 0;
        for (int i = 0; i < this.numparams; ++i) {
            if (!dofit[i]) continue;
            ++this.numfit;
        }
        assert (this.numfit > 0);
        this.covmat = new double[this.numfit][this.numfit];
        this.alpha = new double[this.numfit][this.numfit];
        this.lambda = 0.001;
        this.paramstry = (double[])params.clone();
        this.beta = new double[this.numfit];
        this.deltaparams = new double[this.numparams];
        this.chisq = this.simulateParameters(params);
    }

    private double simulateParameters(double[] curparams) {
        for (int i = 0; i < this.numfit; ++i) {
            Arrays.fill(this.alpha[i], 0.0);
        }
        Arrays.fill(this.beta, 0.0);
        double newchisq = 0.0;
        for (int di = 0; di < this.x.length; ++di) {
            FittingFunctionResult res = this.func.eval(this.x[di], curparams);
            double sigma2inv = 1.0 / (this.s[di] * this.s[di]);
            double deltay = this.y[di] - res.y;
            int i2 = 0;
            for (int i = 0; i < this.numfit; ++i) {
                if (!this.dofit[i]) continue;
                double wt = res.gradients[i] * sigma2inv;
                int j2 = 0;
                for (int j = 0; j <= i; ++j) {
                    if (!this.dofit[j]) continue;
                    double[] dArray = this.alpha[i2];
                    int n = j2++;
                    dArray[n] = dArray[n] + wt * res.gradients[j];
                }
                int n = i2++;
                this.beta[n] = this.beta[n] + deltay * wt;
            }
            newchisq += deltay * deltay * sigma2inv;
        }
        for (int i = 1; i < this.numfit; ++i) {
            for (int j = i + 1; j < this.numfit; ++j) {
                this.alpha[i][j] = this.alpha[j][i];
            }
        }
        return newchisq;
    }

    public void iterate() {
        int i = 0;
        while (i < this.numfit) {
            System.arraycopy(this.alpha[i], 0, this.covmat[i], 0, this.numfit);
            double[] dArray = this.covmat[i];
            int n = i++;
            dArray[n] = dArray[n] * (1.0 + this.lambda);
        }
        LinearEquationSystem ls = new LinearEquationSystem(this.covmat, this.beta);
        ls.solveByTotalPivotSearch();
        this.covmat = ls.getCoefficents();
        this.deltaparams = ls.getRHS();
        int i2 = 0;
        for (int i3 = 0; i3 < this.numparams; ++i3) {
            if (!this.dofit[i3]) continue;
            this.paramstry[i3] = this.params[i3] + this.deltaparams[i2++];
        }
        double newchisq = this.simulateParameters(this.paramstry);
        if (newchisq < this.chisq) {
            if (this.lambda * 0.1 > Double.MIN_NORMAL) {
                this.lambda *= 0.1;
            }
            this.chisq = newchisq;
            for (int i4 = 0; i4 < this.numfit; ++i4) {
                System.arraycopy(this.covmat[i4], 0, this.alpha[i4], 0, this.numfit);
                this.beta[i4] = this.deltaparams[i4];
            }
            System.arraycopy(this.paramstry, 0, this.params, 0, this.numparams);
        } else if (this.lambda * 10.0 < Double.MAX_VALUE) {
            this.lambda *= 10.0;
        }
    }

    public double[][] getCovmat() {
        double[][] fullcov = new double[this.numparams][this.numparams];
        int i2 = 0;
        for (int i = 0; i < this.numparams; ++i) {
            int j2 = 0;
            for (int j = 0; j < this.numparams; ++j) {
                double d = fullcov[i][j] = this.dofit[i] && this.dofit[j] ? this.covmat[i2][j2] : 0.0;
                if (!this.dofit[j]) continue;
                ++j2;
            }
            if (!this.dofit[i]) continue;
            ++i2;
        }
        return fullcov;
    }

    public double[] getParams() {
        return this.params;
    }

    public double getChiSq() {
        return this.chisq;
    }

    public void run() {
        int maxruns = this.maxruns;
        int maxsmall = this.maxsmall;
        double oldchi = this.getChiSq();
        while (maxruns-- > 0) {
            this.iterate();
            double newchi = this.getChiSq();
            double deltachi = newchi - oldchi;
            oldchi = newchi;
            if (!(deltachi < 0.0) || !(deltachi > -this.small) || --maxsmall >= 0) continue;
            break;
        }
    }
}

